/*
 * Decompiled with CFR 0.152.
 */
package ellax.base.error;

import ellax.base.error.ErrorTypes;
import java.util.Map;

public class Error {
    private int code;
    private String message;
    private Map<String, String> mExtras;
    private Object data;
    private int tag;

    public Error(int code) {
        this(code, null, null);
    }

    public Error(int code, String message) {
        this(code, message, null);
    }

    public Error(int code, String message, Object data) {
        this.code = code;
        this.message = message == null ? ErrorTypes.getMsg(code) : message;
        this.data = data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public boolean is(int code) {
        return this.code == code;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTag() {
        return this.tag;
    }

    public void setExtras(Map<String, String> extras) {
        this.mExtras = extras;
    }

    public String getExtra(String key) {
        if (this.mExtras == null) {
            return null;
        }
        return this.mExtras.get(key);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isNetworkError() {
        return this.code == -5000 || this.code == -5200 || this.code == -5400 || this.code == -5100 || this.code == -5300;
    }

    public boolean isBusinessError() {
        return this.code == -2000;
    }

    public boolean isSessionTimeOut() {
        return this.code == -4000;
    }
}

