/*
 * Decompiled with CFR 0.152.
 */
package ellax.base;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import ellax.base.BaseDelegate;
import ellax.base.EllaView;
import ellax.base.IProgress;
import ellax.base.error.Error;
import ellax.base.helper.ToastHelper;
import ellax.base.lifecycle.Lifecycle;
import ellax.base.lifecycle.LifecycleListener;
import ellax.base.lifecycle.LifecycleManager;
import ellax.base.transition.TransitionManager;
import ellax.base.transition.TransitionStateListener;
import org.joor.Reflect;

public class EllaBaseDialogFragment
extends AppCompatDialogFragment
implements Lifecycle,
EllaView,
TransitionStateListener {
    private BaseDelegate mDelegate;
    private LifecycleManager mLifecycleManager = new LifecycleManager();

    public int show(FragmentTransaction transaction, String tag) {
        throw new RuntimeException("do not call this method,use #show(FragmentManager,String) instead");
    }

    public void show(FragmentManager manager, String tag) {
        if (manager == null) {
            return;
        }
        if (this.isAdded()) {
            manager.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
        Reflect.on((Object)this).set("mDismissed", (Object)false);
        Reflect.on((Object)this).set("mShownByMe", (Object)true);
        FragmentTransaction ft = manager.beginTransaction();
        ft.add((Fragment)this, tag);
        ft.commitAllowingStateLoss();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(this.getLayoutFile(), container, false);
        return this.beforeViewAdd(view, container);
    }

    protected View beforeViewAdd(View view, ViewGroup container) {
        return view;
    }

    public int getLayoutFile() {
        return 0;
    }

    @Override
    public final void showProgress() {
        this.getBaseDelegate().showProgress();
    }

    @Override
    public final void update(long total, long current, float percent, String tag) {
        this.getBaseDelegate().update(total, current, percent, tag);
    }

    @Override
    public final void stopProgress() {
        this.getBaseDelegate().stopProgress();
    }

    protected IProgress provideProgress() {
        return null;
    }

    private BaseDelegate getBaseDelegate() {
        if (this.mDelegate == null) {
            this.mDelegate = new BaseDelegate((Fragment)this, this.provideProgress());
        }
        return this.mDelegate;
    }

    @Override
    public void handleError(Error error) {
        if (error.isNetworkError()) {
            this.handleNetworkError(error);
        } else if (error.is(-3000)) {
            this.handleEmptyDataError(error);
        } else {
            ToastHelper.showToast(error.getMessage());
        }
    }

    protected void handleNetworkError(Error error) {
        if (!TransitionManager.notifyPageStateChange((int)this.hashCode(), (int)0x7FFFFFFD)) {
            ToastHelper.showToast(error.getMessage());
        }
    }

    protected void handleEmptyDataError(Error error) {
        if (!TransitionManager.notifyPageStateChange((int)this.hashCode(), (int)0x7FFFFFFC)) {
            ToastHelper.showToast(error.getMessage());
        }
    }

    public void onViewStateChanged(int state, View view) {
    }

    public void onDestroyView() {
        this.mDelegate = null;
        super.onDestroyView();
    }

    public void addListener(LifecycleListener listener) {
        this.mLifecycleManager.addListener(listener);
    }

    public void removeListener(LifecycleListener listener) {
        this.mLifecycleManager.removeListener(listener);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLifecycleManager.onCreate();
    }

    public void onStart() {
        super.onStart();
        this.mLifecycleManager.onLifecycleStart();
    }

    public void onPause() {
        super.onPause();
        if (this.getActivity() != null && this.getActivity().isFinishing()) {
            this.mLifecycleManager.onLifecycleDestroy();
        }
    }

    public void onStop() {
        super.onStop();
        this.mLifecycleManager.onLifecycleStop();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mLifecycleManager.onLifecycleDestroy();
    }
}

