/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk.util;

import com.seewo.open.sdk.HttpRequest;
import com.seewo.open.sdk.HttpResponse;
import com.seewo.open.sdk.util.CodecUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class WebUtils {
    private static SSLContext ctx = null;
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;

    private WebUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse method(HttpRequest request) throws IOException {
        InputStream in;
        HttpResponse rsp;
        OutputStream out;
        HttpURLConnection conn;
        block9: {
            conn = null;
            out = null;
            rsp = new HttpResponse();
            in = null;
            try {
                int count;
                conn = WebUtils.getConnection(new URL(request.getServerUrl() + request.getPath() + request.getQueryString()), request.getHttpMethod(), request.getContentType());
                for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                    conn.setRequestProperty(entry.getKey(), CodecUtils.urlEncode(entry.getValue()));
                }
                conn.setConnectTimeout(request.getConnectTimeout());
                conn.setReadTimeout(request.getReadTimeout());
                if (request.getBody() != null && request.getBody().length != 0) {
                    out = conn.getOutputStream();
                    out.write(request.getBody());
                    out.flush();
                }
                rsp.setStatusCode(conn.getResponseCode());
                rsp.setPhrase(conn.getResponseMessage());
                rsp.setContentType(conn.getContentType());
                rsp.setHeaders(WebUtils.getResponseHeaders(conn));
                in = conn.getErrorStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                if (in != null) {
                    int count2;
                    int bufferSize = 262144;
                    byte[] buffer = new byte[bufferSize];
                    while ((count2 = in.read(buffer)) > 0) {
                        byteArrayOutputStream.write(buffer, 0, count2);
                    }
                    rsp.setBodyBuffer(byteArrayOutputStream.toByteArray());
                    break block9;
                }
                if (conn.getResponseCode() != 200) break block9;
                in = conn.getInputStream();
                int bufferSize = 262144;
                byte[] buffer = new byte[bufferSize];
                while ((count = in.read(buffer)) > 0) {
                    byteArrayOutputStream.write(buffer, 0, count);
                }
                rsp.setBodyBuffer(byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                WebUtils.close(out);
                WebUtils.close(in);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        WebUtils.close(out);
        WebUtils.close(in);
        if (conn != null) {
            conn.disconnect();
        }
        return rsp;
    }

    private static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    private static Map<String, String> getResponseHeaders(HttpURLConnection conn) {
        HashMap<String, String> pairs = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            List<String> value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            pairs.put(entry.getKey(), value.get(0));
        }
        return pairs;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(socketFactory);
            connHttps.setHostnameVerifier(verifier);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        conn.setRequestProperty("User-Agent", "x-sw-client- 2.0.1 - java");
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    static {
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);
            socketFactory = ctx.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return hostname.contains("seewo");
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

