/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SeewoStringUtils {
    private SeewoStringUtils() {
    }

    public static boolean areNotEmpty(String ... values) {
        for (String str : values) {
            if (!SeewoStringUtils.isEmptyEvenWhiteSpace(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyEvenWhiteSpace(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return SeewoStringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String setJoin(Set<String> set, String separator) {
        if (set.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String entry : set) {
            stringBuilder.append(entry).append(separator);
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    public static String mapJoin(Map<String, String> map, String connector, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append(connector).append(entry.getValue()).append(separator);
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }
}

