/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk.util;

import com.seewo.open.sdk.fastjson.JSON;
import com.seewo.open.sdk.fastjson.JSONException;
import com.seewo.open.sdk.fastjson.JSONObject;
import com.seewo.open.sdk.util.SeewoStringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;

public class CodecUtils {
    private static final String CHARSET = "UTF-8";

    private CodecUtils() {
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static byte[] string2byte(String str) {
        if (SeewoStringUtils.isEmpty(str)) {
            return new byte[0];
        }
        try {
            return str.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    public static String byte2string(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        try {
            return new String(bytes, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public static <T> Collection<T> parseJsonArray(String json, Class<T> tClass) {
        try {
            return JSON.parseArray(json, tClass);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static <T> T parseJsonObject(String json, Class<T> tClass) {
        try {
            return JSON.parseObject(json, tClass);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject parseJsonObject(String json) {
        try {
            return JSON.parseObject(json);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

