/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk;

import com.seewo.open.sdk.ParameterPosition;
import com.seewo.open.sdk.fastjson.JSON;
import com.seewo.open.sdk.util.CodecUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class OpenApiParam {
    public static final String EMPTY_BODY = "";
    private Field[] declaredFields;
    private Map<String, String> pathVariables;
    private Map<String, String> headers;
    private Map<String, String> queries;
    private String body;

    protected Field[] declaredFields() {
        if (this.declaredFields != null) {
            return this.declaredFields;
        }
        this.declaredFields = this.getClass().getDeclaredFields();
        return this.declaredFields;
    }

    public Map<String, String> getPathVariables() {
        if (this.pathVariables != null) {
            return this.pathVariables;
        }
        this.initParams();
        return this.getPathVariables();
    }

    private synchronized void initParams() {
        this.pathVariables = new HashMap<String, String>();
        this.headers = new HashMap<String, String>();
        this.queries = new HashMap<String, String>();
        this.body = EMPTY_BODY;
        for (Field field : this.declaredFields()) {
            String key;
            Annotation annotation = field.getAnnotation(ParameterPosition.PathVariable.class);
            if (annotation != null) {
                key = annotation.value();
                this.pathVariables.put(key, CodecUtils.urlEncode(String.valueOf(this.getValueFromField(field))));
                continue;
            }
            annotation = field.getAnnotation(ParameterPosition.Query.class);
            if (annotation != null) {
                key = ((ParameterPosition.Query)annotation).value();
                this.queries.put(key, String.valueOf(this.getValueFromField(field)));
                continue;
            }
            annotation = field.getAnnotation(ParameterPosition.Header.class);
            if (annotation != null) {
                key = ((ParameterPosition.Header)annotation).value();
                this.headers.put(key, String.valueOf(this.getValueFromField(field)));
                continue;
            }
            if (field.getAnnotation(ParameterPosition.RequestArray.class) != null) {
                if (!Collection.class.isAssignableFrom(field.getType())) continue;
                this.body = JSON.toJSONString(this.getValueFromField(field), true);
                continue;
            }
            this.body = JSON.toJSONString(this.getValueFromField(field), true);
        }
    }

    private Object getValueFromField(Field field) {
        field.setAccessible(true);
        try {
            return field.get(this);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Map<String, String> getQueries() {
        if (this.queries != null) {
            return this.queries;
        }
        this.initParams();
        return this.getQueries();
    }

    public Map<String, String> getHeaders() {
        if (this.headers != null) {
            return this.headers;
        }
        this.initParams();
        return this.getHeaders();
    }

    public String getBody() {
        if (this.body != null) {
            return this.body;
        }
        this.initParams();
        return this.getBody();
    }

    public String toString() {
        return this.getClass() + "{pathVariables=" + this.pathVariables + ", headers=" + this.headers + ", queries=" + this.queries + ", body='" + this.body + '\'' + '}';
    }
}

