/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk;

import com.seewo.open.sdk.HttpRequest;
import com.seewo.open.sdk.HttpResponse;
import com.seewo.open.sdk.OpenApiParam;
import com.seewo.open.sdk.OpenApiRequest;
import com.seewo.open.sdk.OpenApiResult;
import com.seewo.open.sdk.SeewoApiException;
import com.seewo.open.sdk.SeewoClient;
import com.seewo.open.sdk.auth.Account;
import com.seewo.open.sdk.util.AntPathMatcher;
import com.seewo.open.sdk.util.SeewoStringUtils;
import com.seewo.open.sdk.util.SignUtils;
import com.seewo.open.sdk.util.WebUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DefaultSeewoClient
implements SeewoClient {
    private Account account;
    private static AntPathMatcher PATH_MATCHER = new AntPathMatcher();

    public DefaultSeewoClient(Account account) {
        this.account = account;
    }

    @Override
    public <R extends OpenApiResult, P extends OpenApiParam> R invoke(OpenApiRequest<P, R> request) {
        this.setParam(request);
        HttpResponse response = this.execute(request);
        this.errorDetect(response);
        try {
            return (R)((OpenApiResult)request.getResponseClass().getConstructor(HttpResponse.class).newInstance(response));
        }
        catch (IllegalAccessException e) {
            throw new SeewoApiException(400, "\u6784\u9020\u51fd\u6570" + request.getResponseClass() + "(com.seewo.open.sdk.HttpResponse) \u4e0d\u662f\u5171\u6709\u7684");
        }
        catch (NoSuchMethodException e) {
            throw new SeewoApiException(400, "\u6ca1\u6709\u627e\u5230\u5171\u6709\u6784\u9020\u51fd\u6570" + request.getResponseClass() + "(com.seewo.open.sdk.HttpResponse)");
        }
        catch (Exception e) {
            throw new SeewoApiException(e);
        }
    }

    private void errorDetect(HttpResponse response) {
        if (response.getStatusCode() != 200) {
            String message = response.getHeaders().get("x-sw-message");
            if (SeewoStringUtils.isEmpty(message)) {
                message = response.getPhrase();
            }
            throw new SeewoApiException(response.getStatusCode(), message);
        }
    }

    private <R extends OpenApiResult, P extends OpenApiParam> void setParam(OpenApiRequest<P, R> request) {
        String realPath = this.pattern2path(request.getPathVariables(), request.getPath());
        Map<String, String> extraHeaders = this.extraHeaders(request.getHeaders());
        request.addHeader("x-sw-app-id", this.account.getAppId());
        request.addHeader("x-sw-req-path", realPath);
        request.addHeader("x-sw-version", "2");
        request.addHeader("x-sw-timestamp", String.valueOf(System.currentTimeMillis()));
        request.addHeader("x-sw-sign-headers", SeewoStringUtils.setJoin(extraHeaders.keySet(), ","));
        request.addHeader("x-sw-sign-type", this.account.getSignType());
        if (request.getBody().length != 0) {
            request.addHeader("x-sw-content-md5", this.md5(request.getBody()));
        }
        request.addHeader("x-sw-sign", this.sign(request));
        request.setPath(realPath);
    }

    private String md5(byte[] body) {
        return SignUtils.getContentMD5(body);
    }

    private Map<String, String> extraHeaders(Map<String, String> headers) {
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (entry.getKey().startsWith("x-sw-") || entry.getValue() == null) continue;
            extraHeaders.put(entry.getKey(), entry.getValue());
        }
        return extraHeaders;
    }

    private <R extends OpenApiResult, P extends OpenApiParam> String sign(OpenApiRequest<P, R> request) {
        HashMap<String, String> signParam = new HashMap<String, String>(request.getQueries());
        signParam.putAll(request.getHeaders());
        signParam.remove("x-sw-sign");
        String sign = null;
        try {
            sign = SignUtils.signRequest(signParam, this.account.getAppSecret(), this.account.getSignType());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sign;
    }

    @Override
    public HttpResponse execute(HttpRequest request) {
        try {
            return WebUtils.method(request);
        }
        catch (IOException e) {
            throw new SeewoApiException(e);
        }
    }

    private String pattern2path(Map<String, String> pathVars, String pattern) {
        if (pathVars.isEmpty()) {
            return pattern;
        }
        Map<String, String> varMap = PATH_MATCHER.extractUriTemplateVariables(pattern, pattern);
        String path = pattern;
        for (Map.Entry<String, String> entry : varMap.entrySet()) {
            path = path.replace(entry.getValue(), pathVars.get(entry.getKey()));
        }
        return path;
    }
}

