/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.studystation.library.sharedlogin.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.seewo.studystation.library.sharedlogin.R;
import com.seewo.studystation.library.sharedlogin.common.Utils;

public class SimpleAppIconView
extends ImageView {
    private final Paint cleanPaint = new Paint(1);
    private final PorterDuffXfermode dstInFerMode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private Bitmap completeBitmap;
    private Bitmap backgroundBitmap;

    public SimpleAppIconView(Context context) {
        this(context, null);
    }

    public SimpleAppIconView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SimpleAppIconView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, this.cleanPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Context context = this.getContext();
        this.backgroundBitmap = Utils.drawableToBitmap(context.getDrawable(R.drawable.sharedlogin_app_icon_bg), w, h);
        this.completeBitmap = Utils.drawableToBitmap(context.getDrawable(R.drawable.sharedlogin_app_icon_bg_alpha), w, h);
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        this.backgroundBitmap.setDensity(this.getResources().getDisplayMetrics().densityDpi);
        canvas.drawBitmap(this.backgroundBitmap, 0.0f, 0.0f, this.cleanPaint);
        canvas.save();
        Bitmap scaleBitmap = Utils.drawableToBitmap(this.getDrawable(), this.getWidth(), this.getHeight());
        scaleBitmap.setDensity(this.getResources().getDisplayMetrics().densityDpi);
        canvas.drawBitmap(scaleBitmap, 0.0f, 0.0f, this.cleanPaint);
        this.cleanPaint.setXfermode((Xfermode)this.dstInFerMode);
        canvas.drawBitmap(this.backgroundBitmap, 0.0f, 0.0f, this.cleanPaint);
        this.completeBitmap.setDensity(this.getResources().getDisplayMetrics().densityDpi);
        canvas.drawBitmap(this.completeBitmap, 0.0f, 0.0f, this.cleanPaint);
        this.cleanPaint.setXfermode(null);
        canvas.restore();
    }
}

