/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.studystation.library.sharedlogin.ui;

import android.app.Activity;
import android.content.Context;
import android.graphics.Outline;
import android.os.Bundle;
import android.util.Base64;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.TextView;
import com.seewo.studystation.library.sharedlogin.R;
import com.seewo.studystation.library.sharedlogin.SharedLoginAuthTask;
import com.seewo.studystation.library.sharedlogin.StudyStationAccount;
import com.seewo.studystation.library.sharedlogin.StudyStationSharedLogin;
import com.seewo.studystation.library.sharedlogin.StudyStationSharedLoginOptions;
import com.seewo.studystation.library.sharedlogin.common.AESHelper;
import com.seewo.studystation.library.sharedlogin.common.HttpTask;
import com.seewo.studystation.library.sharedlogin.common.Utils;
import com.seewo.studystation.library.sharedlogin.ui.SimpleAppIconView;
import org.json.JSONObject;

public class LoginActivity
extends Activity {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sharedlogin_activity_login);
        View layoutContainer = this.findViewById(R.id.layoutContainer);
        layoutContainer.setClipToOutline(true);
        layoutContainer.setOutlineProvider(new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                float radius = Utils.dp2px((Context)LoginActivity.this, 32.0f);
                outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), radius);
            }
        });
        SimpleAppIconView appIconView = (SimpleAppIconView)this.findViewById(R.id.appIconView);
        appIconView.setImageDrawable(Utils.getAppIcon((Context)this));
        ((TextView)this.findViewById(R.id.textViewName)).setText((CharSequence)Utils.getAppName((Context)this));
        this.findViewById(R.id.textViewDisagree).setOnClickListener(v -> {
            StudyStationSharedLogin.setSharedLoginResult((Context)this, null, 1003, "");
            this.finish();
        });
        this.findViewById(R.id.textViewAgree).setOnClickListener(v -> new SharedLoginAuthTask(new HttpTask.Callback(){

            @Override
            public void onLoading() {
                if (LoginActivity.this.isFinishing()) {
                    return;
                }
                LoginActivity.this.findViewById(R.id.layoutLoading).setVisibility(0);
            }

            @Override
            public void onFinished(int errorCode, String result) {
                if (LoginActivity.this.isFinishing()) {
                    return;
                }
                if (errorCode != 0 || result == null) {
                    StudyStationSharedLogin.setSharedLoginResult((Context)LoginActivity.this, null, errorCode, result);
                } else {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        StudyStationAccount account = new StudyStationAccount();
                        account.setNickname(jsonObject.optString("userName", ""));
                        account.setAvatar(jsonObject.optString("avatar", ""));
                        account.setPhone(LoginActivity.this.decryptPhone(jsonObject.optString("encryptedPhone", "")));
                        account.setExtraData(jsonObject.optString("infoExtAsString", ""));
                        if (account.isValid()) {
                            StudyStationSharedLogin.setSharedLoginResult((Context)LoginActivity.this, account, 0, "");
                        } else {
                            StudyStationSharedLogin.setSharedLoginResult((Context)LoginActivity.this, null, 1, result);
                        }
                    }
                    catch (Exception e) {
                        StudyStationSharedLogin.setSharedLoginResult((Context)LoginActivity.this, null, 1, e.toString());
                    }
                }
                LoginActivity.this.finish();
            }
        }).requestAuth((Context)this));
    }

    private String decryptPhone(String encryptedPhone) {
        if (encryptedPhone.isEmpty()) {
            return "";
        }
        StudyStationSharedLoginOptions options = StudyStationSharedLogin.getOptions();
        String appId = options.getAppId();
        String secretKey = options.getSecretKey();
        String infoMd5 = Base64.encodeToString((byte[])secretKey.getBytes(), (int)2);
        String encryptKey = Utils.toLength(appId, 16);
        String encryptIv = Utils.toLength(infoMd5, 16);
        return AESHelper.decrypt(Base64.decode((byte[])encryptedPhone.getBytes(), (int)2), encryptKey, encryptIv);
    }

    public void onBackPressed() {
    }
}

