/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.studystation.library.sharedlogin.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.security.MessageDigest;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static String getStringFromContentProvider(Context context, String uri, String key) {
        return Utils.getStringFromContentProvider(context, uri, key, null);
    }

    public static String getStringFromContentProvider(Context context, String uri, String key, String[] selectionArgs) {
        Cursor cursor = context.getContentResolver().query(Uri.parse((String)uri), new String[]{key}, null, selectionArgs, null);
        String result = null;
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                result = cursor.getString(cursor.getColumnIndex(key));
            }
            cursor.close();
        }
        return result;
    }

    public static boolean isLauncherSupportSharedLogin(Context context) {
        try {
            String appPkgName = "com.seewo.studystation.launcher";
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(appPkgName, 128);
            Bundle metaData = applicationInfo.metaData;
            if (metaData == null) {
                return false;
            }
            return metaData.getBoolean("support_shared_login", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static Object getMetaData(@NotNull Context context, @NotNull String metaDataName) {
        String packageName = context.getPackageName();
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 128);
            return appInfo == null ? null : appInfo.metaData.get(metaDataName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            return (String)packageManager.getApplicationLabel(applicationInfo);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Drawable getAppIcon(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            return packageManager.getApplicationIcon(applicationInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static String getAppSignSha1(Context context) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            byte[] cert = info.signatures[0].toByteArray();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(cert);
            StringBuilder hexString = new StringBuilder();
            for (byte b : publicKey) {
                String appendString = Integer.toHexString(0xFF & b).toUpperCase(Locale.US);
                if (appendString.length() == 1) {
                    hexString.append("0");
                }
                hexString.append(appendString);
                hexString.append(":");
            }
            String result = hexString.toString();
            return result.substring(0, result.length() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable, int width, int height) {
        if (drawable == null || width <= 0 || height <= 0) {
            return null;
        }
        Rect bounds = drawable.getBounds();
        int oldLeft = bounds.left;
        int oldTop = bounds.top;
        int oldRight = bounds.right;
        int oldBottom = bounds.bottom;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(new Canvas(bitmap));
        drawable.setBounds(oldLeft, oldTop, oldRight, oldBottom);
        return bitmap;
    }

    public static float dp2px(Context context, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static String toLength(String text, int targetLength) {
        int length;
        String finalText = "";
        if (text != null) {
            finalText = text.trim();
        }
        if ((length = finalText.length()) == targetLength) {
            return finalText;
        }
        if (length > targetLength) {
            return finalText.substring(0, targetLength);
        }
        int offset = targetLength - length;
        StringBuilder sb = new StringBuilder();
        sb.append(finalText);
        for (int i = 0; i < offset; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }
}

