/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.studystation.library.sharedlogin.common;

import android.os.AsyncTask;
import com.seewo.open.sdk.DefaultSeewoClient;
import com.seewo.open.sdk.OpenApiRequest;
import com.seewo.open.sdk.auth.Account;
import com.seewo.studystation.library.sharedlogin.StudyStationSharedLogin;
import com.seewo.studystation.library.sharedlogin.common.Logger;
import com.seewo.studystation.library.sharedlogin.model.ExternalAppLoginGetUserInfoParam;
import com.seewo.studystation.library.sharedlogin.model.ExternalAppLoginGetUserInfoRequest;
import com.seewo.studystation.library.sharedlogin.model.ExternalAppLoginGetUserInfoResult;
import com.seewo.studystation.library.sharedlogin.model.ResponseModel;
import java.util.Map;

public class HttpTask
extends AsyncTask<Object, Void, ResponseModel> {
    private final Callback callback;

    public HttpTask(Callback callback) {
        this.callback = callback;
    }

    protected void onPreExecute() {
        this.callback.onLoading();
    }

    protected ResponseModel doInBackground(Object ... params) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.postRequest((Map)params[0]);
    }

    protected void onPostExecute(ResponseModel result) {
        block8: {
            if (result == null) {
                this.callback.onFinished(1, "result is null");
                return;
            }
            if (result.getResponse().isEmpty()) {
                this.callback.onFinished(1, result.getErrorMessage());
            } else if (result.getCode() == 200) {
                try {
                    String response = result.getResponse();
                    if (response.isEmpty()) {
                        this.callback.onFinished(1, "response is empty");
                        break block8;
                    }
                    this.callback.onFinished(0, response);
                }
                catch (Exception e) {
                    this.callback.onFinished(1, result.getErrorMessage());
                }
            } else {
                this.callback.onFinished(result.getCode(), result.getErrorMessage());
            }
        }
    }

    private ResponseModel postRequest(Map<String, String> params) {
        try {
            String appId = params.get("appId");
            String secretKey = params.get("secretKey");
            String appSignSha1 = params.get("appSignSha1");
            String packageName = params.get("packageName");
            String encryptedToken = params.get("encryptedToken");
            DefaultSeewoClient seewoClient = new DefaultSeewoClient(new Account(appId, secretKey));
            ExternalAppLoginGetUserInfoParam param = new ExternalAppLoginGetUserInfoParam();
            ExternalAppLoginGetUserInfoParam.RequestBody requestBody = ExternalAppLoginGetUserInfoParam.RequestBody.builder().build();
            param.setRequestBody(requestBody);
            ExternalAppLoginGetUserInfoParam.ExternalLoginParamDto externalLoginParamDto = ExternalAppLoginGetUserInfoParam.ExternalLoginParamDto.builder().token(encryptedToken).appId(appId).build();
            requestBody.setExternalLoginParamDto(externalLoginParamDto);
            param.setRequestBody(requestBody);
            ExternalAppLoginGetUserInfoRequest request = new ExternalAppLoginGetUserInfoRequest(param);
            request.addHeader("x-sw-apk-sign", appSignSha1);
            request.addHeader("x-sw-apk-package", packageName);
            if (StudyStationSharedLogin.useSandboxEnv) {
                request.setServerUrl("https://openapi.test.seewo.com");
            }
            Logger.logI("HttpTask \u5165\u53c2\uff1a" + (Object)((Object)request));
            ExternalAppLoginGetUserInfoResult result = (ExternalAppLoginGetUserInfoResult)seewoClient.invoke((OpenApiRequest)request);
            Logger.logI("HttpTask \u51fa\u53c2\uff1a" + (Object)((Object)result));
            return new ResponseModel(result.getStatusCode(), "", result.getBody());
        }
        catch (Exception e) {
            Logger.logE("HttpTask postRequest Exception\uff1a" + e.getMessage());
            return new ResponseModel(1, e.getMessage(), "");
        }
    }

    public static interface Callback {
        public void onLoading();

        public void onFinished(int var1, String var2);
    }
}

