/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.studystation.library.sharedlogin;

import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.widget.Toast;
import com.seewo.studystation.library.sharedlogin.OnSharedLoginCallback;
import com.seewo.studystation.library.sharedlogin.OnSharedLoginInvalidListener;
import com.seewo.studystation.library.sharedlogin.StudyStationAccount;
import com.seewo.studystation.library.sharedlogin.StudyStationSharedLoginConfiguration;
import com.seewo.studystation.library.sharedlogin.StudyStationSharedLoginOptions;
import com.seewo.studystation.library.sharedlogin.common.Logger;
import com.seewo.studystation.library.sharedlogin.common.PreferenceUtil;
import com.seewo.studystation.library.sharedlogin.common.Utils;
import com.seewo.studystation.library.sharedlogin.ui.LoginActivity;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudyStationSharedLogin {
    private static OnSharedLoginCallback loginCallback = null;
    private static StudyStationSharedLoginOptions options = null;
    private static final List<OnSharedLoginInvalidListener> onSharedLoginInvalidListeners = new ArrayList<OnSharedLoginInvalidListener>();
    private static ContentObserver encryptedTokenObserver = null;
    protected static final String URI_USER_ENCRYPTED_TOKEN = "content://com.seewo.studystation.login.UserDataProviderV2.encrypted/user_token";
    public static boolean useSandboxEnv = false;

    public static void init(@NotNull Context context, @NotNull Boolean isDebug) {
        StudyStationSharedLogin.init(isDebug, (StudyStationSharedLoginOptions options) -> {
            Object appId = Utils.getMetaData(context, "SS_SHARED_LOGIN_APP_ID");
            Object secretKey = Utils.getMetaData(context, "SS_SHARED_LOGIN_SECRET_KEY");
            Object logTag = Utils.getMetaData(context, "SS_SHARED_LOGIN_LOG_TAG");
            options.setAppId(appId == null ? "" : appId.toString());
            options.setSecretKey(secretKey == null ? "" : secretKey.toString());
            options.setLogTag(logTag == null ? "" : logTag.toString());
        });
    }

    public static void init(@NotNull Boolean isDebug, @NotNull StudyStationSharedLoginConfiguration configuration) {
        String errorMsg;
        StudyStationSharedLoginOptions options = new StudyStationSharedLoginOptions();
        configuration.configure(options);
        StudyStationSharedLogin.options = options;
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (TextUtils.isEmpty((CharSequence)options.getAppId())) {
            errorMsgBuilder.append(", secret id is not set");
        }
        if (TextUtils.isEmpty((CharSequence)options.getSecretKey())) {
            errorMsgBuilder.append(", secret key is not set");
        }
        if (!TextUtils.isEmpty((CharSequence)(errorMsg = errorMsgBuilder.toString()))) {
            throw new IllegalStateException("StudyStation shared login init error" + errorMsg);
        }
        Logger.isDebug = isDebug;
        String logTag = options.getLogTag();
        if (!TextUtils.isEmpty((CharSequence)logTag)) {
            Logger.tag = logTag;
        }
    }

    @NotNull
    public static Boolean isSupported(Context context) {
        return Utils.isLauncherSupportSharedLogin(context);
    }

    public static void requestSharedLogin(Context context, OnSharedLoginCallback callback) {
        if (useSandboxEnv) {
            Toast.makeText((Context)context, (CharSequence)"\u5f53\u524d\u4f7f\u7528\u6d4b\u8bd5\u6c99\u7bb1\u73af\u5883\uff0c\u4ec5\u5185\u90e8\u8c03\u8bd5\u4f7f\u7528\uff0c\u5916\u90e8\u6b63\u5f0f\u4e0d\u53ef\u4f7f\u7528", (int)0).show();
        }
        if (!StudyStationSharedLogin.isSupported(context).booleanValue()) {
            callback.onSharedLogin(null, 1000, "not support shared login");
            return;
        }
        if (StudyStationSharedLogin.getEncryptedToken(context).isEmpty()) {
            callback.onSharedLogin(null, 1001, "not login");
            return;
        }
        loginCallback = callback;
        context.startActivity(new Intent(context, LoginActivity.class));
    }

    public static void setSharedLoginResult(@NotNull Context context, @Nullable StudyStationAccount account, int errorCode, String errorMessage) {
        if (errorCode == 0 && account != null && account.isValid()) {
            String encryptedToken = StudyStationSharedLogin.getEncryptedToken(context);
            PreferenceUtil.setEncryptedToken(context, encryptedToken);
        } else {
            PreferenceUtil.setEncryptedToken(context, "");
        }
        if (loginCallback != null) {
            loginCallback.onSharedLogin(account, errorCode, errorMessage);
        }
        loginCallback = null;
    }

    public static void logoutSharedAccount(Context context) {
        PreferenceUtil.setEncryptedToken(context, "");
    }

    @NotNull
    public static Boolean isSharedLoginInvalid(Context context) {
        String encryptedToken = StudyStationSharedLogin.getEncryptedToken(context);
        return !encryptedToken.equals(PreferenceUtil.getEncryptedToken(context));
    }

    private static String getEncryptedToken(Context context) {
        StudyStationSharedLoginOptions options = StudyStationSharedLogin.getOptions();
        String appId = options.getAppId();
        String secretKey = options.getSecretKey();
        String encryptedToken = Utils.getStringFromContentProvider(context, URI_USER_ENCRYPTED_TOKEN, "token", new String[]{appId, secretKey});
        return encryptedToken == null ? "" : encryptedToken;
    }

    public static void addOnSharedLoginInvalidListener(Context context, @NotNull OnSharedLoginInvalidListener listener) {
        onSharedLoginInvalidListeners.add(listener);
        if (onSharedLoginInvalidListeners.size() == 1) {
            encryptedTokenObserver = new EncryptedTokenObserver(context, new Handler());
            context.getContentResolver().registerContentObserver(Uri.parse((String)URI_USER_ENCRYPTED_TOKEN), true, encryptedTokenObserver);
        }
    }

    public static void removeOnSharedLoginInvalidListener(Context context, @NotNull OnSharedLoginInvalidListener listener) {
        onSharedLoginInvalidListeners.remove(listener);
        if (onSharedLoginInvalidListeners.size() == 0) {
            context.getContentResolver().unregisterContentObserver(encryptedTokenObserver);
            encryptedTokenObserver = null;
        }
    }

    public static StudyStationSharedLoginOptions getOptions() {
        return options;
    }

    public static String getOptionsString() {
        return options == null ? "" : options.toString();
    }

    public static class EncryptedTokenObserver
    extends ContentObserver {
        private final Context applicationContext;

        public EncryptedTokenObserver(Context context, Handler handler) {
            super(handler);
            this.applicationContext = context.getApplicationContext();
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            String token = Utils.getStringFromContentProvider(this.applicationContext, StudyStationSharedLogin.URI_USER_ENCRYPTED_TOKEN, "token");
            if (token == null || token.isEmpty()) {
                PreferenceUtil.setEncryptedToken(this.applicationContext, "");
                for (OnSharedLoginInvalidListener listener : onSharedLoginInvalidListeners) {
                    listener.onSharedLoginInvalid();
                }
            }
        }
    }
}

