/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.studystation.library.sharedlogin;

import android.content.Context;
import com.seewo.studystation.library.sharedlogin.StudyStationSharedLogin;
import com.seewo.studystation.library.sharedlogin.StudyStationSharedLoginOptions;
import com.seewo.studystation.library.sharedlogin.common.HttpTask;
import com.seewo.studystation.library.sharedlogin.common.Utils;
import java.util.HashMap;

public class SharedLoginAuthTask
extends HttpTask {
    public SharedLoginAuthTask(HttpTask.Callback callback) {
        super(callback);
    }

    public void requestAuth(Context context) {
        StudyStationSharedLoginOptions options = StudyStationSharedLogin.getOptions();
        String appId = options.getAppId();
        String secretKey = options.getSecretKey();
        String encryptedToken = this.getEncryptedToken(context, appId, secretKey);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appId", appId);
        params.put("secretKey", secretKey);
        params.put("appSignSha1", Utils.getAppSignSha1(context));
        params.put("packageName", context.getPackageName());
        params.put("encryptedToken", encryptedToken);
        this.execute(new Object[]{params});
    }

    private String getEncryptedToken(Context context, String appId, String secretKey) {
        String encryptedToken = Utils.getStringFromContentProvider(context, "content://com.seewo.studystation.login.UserDataProviderV2.encrypted/user_token", "token", new String[]{appId, secretKey});
        return encryptedToken == null ? "" : encryptedToken;
    }
}

