/*
 * Decompiled with CFR 0.152.
 */
package com.ko.http.request;

import com.ko.http.KoHttpConfig;
import com.ko.http.KoHttpUtils;
import com.ko.http.config.IRequestCache;
import com.ko.http.config.IRequestClient;
import com.ko.http.config.IRequestGlobalInfoCreator;
import com.ko.http.config.IRequestHandler;
import com.ko.http.config.IRequestHost;
import com.ko.http.config.IRequestInterceptor;
import com.ko.http.config.IRequestOther;
import com.ko.http.config.IRequestServer;
import com.ko.http.config.impl.EasyRequestServer;
import com.ko.http.exception.KoCallIOException;
import com.ko.http.model.CacheMode;
import com.ko.http.model.HttpHeaders;
import com.ko.http.model.HttpParams;
import com.ko.http.scope.KoHttpGlobalScope;
import com.ko.http.tools.KoHttpLog;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\fH\u0004J\u0018\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020H2\u0006\u0010L\u001a\u00020\u0010H&J)\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ\u001e\u0010U\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010V2\u0006\u0010W\u001a\u00020!H\u0016J\u001e\u0010X\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010V2\u0006\u0010W\u001a\u00020!H\u0016J\u0016\u0010Y\u001a\u00020Z2\u0006\u0010L\u001a\u00020\u00102\u0006\u0010I\u001a\u00020\fJ)\u0010[\u001a\u0002H\\\"\u0006\b\u0000\u0010\\\u0018\u00012\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010]J/\u0010^\u001a\u0002H\\\"\u0004\b\u0000\u0010\\2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ\u0010\u0010_\u001a\u00020`2\u0006\u0010R\u001a\u00020SH\u0002J\u0006\u0010a\u001a\u00020\u001aJ\b\u0010b\u001a\u00020\u001aH&J\b\u0010c\u001a\u00020dH\u0016J\b\u0010e\u001a\u00020\u0014H\u0016J\u0011\u0010f\u001a\u00020S\"\u0006\b\u0000\u0010\\\u0018\u0001H\u0086\bJ\b\u0010g\u001a\u00020'H\u0016J\u0006\u0010h\u001a\u00020\fJ\u0006\u0010i\u001a\u00020\u0010J\b\u0010j\u001a\u00020\u001aH\u0016J\u000e\u0010k\u001a\u00020\u00002\u0006\u0010k\u001a\u000203J\b\u0010l\u001a\u00020\u0000H\u0002J\u000e\u0010m\u001a\u00020\u00002\u0006\u0010m\u001a\u00020?J\b\u0010n\u001a\u00020\u001eH\u0002J\u0010\u0010o\u001a\u00020F2\u0006\u0010p\u001a\u00020`H\u0016J\u0010\u0010q\u001a\u00020F2\u0006\u0010I\u001a\u00020\fH\u0016J\u0010\u0010r\u001a\u00020F2\u0006\u0010L\u001a\u00020\u0010H\u0016J\u001a\u0010s\u001a\u00020F2\b\u0010t\u001a\u0004\u0018\u00010\u001a2\u0006\u0010u\u001a\u00020`H\u0004J\u0012\u0010v\u001a\u0004\u0018\u00010`2\u0006\u0010R\u001a\u00020SH\u0002J\u000e\u0010w\u001a\u00020\u00002\u0006\u0010w\u001a\u00020xJ\u0016\u0010w\u001a\u00020\u00002\u000e\u0010w\u001a\n\u0012\u0006\b\u0001\u0012\u00020x0yJ\u0010\u0010w\u001a\u00020\u00002\b\u0010z\u001a\u0004\u0018\u00010\u001aJ\b\u0010{\u001a\u00020FH\u0002J\u0018\u0010|\u001a\u00020F2\u0006\u0010p\u001a\u00020`2\u0006\u0010}\u001a\u00020~H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001e\u0010@\u001a\u00020?2\u0006\u0010>\u001a\u00020?@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\"\u0010C\u001a\u0004\u0018\u00010\u001a2\b\u0010>\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u007f"}, d2={"Lcom/ko/http/request/HttpRequest;", "Lcom/ko/http/config/IRequestOther;", "()V", "_call", "Lokhttp3/Call;", "_callWeakRef", "Ljava/lang/ref/WeakReference;", "get_callWeakRef", "()Ljava/lang/ref/WeakReference;", "set_callWeakRef", "(Ljava/lang/ref/WeakReference;)V", "_headers", "Lcom/ko/http/model/HttpHeaders;", "get_headers", "()Lcom/ko/http/model/HttpHeaders;", "_params", "Lcom/ko/http/model/HttpParams;", "get_params", "()Lcom/ko/http/model/HttpParams;", "_yetRetryCount", "", "get_yetRetryCount", "()I", "set_yetRetryCount", "(I)V", "apiCode", "", "getApiCode", "()Ljava/lang/String;", "hasReadCacheResult", "", "isOnlyWriteCacheData", "mGlobalInfoCreator", "Lcom/ko/http/config/IRequestGlobalInfoCreator;", "getMGlobalInfoCreator", "()Lcom/ko/http/config/IRequestGlobalInfoCreator;", "setMGlobalInfoCreator", "(Lcom/ko/http/config/IRequestGlobalInfoCreator;)V", "mRequestCache", "Lcom/ko/http/config/IRequestCache;", "getMRequestCache", "()Lcom/ko/http/config/IRequestCache;", "setMRequestCache", "(Lcom/ko/http/config/IRequestCache;)V", "mRequestClient", "Lcom/ko/http/config/IRequestClient;", "getMRequestClient", "()Lcom/ko/http/config/IRequestClient;", "setMRequestClient", "(Lcom/ko/http/config/IRequestClient;)V", "mRequestHandler", "Lcom/ko/http/config/IRequestHandler;", "getMRequestHandler", "()Lcom/ko/http/config/IRequestHandler;", "setMRequestHandler", "(Lcom/ko/http/config/IRequestHandler;)V", "mRequestHost", "Lcom/ko/http/config/IRequestHost;", "getMRequestHost", "()Lcom/ko/http/config/IRequestHost;", "setMRequestHost", "(Lcom/ko/http/config/IRequestHost;)V", "<set-?>", "Lcom/ko/http/config/IRequestInterceptor;", "mRequestInterceptor", "getMRequestInterceptor", "()Lcom/ko/http/config/IRequestInterceptor;", "mTag", "getMTag", "addRequestHeader", "", "requestBuilder", "Lokhttp3/Request$Builder;", "headers", "addRequestParams", "builder", "params", "adjustWriteCacheData", "scopeContext", "Lkotlin/coroutines/CoroutineContext;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "type", "Ljava/lang/reflect/Type;", "(Lkotlin/coroutines/CoroutineContext;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/reflect/Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createGlobalHeader", "", "creator", "createGlobalParams", "createRequest", "Lokhttp3/Request;", "executeInline", "R", "(Lkotlin/coroutines/CoroutineContext;Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeReal", "fetchRequestResult", "", "generateLogTag", "getApi", "getDelayMills", "", "getNeedRetryCount", "getRType", "getRequestCache", "getRequestHeaders", "getRequestParams", "getRequestUrl", "handler", "initConfig", "interceptor", "isNeedAsyncWriteCache", "onHandlerRequestSuccessAfter", "result", "prepareRequestHeaders", "prepareRequestParams", "printKeyValue", "key", "value", "readCacheResult", "server", "Lcom/ko/http/config/IRequestServer;", "Ljava/lang/Class;", "host", "startRequestRefreshCache", "writeCacheResult", "response", "Lokhttp3/Response;", "koHttp_debug"})
public abstract class HttpRequest
implements IRequestOther {
    @NotNull
    private IRequestHost mRequestHost = KoHttpConfig.INSTANCE.getKServer();
    @Nullable
    private IRequestGlobalInfoCreator mGlobalInfoCreator = KoHttpConfig.INSTANCE.getKGlobalInfoCreator();
    @NotNull
    private IRequestCache mRequestCache = KoHttpConfig.INSTANCE.getKServer();
    @NotNull
    private IRequestClient mRequestClient = KoHttpConfig.INSTANCE.getKServer();
    @NotNull
    private IRequestHandler mRequestHandler = KoHttpConfig.INSTANCE.getKHandler();
    @NotNull
    private IRequestInterceptor mRequestInterceptor = KoHttpConfig.INSTANCE.getKInterceptor();
    @Nullable
    private String mTag;
    private int _yetRetryCount;
    @NotNull
    private final HttpParams _params = new HttpParams();
    @NotNull
    private final HttpHeaders _headers = new HttpHeaders();
    @Nullable
    private WeakReference<Call> _callWeakRef;
    @Nullable
    private Call _call;
    private boolean isOnlyWriteCacheData;
    private boolean hasReadCacheResult;

    public HttpRequest() {
        this.initConfig();
    }

    @NotNull
    public abstract String getApiCode();

    @NotNull
    public final IRequestHost getMRequestHost() {
        return this.mRequestHost;
    }

    public final void setMRequestHost(@NotNull IRequestHost iRequestHost) {
        Intrinsics.checkNotNullParameter((Object)iRequestHost, (String)"<set-?>");
        this.mRequestHost = iRequestHost;
    }

    @Nullable
    public final IRequestGlobalInfoCreator getMGlobalInfoCreator() {
        return this.mGlobalInfoCreator;
    }

    public final void setMGlobalInfoCreator(@Nullable IRequestGlobalInfoCreator iRequestGlobalInfoCreator) {
        this.mGlobalInfoCreator = iRequestGlobalInfoCreator;
    }

    @NotNull
    public final IRequestCache getMRequestCache() {
        return this.mRequestCache;
    }

    public final void setMRequestCache(@NotNull IRequestCache iRequestCache) {
        Intrinsics.checkNotNullParameter((Object)iRequestCache, (String)"<set-?>");
        this.mRequestCache = iRequestCache;
    }

    @NotNull
    public final IRequestClient getMRequestClient() {
        return this.mRequestClient;
    }

    public final void setMRequestClient(@NotNull IRequestClient iRequestClient) {
        Intrinsics.checkNotNullParameter((Object)iRequestClient, (String)"<set-?>");
        this.mRequestClient = iRequestClient;
    }

    @NotNull
    public final IRequestHandler getMRequestHandler() {
        return this.mRequestHandler;
    }

    public final void setMRequestHandler(@NotNull IRequestHandler iRequestHandler) {
        Intrinsics.checkNotNullParameter((Object)iRequestHandler, (String)"<set-?>");
        this.mRequestHandler = iRequestHandler;
    }

    @NotNull
    public final IRequestInterceptor getMRequestInterceptor() {
        return this.mRequestInterceptor;
    }

    @Nullable
    public final String getMTag() {
        return this.mTag;
    }

    public final int get_yetRetryCount() {
        return this._yetRetryCount;
    }

    public final void set_yetRetryCount(int n) {
        this._yetRetryCount = n;
    }

    @NotNull
    public final HttpParams get_params() {
        return this._params;
    }

    @NotNull
    public final HttpHeaders get_headers() {
        return this._headers;
    }

    @Nullable
    public final WeakReference<Call> get_callWeakRef() {
        return this._callWeakRef;
    }

    public final void set_callWeakRef(@Nullable WeakReference<Call> weakReference) {
        this._callWeakRef = weakReference;
    }

    private final HttpRequest initConfig() {
        if (this instanceof IRequestHost) {
            this.mRequestHost = (IRequestHost)((Object)this);
        }
        if (this instanceof IRequestClient) {
            this.mRequestClient = (IRequestClient)((Object)this);
        }
        if (this instanceof IRequestCache) {
            this.mRequestCache = (IRequestCache)((Object)this);
        }
        if (this instanceof IRequestHandler) {
            this.mRequestHandler = (IRequestHandler)((Object)this);
        }
        if (this instanceof IRequestInterceptor) {
            this.mRequestInterceptor = (IRequestInterceptor)((Object)this);
        }
        return this;
    }

    @Override
    public int getNeedRetryCount() {
        return 0;
    }

    @Override
    public long getDelayMills() {
        return 0L;
    }

    @NotNull
    public String getRequestUrl() {
        return this.mRequestHost.getHost() + this.getApi();
    }

    @NotNull
    public final HttpRequest server(@NotNull Class<? extends IRequestServer> server) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter(server, (String)"server");
        try {
            IRequestServer iRequestServer = server.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)iRequestServer, (String)"server.newInstance()");
            httpRequest = this.server(iRequestServer);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return httpRequest;
    }

    @NotNull
    public final HttpRequest server(@Nullable String host) {
        String string = host;
        Intrinsics.checkNotNull((Object)string);
        return this.server(new EasyRequestServer(string));
    }

    @NotNull
    public final HttpRequest server(@NotNull IRequestServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.mRequestHost = server;
        this.mRequestClient = server;
        this.mRequestCache = server;
        return this;
    }

    @NotNull
    public final HttpRequest handler(@NotNull IRequestHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.mRequestHandler = handler;
        return this;
    }

    @NotNull
    public final HttpRequest interceptor(@NotNull IRequestInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        this.mRequestInterceptor = interceptor;
        return this;
    }

    @Nullable
    public Map<String, String> createGlobalParams(@NotNull IRequestGlobalInfoCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        return creator.createGlobalParams();
    }

    @Nullable
    public Map<String, String> createGlobalHeader(@NotNull IRequestGlobalInfoCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        return creator.createGlobalHeader();
    }

    private final boolean isNeedAsyncWriteCache() {
        return this.mRequestCache.getCacheMode() == CacheMode.USE_CACHE_FIRST && !this.isOnlyWriteCacheData;
    }

    @Nullable
    public final Object adjustWriteCacheData(@NotNull CoroutineContext scopeContext, @NotNull CoroutineScope scope, @NotNull Type type, @NotNull Continuation<? super Unit> $completion) {
        boolean needAsyncWriteCache = this.isNeedAsyncWriteCache();
        if (this.hasReadCacheResult && needAsyncWriteCache) {
            this.isOnlyWriteCacheData = true;
            if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                KoHttpLog.INSTANCE.d("HttpRequest \u7f13\u5b58 \u6b63\u5728\u5f02\u6b65\u8bf7\u6c42");
            }
            BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, scopeContext, scope, type, null){
                int label;
                final /* synthetic */ HttpRequest this$0;
                final /* synthetic */ CoroutineContext $scopeContext;
                final /* synthetic */ CoroutineScope $scope;
                final /* synthetic */ Type $type;
                {
                    this.this$0 = $receiver;
                    this.$scopeContext = $scopeContext;
                    this.$scope = $scope;
                    this.$type = $type;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$scopeContext, this.$scope, this.$type, null){
                                int label;
                                final /* synthetic */ HttpRequest this$0;
                                final /* synthetic */ CoroutineContext $scopeContext;
                                final /* synthetic */ CoroutineScope $scope;
                                final /* synthetic */ Type $type;
                                {
                                    this.this$0 = $receiver;
                                    this.$scopeContext = $scopeContext;
                                    this.$scope = $scope;
                                    this.$type = $type;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = this.this$0.executeReal(this.$scopeContext, this.$scope, this.$type, (Continuation)this);
                                            if (v0 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = any = $result;
lbl13:
                                            // 2 sources

                                            if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                                                KoHttpLog.INSTANCE.d("HttpRequest \u7f13\u5b58 \u8bf7\u6c42\u5b8c\u6210=" + any);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return Unit.INSTANCE;
    }

    public final /* synthetic */ <R> Object executeInline(CoroutineContext scopeContext, CoroutineScope scope, Continuation<? super R> $completion) {
        boolean $i$f$executeInline = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"R");
        Type type = TypesJVMKt.getJavaType(null);
        InlineMarker.mark((int)0);
        Object object = this.executeReal(scopeContext, scope, type, $completion);
        InlineMarker.mark((int)1);
        return object;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final <R> Object executeReal(@NotNull CoroutineContext var1_1, @NotNull CoroutineScope var2_2, @NotNull Type var3_3, @NotNull Continuation<? super R> var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void startRequestRefreshCache() {
        BuildersKt.launch$default((CoroutineScope)KoHttpGlobalScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)3000L, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                            KoHttpLog.INSTANCE.d("HttpRequest \u5ef6\u8fdf3000\u5b8c\u6210");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object fetchRequestResult(Type type) {
        Response response;
        this.mRequestInterceptor.interceptExecute(this);
        if (this.mGlobalInfoCreator != null) {
            IRequestGlobalInfoCreator iRequestGlobalInfoCreator = this.mGlobalInfoCreator;
            Intrinsics.checkNotNull((Object)iRequestGlobalInfoCreator);
            this._params.putAll(this.createGlobalParams(iRequestGlobalInfoCreator));
            IRequestGlobalInfoCreator iRequestGlobalInfoCreator2 = this.mGlobalInfoCreator;
            Intrinsics.checkNotNull((Object)iRequestGlobalInfoCreator2);
            this._headers.putAll(this.createGlobalHeader(iRequestGlobalInfoCreator2));
        }
        this.prepareRequestParams(this._params);
        this.prepareRequestHeaders(this._headers);
        this.mRequestInterceptor.interceptArguments(this, this._params, this._headers);
        Request request = this.createRequest(this._params, this._headers);
        request = this.mRequestInterceptor.interceptRequest(this, request);
        Call call = this.mRequestClient.getOkHttpClient().newCall(request);
        this._callWeakRef = new WeakReference<Call>(call);
        this._call = call;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new KoCallIOException(string, e);
        }
        Response response2 = response;
        response2 = this.mRequestInterceptor.interceptResponse(this, response2);
        Object result2 = this.mRequestHandler.requestSuccess(this, call, response2, type);
        this.onHandlerRequestSuccessAfter(result2);
        this.writeCacheResult(result2, response2);
        return result2;
    }

    private final void writeCacheResult(Object result2, Response response) {
        block4: {
            CacheMode cacheMode = this.mRequestCache.getCacheMode();
            if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_FIRST || cacheMode == CacheMode.USE_CACHE_AFTER_FAILURE) {
                try {
                    boolean writeCacheResult = this.mRequestHandler.writeCache(this, response, result2);
                    if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                        KoHttpLog.INSTANCE.d("HttpRequest \u5199\u7f13\u5b58 result=" + writeCacheResult);
                    }
                }
                catch (Throwable e) {
                    if (!KoHttpConfig.INSTANCE.getKLogEnabled()) break block4;
                    KoHttpLog.INSTANCE.d("HttpRequest \u5199\u7f13\u5b58 result=" + e);
                }
            }
        }
    }

    private final Object readCacheResult(Type type) {
        if (this.hasReadCacheResult) {
            return null;
        }
        CacheMode cacheMode = this.mRequestCache.getCacheMode();
        if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_FIRST) {
            Object readCacheResult = this.mRequestHandler.readCache(this, type, this.mRequestCache.getCacheTimeMs());
            return readCacheResult;
        }
        return null;
    }

    public final /* synthetic */ <R> Type getRType() {
        boolean $i$f$getRType = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"R");
        return TypesJVMKt.getJavaType(null);
    }

    public void onHandlerRequestSuccessAfter(@NotNull Object result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }

    public abstract void addRequestParams(@NotNull Request.Builder var1, @NotNull HttpParams var2);

    @NotNull
    public abstract String getApi();

    public void prepareRequestParams(@NotNull HttpParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    public void prepareRequestHeaders(@NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
    }

    protected final void printKeyValue(@Nullable String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof Enum) {
            KoHttpLog.INSTANCE.printKeyValue(this, key, "\"" + value + "\"");
        } else if (value instanceof String) {
            KoHttpLog.INSTANCE.printKeyValue(this, key, "\"" + value + "\"");
        } else {
            KoHttpLog.INSTANCE.printKeyValue(this, key, value.toString());
        }
    }

    @NotNull
    public final Request createRequest(@NotNull HttpParams params, @NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Request.Builder requestBuilder = new Request.Builder();
        if (this.mRequestCache.getCacheMode() == CacheMode.NO_CACHE) {
            requestBuilder.cacheControl(new CacheControl.Builder().noCache().build());
        }
        this.addRequestHeader(requestBuilder, headers);
        this.addRequestParams(requestBuilder, params);
        return requestBuilder.build();
    }

    protected final void addRequestHeader(@NotNull Request.Builder requestBuilder, @NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        if (headers.isEmpty()) {
            return;
        }
        for (String key : headers.getKeys()) {
            String value = headers.get(key);
            try {
                requestBuilder.addHeader(key, value);
            }
            catch (IllegalArgumentException e) {
                requestBuilder.addHeader(KoHttpUtils.INSTANCE.encodeString(key), KoHttpUtils.INSTANCE.encodeString(value));
                if (!KoHttpConfig.INSTANCE.getKLogEnabled()) continue;
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public final String generateLogTag() {
        return this.getApi().getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    @NotNull
    public IRequestCache getRequestCache() {
        return this.mRequestCache;
    }

    @NotNull
    public final HttpParams getRequestParams() {
        return this._params;
    }

    @NotNull
    public final HttpHeaders getRequestHeaders() {
        return this._headers;
    }
}

