/*
 * Decompiled with CFR 0.152.
 */
package com.ko.http.model;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.ko.http.KoHttpUtils;
import com.ko.http.model.ContentType;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB#\b\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\u0015\u0010$\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J\u001f\u0010$\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010%2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010+J\u001f\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010%2\b\u0010'\u001a\u0004\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010-J\u001f\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010%2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u001bH\u0016J\b\u00100\u001a\u00020\u001bH\u0016J\u0006\u00101\u001a\u000202J\b\u00103\u001a\u0004\u0018\u000104J\u0010\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u0001H\u0016J\u0010\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\"H\u0016R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/ko/http/model/FileContentResolver;", "Ljava/io/File;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "fileName", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;)V", "mContentResolver", "Landroid/content/ContentResolver;", "contentUri", "(Landroid/content/ContentResolver;Landroid/net/Uri;Ljava/lang/String;)V", "contentType", "Lokhttp3/MediaType;", "getContentType", "()Lokhttp3/MediaType;", "setContentType", "(Lokhttp3/MediaType;)V", "getContentUri", "()Landroid/net/Uri;", "getFileName", "()Ljava/lang/String;", "setFileName", "(Ljava/lang/String;)V", "delete", "", "exists", "getParentFile", "isDirectory", "isFile", "isHidden", "lastModified", "", "length", "list", "", "()[Ljava/lang/String;", "filter", "Ljava/io/FilenameFilter;", "(Ljava/io/FilenameFilter;)[Ljava/lang/String;", "listFiles", "()[Ljava/io/File;", "Ljava/io/FileFilter;", "(Ljava/io/FileFilter;)[Ljava/io/File;", "(Ljava/io/FilenameFilter;)[Ljava/io/File;", "mkdir", "mkdirs", "openInputStream", "Ljava/io/InputStream;", "openOutputStream", "Ljava/io/OutputStream;", "renameTo", "dest", "setLastModified", "time", "koHttp_debug"})
public final class FileContentResolver
extends File {
    @NotNull
    private final ContentResolver mContentResolver;
    @NotNull
    private final Uri contentUri;
    @Nullable
    private MediaType contentType;
    @Nullable
    private String fileName;

    @JvmOverloads
    public FileContentResolver(@NotNull ContentResolver mContentResolver, @NotNull Uri contentUri, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)mContentResolver, (String)"mContentResolver");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        super(new File(contentUri.toString()).getPath());
        this.mContentResolver = mContentResolver;
        this.contentUri = contentUri;
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            this.fileName = this.getName();
            this.contentType = ContentType.STREAM;
        } else {
            this.fileName = fileName;
            this.contentType = ContentType.guessMimeType(fileName);
        }
    }

    public /* synthetic */ FileContentResolver(ContentResolver contentResolver, Uri uri, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(contentResolver, uri, string);
    }

    @NotNull
    public final Uri getContentUri() {
        return this.contentUri;
    }

    @Nullable
    public final MediaType getContentType() {
        return this.contentType;
    }

    public final void setContentType(@Nullable MediaType mediaType) {
        this.contentType = mediaType;
    }

    @Nullable
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@Nullable String string) {
        this.fileName = string;
    }

    public FileContentResolver(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"context.contentResolver");
        this(contentResolver, uri, null, 4, null);
    }

    public FileContentResolver(@NotNull Context context, @NotNull Uri uri, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"context.contentResolver");
        this(contentResolver, uri, fileName);
    }

    @NotNull
    public final InputStream openInputStream() throws FileNotFoundException {
        InputStream inputStream = this.mContentResolver.openInputStream(this.contentUri);
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream;
    }

    @Nullable
    public final OutputStream openOutputStream() throws FileNotFoundException {
        return this.mContentResolver.openOutputStream(this.contentUri);
    }

    @Override
    public boolean delete() {
        return this.mContentResolver.delete(this.contentUri, null, null) > 0;
    }

    @Override
    public boolean renameTo(@NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream();
            long l = inputStream.available();
            return l;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            KoHttpUtils.closeStream(inputStream);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        boolean bl;
        Cursor cursor = null;
        try {
            cursor = this.mContentResolver.query(this.contentUri, null, null, null, null);
            bl = cursor != null && cursor.getCount() != 0;
        }
        finally {
            KoHttpUtils.closeStream((Closeable)cursor);
        }
        return bl;
    }

    @Override
    public boolean isFile() {
        return this.exists();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean mkdir() {
        return true;
    }

    @Override
    public boolean mkdirs() {
        return true;
    }

    @Override
    @Nullable
    public File getParentFile() {
        return null;
    }

    @Override
    public boolean setLastModified(long time) {
        return false;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    @Nullable
    public String[] list() {
        return null;
    }

    @Override
    @Nullable
    public String[] list(@Nullable FilenameFilter filter) {
        return null;
    }

    @Override
    @Nullable
    public File[] listFiles() {
        return null;
    }

    @Override
    @Nullable
    public File[] listFiles(@Nullable FileFilter filter) {
        return null;
    }

    @Override
    @Nullable
    public File[] listFiles(@Nullable FilenameFilter filter) {
        return null;
    }

    @JvmOverloads
    public FileContentResolver(@NotNull ContentResolver mContentResolver, @NotNull Uri contentUri) {
        Intrinsics.checkNotNullParameter((Object)mContentResolver, (String)"mContentResolver");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        this(mContentResolver, contentUri, null, 4, null);
    }
}

