/*
 * Decompiled with CFR 0.152.
 */
package com.ko.http.model;

import android.text.TextUtils;
import java.net.FileNameMap;
import java.net.URLConnection;
import okhttp3.MediaType;

public final class ContentType {
    public static final String HTTP_HEAD_KEY = "Content-Type";
    public static final MediaType STREAM = MediaType.parse((String)"application/octet-stream");
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType TEXT = MediaType.parse((String)"text/plain; charset=utf-8");

    public static MediaType guessMimeType(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return STREAM;
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(fileName = fileName.replace("#", ""));
        if (contentType == null) {
            return STREAM;
        }
        MediaType type = MediaType.parse((String)contentType);
        if (type == null) {
            type = STREAM;
        }
        return type;
    }
}

