/*
 * Decompiled with CFR 0.152.
 */
package com.ko.http.config.body;

import com.ko.http.KoHttpUtils;
import com.ko.http.model.ContentType;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ko/http/config/body/JsonRequestBody;", "Lokhttp3/RequestBody;", "map", "", "(Ljava/util/Map;)V", "jsonObject", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "json", "", "(Ljava/lang/String;)V", "mBytes", "", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "toString", "writeTo", "", "sink", "Lokio/BufferedSink;", "koHttp_release"})
public final class JsonRequestBody
extends RequestBody {
    @NotNull
    private final String json;
    @NotNull
    private final byte[] mBytes;

    public JsonRequestBody(@NotNull Map<?, ?> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this(new JSONObject(map));
    }

    public JsonRequestBody(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        String string2 = this.json = KoHttpUtils.INSTANCE.unescapeJson(string);
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.mBytes = byArray;
    }

    public JsonRequestBody(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
        String string = json;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.mBytes = byArray;
    }

    @Nullable
    public MediaType contentType() {
        return ContentType.JSON;
    }

    public long contentLength() {
        return this.mBytes.length;
    }

    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.write(this.mBytes, 0, this.mBytes.length);
    }

    @NotNull
    public String toString() {
        return this.json;
    }
}

