/*
 * Decompiled with CFR 0.152.
 */
package com.ko.http;

import android.os.Looper;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.collection.ArrayMap;
import com.ko.http.annotation.HttpIgnore;
import com.ko.http.annotation.HttpRename;
import com.ko.http.model.FileContentResolver;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001J\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\u001e\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010 \u001a\u0004\u0018\u00010\u00102\b\u0010!\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0018\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'J\u0012\u0010(\u001a\u0004\u0018\u00010\u00102\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\u0012\u0010,\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\u0016\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/J\u000e\u00101\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0001J\u0010\u00102\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\u000e\u00103\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0007J\u0010\u00104\u001a\u00020\t2\b\u00105\u001a\u0004\u0018\u00010\u0013J\u0014\u00106\u001a\u00020\t2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0014\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fJ\u0018\u0010;\u001a\u00020<2\u0010\u0010=\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010>J\u0010\u0010?\u001a\u00020*2\b\u0010@\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010A\u001a\u00020B2\b\u0010@\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010C\u001a\u00020\u00172\b\u0010D\u001a\u0004\u0018\u00010EJ\u000e\u0010F\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010R$\u0010\u0003\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006G"}, d2={"Lcom/ko/http/KoHttpUtils;", "", "()V", "CLASS_LIST_LRU_CACHE", "Landroid/util/LruCache;", "Ljava/lang/Class;", "", "Ljava/lang/reflect/Field;", "isMainThread", "", "()Z", "arrayToList", "", "array", "beanToMap", "Landroidx/collection/ArrayMap;", "", "any", "classToType", "Ljava/lang/reflect/Type;", "rawType", "actualType", "closeStream", "", "closeable", "Ljava/io/Closeable;", "convertObject", "createFolder", "targetFolder", "Ljava/io/File;", "encodeString", "text", "formatJson", "json", "getAllFields", "originalClass", "getFieldGenericType", "field", "position", "", "getFileMd5", "inputStream", "Ljava/io/InputStream;", "getGenericType", "getObjectTag", "getProgressProgress", "totalByte", "", "currentByte", "isArrayType", "isBeanType", "isConstantField", "isMultipartClass", "type", "isMultipartParameter", "fields", "listToJsonArray", "Lorg/json/JSONArray;", "list", "mapToJsonObject", "Lorg/json/JSONObject;", "map", "", "openFileInputStream", "file", "openFileOutputStream", "Ljava/io/OutputStream;", "runOnIOThread", "runnable", "Ljava/lang/Runnable;", "unescapeJson", "koHttp_release"})
public final class KoHttpUtils {
    @NotNull
    public static final KoHttpUtils INSTANCE = new KoHttpUtils();
    @NotNull
    private static final LruCache<Class<?>, List<Field>> CLASS_LIST_LRU_CACHE = new LruCache(30);

    private KoHttpUtils() {
    }

    public final void runOnIOThread(@Nullable Runnable runnable) {
    }

    public final boolean isMainThread() {
        return Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper());
    }

    @JvmStatic
    public static final void closeStream(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final boolean isArrayType(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return any.getClass().isArray();
    }

    public final boolean isBeanType(@Nullable Object any) {
        if (any == null) {
            return false;
        }
        if (any instanceof Enum) {
            return false;
        }
        return this.isArrayType(any) ? false : !(any instanceof Number) && !(any instanceof CharSequence) && !(any instanceof Boolean) && !(any instanceof File) && !(any instanceof InputStream) && !(any instanceof RequestBody) && !(any instanceof Character) && !(any instanceof JSONObject) && !(any instanceof JSONArray);
    }

    public final boolean isMultipartParameter(@NotNull List<Field> fields) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        for (Field field : fields) {
            field.setAccessible(true);
            if (this.isConstantField(field)) continue;
            int i = 0;
            Class<?> clazz = field.getType();
            Class<?>[] interfaces = clazz.getInterfaces();
            int n = interfaces.length;
            if (i <= n) {
                while (true) {
                    Class<?> temp = null;
                    Class<?> clazz2 = temp = i == interfaces.length ? clazz : interfaces[i];
                    if (Intrinsics.areEqual(List.class, temp) ? this.isMultipartClass(this.getFieldGenericType(field, 0)) : Intrinsics.areEqual(Map.class, temp) && this.isMultipartClass(this.getFieldGenericType(field, 1))) {
                        return true;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            do {
                if (!this.isMultipartClass(clazz)) continue;
                return true;
            } while ((clazz = clazz.getSuperclass()) != null && !Intrinsics.areEqual(Object.class, clazz));
        }
        return false;
    }

    @Nullable
    public final Type getFieldGenericType(@NotNull Field field, int position) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Type type = field.getGenericType();
        ParameterizedType parameterizedType = type instanceof ParameterizedType ? (ParameterizedType)type : null;
        if (parameterizedType == null) {
            return null;
        }
        ParameterizedType type2 = parameterizedType;
        Type[] actualTypeArguments = type2.getActualTypeArguments();
        if (position >= actualTypeArguments.length) {
            return null;
        }
        Type actualType = actualTypeArguments[position];
        if (actualType instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)actualType).getUpperBounds();
            return upperBounds.length == 0 ? (Type)null : upperBounds[0];
        }
        return actualType;
    }

    public final boolean isMultipartClass(@Nullable Type type) {
        return type == null ? false : Intrinsics.areEqual(File.class, (Object)type) || Intrinsics.areEqual(FileContentResolver.class, (Object)type) || Intrinsics.areEqual(InputStream.class, (Object)type) || Intrinsics.areEqual(RequestBody.class, (Object)type) || Intrinsics.areEqual(MultipartBody.Part.class, (Object)type);
    }

    @NotNull
    public final JSONArray listToJsonArray(@Nullable List<?> list) {
        JSONArray jsonArray = new JSONArray();
        if (list == null || list.isEmpty()) {
            return jsonArray;
        }
        for (Object value : list) {
            if (value == null) continue;
            jsonArray.put(this.convertObject(value));
        }
        return jsonArray;
    }

    @NotNull
    public final JSONObject mapToJsonObject(@Nullable Map<?, ?> map) {
        JSONObject jsonObject = new JSONObject();
        if (map == null || map.isEmpty()) {
            return jsonObject;
        }
        Set<?> keySet = map.keySet();
        for (Object key : keySet) {
            if (map.get(key) == null) continue;
            try {
                Object value;
                jsonObject.put(String.valueOf(key), this.convertObject(value));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    @NotNull
    public final List<Object> arrayToList(@Nullable Object array) {
        List list = new ArrayList();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            list.add(element);
        }
        return list;
    }

    @Nullable
    public final ArrayMap<String, Object> beanToMap(@Nullable Object any) {
        if (any == null) {
            return null;
        }
        if (any instanceof Enum) {
            return null;
        }
        Field[] fields = any.getClass().getDeclaredFields();
        ArrayMap data = new ArrayMap(fields.length);
        Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
        for (Field field : fields) {
            field.setAccessible(true);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (this.isConstantField(field)) continue;
            try {
                Object value = field.get(any);
                if (value == null || field.isAnnotationPresent(HttpIgnore.class)) continue;
                String key = null;
                HttpRename annotation = field.getAnnotation(HttpRename.class);
                if (annotation != null) {
                    key = annotation.value();
                } else {
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                    key = string;
                    CharSequence charSequence = key;
                    if (new Regex("this\\$\\d+").matches(charSequence) || Intrinsics.areEqual((Object)"Companion", (Object)key)) continue;
                }
                ((Map)data).put(key, this.convertObject(value));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    @NotNull
    public final Object convertObject(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return any instanceof List ? this.listToJsonArray((List)any) : (any instanceof Map ? this.mapToJsonObject((Map)any) : (any instanceof Enum ? any.toString() : (this.isArrayType(any) ? this.listToJsonArray(this.arrayToList(any)) : (this.isBeanType(any) ? this.mapToJsonObject((Map)this.beanToMap(any)) : any))));
    }

    @NotNull
    public final Type getGenericType(@Nullable Object any) {
        Type type;
        Type type2;
        if (any == null) {
            return (Type)((Object)Void.class);
        }
        Type[] genericInterfaces = any.getClass().getGenericInterfaces();
        if (genericInterfaces.length > 0) {
            Intrinsics.checkNotNullExpressionValue((Object)genericInterfaces, (String)"genericInterfaces");
            for (Type genericInterface : genericInterfaces) {
                if (!(genericInterface instanceof ParameterizedType)) continue;
                Type type3 = ((ParameterizedType)genericInterface).getActualTypeArguments()[0];
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"genericInterface.actualTypeArguments[0]");
                return type3;
            }
        }
        ParameterizedType parameterizedType = (type2 = any.getClass().getGenericSuperclass()) instanceof ParameterizedType ? (ParameterizedType)type2 : null;
        if (parameterizedType == null) {
            return (Type)((Object)Void.class);
        }
        ParameterizedType genericSuperclass = parameterizedType;
        Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            type = (Type)((Object)Void.class);
        } else {
            Type type4 = actualTypeArguments[0];
            type = type4;
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"actualTypeArguments[0]");
        }
        return type;
    }

    public final int getProgressProgress(long totalByte, long currentByte) {
        return totalByte <= 0L ? -1 : (int)((double)currentByte / (double)totalByte * (double)100);
    }

    @NotNull
    public final String encodeString(@Nullable String text) {
        String string;
        if (TextUtils.isEmpty((CharSequence)text)) {
            string = "";
        } else {
            String string2;
            try {
                string2 = URLEncoder.encode(text, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                String string3 = text;
                Intrinsics.checkNotNull((Object)string3);
                string2 = string3;
            }
            String string4 = string2;
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"try {\n            URLEnc\u2026         text!!\n        }");
        }
        return string;
    }

    @Nullable
    public final String formatJson(@Nullable String json) {
        if (json == null) {
            return null;
        }
        try {
            if (StringsKt.startsWith$default((String)json, (String)"{", (boolean)false, (int)2, null)) {
                String string = new JSONObject(json).toString(4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject(json).toString(4)");
                return this.unescapeJson(string);
            }
            if (StringsKt.startsWith$default((String)json, (String)"[", (boolean)false, (int)2, null)) {
                String string = new JSONArray(json).toString(4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(json).toString(4)");
                return this.unescapeJson(string);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    @NotNull
    public final String unescapeJson(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return TextUtils.isEmpty((CharSequence)json) ? "" : StringsKt.replace$default((String)json, (String)"\\/", (String)"/", (boolean)false, (int)4, null);
    }

    @JvmStatic
    @NotNull
    public static final Type classToType(@NotNull Class<?> rawType, @Nullable Type actualType) {
        Intrinsics.checkNotNullParameter(rawType, (String)"rawType");
        return new ParameterizedType(rawType, actualType){
            final /* synthetic */ Class<?> $rawType;
            final /* synthetic */ Type $actualType;
            {
                this.$rawType = $rawType;
                this.$actualType = $actualType;
            }

            @NotNull
            public Type getRawType() {
                return this.$rawType;
            }

            @NotNull
            public Type[] getActualTypeArguments() {
                if (this.$actualType == null) {
                    return new Type[0];
                }
                Type[] typeArray = new Type[]{this.$actualType};
                return typeArray;
            }

            @Nullable
            public Type getOwnerType() {
                return null;
            }
        };
    }

    @Nullable
    public final String getObjectTag(@Nullable Object any) {
        Object object = any;
        return object != null ? object.toString() : null;
    }

    public final void createFolder(@NotNull File targetFolder) {
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return;
            }
            targetFolder.delete();
        }
        targetFolder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getFileMd5(@Nullable InputStream inputStream) {
        if (inputStream == null) {
            return "";
        }
        DigestInputStream digestInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(inputStream, messageDigest);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            messageDigest = digestInputStream.getMessageDigest();
            byte[] md5 = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)md5, (String)"md5");
            for (byte b : md5) {
                String string = "%02X";
                Object[] objectArray = new Object[]{b};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                sb.append(string2);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            Object object = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            object = string3;
            return object;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            KoHttpUtils.closeStream(inputStream);
            KoHttpUtils.closeStream(digestInputStream);
        }
        return null;
    }

    @NotNull
    public final InputStream openFileInputStream(@Nullable File file) throws FileNotFoundException {
        return file instanceof FileContentResolver ? ((FileContentResolver)file).openInputStream() : (InputStream)new FileInputStream(file);
    }

    @NotNull
    public final OutputStream openFileOutputStream(@Nullable File file) throws FileNotFoundException {
        OutputStream outputStream;
        if (file instanceof FileContentResolver) {
            OutputStream outputStream2 = ((FileContentResolver)file).openOutputStream();
            outputStream = outputStream2;
            Intrinsics.checkNotNull((Object)outputStream2);
        } else {
            outputStream = new FileOutputStream(file);
        }
        return outputStream;
    }

    public final boolean isConstantField(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    @NotNull
    public final List<Field> getAllFields(@NotNull Class<?> originalClass) {
        Intrinsics.checkNotNullParameter(originalClass, (String)"originalClass");
        List fields = (List)CLASS_LIST_LRU_CACHE.get(originalClass);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList();
        Class<?> clazz = originalClass;
        do {
            Field[] declaredFields = clazz.getDeclaredFields();
            List<Field> list = Arrays.asList(Arrays.copyOf(declaredFields, declaredFields.length));
            Intrinsics.checkNotNullExpressionValue(list, (String)"asList(*declaredFields)");
            fields.addAll(0, (Collection)list);
        } while ((clazz = clazz.getSuperclass()) != null && !Intrinsics.areEqual(Object.class, clazz));
        CLASS_LIST_LRU_CACHE.put(originalClass, (Object)fields);
        return fields;
    }
}

