/*
 * Decompiled with CFR 0.152.
 */
package com.ko.http.request;

import androidx.annotation.WorkerThread;
import com.ko.http.KoHttpConfig;
import com.ko.http.KoHttpUtils;
import com.ko.http.config.IRequestCache;
import com.ko.http.config.IRequestClient;
import com.ko.http.config.IRequestGlobalInfoCreator;
import com.ko.http.config.IRequestHandler;
import com.ko.http.config.IRequestHost;
import com.ko.http.config.IRequestInterceptor;
import com.ko.http.config.IRequestOther;
import com.ko.http.config.IRequestServer;
import com.ko.http.config.impl.EasyRequestServer;
import com.ko.http.exception.KoCallIOException;
import com.ko.http.model.CacheMode;
import com.ko.http.model.HttpHeaders;
import com.ko.http.model.HttpParams;
import com.ko.http.request.HttpRequest;
import com.ko.http.tools.KoHttpLog;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.JobKt;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\fH\u0004J\u0018\u0010G\u001a\u00020C2\u0006\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u00020\u0010H&J\u001e\u0010J\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010K2\u0006\u0010L\u001a\u00020\u001eH\u0016J\u001e\u0010M\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010K2\u0006\u0010L\u001a\u00020\u001eH\u0016J\u0016\u0010N\u001a\u00020O2\u0006\u0010I\u001a\u00020\u00102\u0006\u0010F\u001a\u00020\fJ)\u0010P\u001a\u0002HQ\"\u0006\b\u0000\u0010Q\u0018\u00012\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020SH\u0087H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010UJ/\u0010V\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020S2\u0006\u0010W\u001a\u00020XH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010YJ\u0006\u0010Z\u001a\u00020\u001aJ\b\u0010[\u001a\u00020\u001aH&J\b\u0010\\\u001a\u00020]H\u0016J\b\u0010^\u001a\u00020\u0014H\u0016J\u0011\u0010_\u001a\u00020X\"\u0006\b\u0000\u0010Q\u0018\u0001H\u0086\bJ\b\u0010`\u001a\u00020$H\u0016J\u0006\u0010a\u001a\u00020\fJ\u0006\u0010b\u001a\u00020\u0010J\b\u0010c\u001a\u00020\u001aH\u0016J\u000e\u0010d\u001a\u00020\u00002\u0006\u0010d\u001a\u000200J\b\u0010e\u001a\u00020\u0000H\u0002J\u000e\u0010f\u001a\u00020\u00002\u0006\u0010f\u001a\u00020<J\u0010\u0010g\u001a\u00020C2\u0006\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020C2\u0006\u0010F\u001a\u00020\fH\u0016J\u0010\u0010k\u001a\u00020C2\u0006\u0010I\u001a\u00020\u0010H\u0016J\u001a\u0010l\u001a\u00020C2\b\u0010m\u001a\u0004\u0018\u00010\u001a2\u0006\u0010n\u001a\u00020iH\u0004J\u0010\u0010o\u001a\u0004\u0018\u00010i2\u0006\u0010W\u001a\u00020XJ\u001e\u0010p\u001a\u00020i2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020S2\u0006\u0010W\u001a\u00020XJ\u000e\u0010q\u001a\u00020\u00002\u0006\u0010q\u001a\u00020rJ\u0016\u0010q\u001a\u00020\u00002\u000e\u0010q\u001a\n\u0012\u0006\b\u0001\u0012\u00020r0sJ\u0010\u0010q\u001a\u00020\u00002\b\u0010t\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010u\u001a\u00020C2\u0006\u0010h\u001a\u00020i2\u0006\u0010v\u001a\u00020wR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001e\u0010=\u001a\u00020<2\u0006\u0010;\u001a\u00020<@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\"\u0010@\u001a\u0004\u0018\u00010\u001a2\b\u0010;\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006x"}, d2={"Lcom/ko/http/request/HttpRequest;", "Lcom/ko/http/config/IRequestOther;", "()V", "_call", "Lokhttp3/Call;", "_callWeakRef", "Ljava/lang/ref/WeakReference;", "get_callWeakRef", "()Ljava/lang/ref/WeakReference;", "set_callWeakRef", "(Ljava/lang/ref/WeakReference;)V", "_headers", "Lcom/ko/http/model/HttpHeaders;", "get_headers", "()Lcom/ko/http/model/HttpHeaders;", "_params", "Lcom/ko/http/model/HttpParams;", "get_params", "()Lcom/ko/http/model/HttpParams;", "_yetRetryCount", "", "get_yetRetryCount", "()I", "set_yetRetryCount", "(I)V", "apiCode", "", "getApiCode", "()Ljava/lang/String;", "mGlobalInfoCreator", "Lcom/ko/http/config/IRequestGlobalInfoCreator;", "getMGlobalInfoCreator", "()Lcom/ko/http/config/IRequestGlobalInfoCreator;", "setMGlobalInfoCreator", "(Lcom/ko/http/config/IRequestGlobalInfoCreator;)V", "mRequestCache", "Lcom/ko/http/config/IRequestCache;", "getMRequestCache", "()Lcom/ko/http/config/IRequestCache;", "setMRequestCache", "(Lcom/ko/http/config/IRequestCache;)V", "mRequestClient", "Lcom/ko/http/config/IRequestClient;", "getMRequestClient", "()Lcom/ko/http/config/IRequestClient;", "setMRequestClient", "(Lcom/ko/http/config/IRequestClient;)V", "mRequestHandler", "Lcom/ko/http/config/IRequestHandler;", "getMRequestHandler", "()Lcom/ko/http/config/IRequestHandler;", "setMRequestHandler", "(Lcom/ko/http/config/IRequestHandler;)V", "mRequestHost", "Lcom/ko/http/config/IRequestHost;", "getMRequestHost", "()Lcom/ko/http/config/IRequestHost;", "setMRequestHost", "(Lcom/ko/http/config/IRequestHost;)V", "<set-?>", "Lcom/ko/http/config/IRequestInterceptor;", "mRequestInterceptor", "getMRequestInterceptor", "()Lcom/ko/http/config/IRequestInterceptor;", "mTag", "getMTag", "addRequestHeader", "", "requestBuilder", "Lokhttp3/Request$Builder;", "headers", "addRequestParams", "builder", "params", "createGlobalHeader", "", "creator", "createGlobalParams", "createRequest", "Lokhttp3/Request;", "execute", "R", "scopeContext", "Lkotlin/coroutines/CoroutineContext;", "requestContext", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeReal", "type", "Ljava/lang/reflect/Type;", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Ljava/lang/reflect/Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateLogTag", "getApi", "getDelayMills", "", "getNeedRetryCount", "getRType", "getRequestCache", "getRequestHeaders", "getRequestParams", "getRequestUrl", "handler", "initConfig", "interceptor", "onHandlerRequestSuccessAfter", "result", "", "prepareRequestHeaders", "prepareRequestParams", "printKeyValue", "key", "value", "readCacheResult", "sendRequest", "server", "Lcom/ko/http/config/IRequestServer;", "Ljava/lang/Class;", "host", "writeCacheResult", "response", "Lokhttp3/Response;", "koHttp_debug"})
public abstract class HttpRequest
implements IRequestOther {
    @NotNull
    private IRequestHost mRequestHost = KoHttpConfig.INSTANCE.getKServer();
    @Nullable
    private IRequestGlobalInfoCreator mGlobalInfoCreator = KoHttpConfig.INSTANCE.getKGlobalInfoCreator();
    @NotNull
    private IRequestCache mRequestCache = KoHttpConfig.INSTANCE.getKServer();
    @NotNull
    private IRequestClient mRequestClient = KoHttpConfig.INSTANCE.getKServer();
    @NotNull
    private IRequestHandler mRequestHandler = KoHttpConfig.INSTANCE.getKHandler();
    @NotNull
    private IRequestInterceptor mRequestInterceptor = KoHttpConfig.INSTANCE.getKInterceptor();
    @Nullable
    private String mTag;
    private int _yetRetryCount;
    @NotNull
    private final HttpParams _params = new HttpParams();
    @NotNull
    private final HttpHeaders _headers = new HttpHeaders();
    @Nullable
    private WeakReference<Call> _callWeakRef;
    @Nullable
    private Call _call;

    public HttpRequest() {
        this.initConfig();
    }

    @NotNull
    public abstract String getApiCode();

    @NotNull
    public final IRequestHost getMRequestHost() {
        return this.mRequestHost;
    }

    public final void setMRequestHost(@NotNull IRequestHost iRequestHost) {
        Intrinsics.checkNotNullParameter((Object)iRequestHost, (String)"<set-?>");
        this.mRequestHost = iRequestHost;
    }

    @Nullable
    public final IRequestGlobalInfoCreator getMGlobalInfoCreator() {
        return this.mGlobalInfoCreator;
    }

    public final void setMGlobalInfoCreator(@Nullable IRequestGlobalInfoCreator iRequestGlobalInfoCreator) {
        this.mGlobalInfoCreator = iRequestGlobalInfoCreator;
    }

    @NotNull
    public final IRequestCache getMRequestCache() {
        return this.mRequestCache;
    }

    public final void setMRequestCache(@NotNull IRequestCache iRequestCache) {
        Intrinsics.checkNotNullParameter((Object)iRequestCache, (String)"<set-?>");
        this.mRequestCache = iRequestCache;
    }

    @NotNull
    public final IRequestClient getMRequestClient() {
        return this.mRequestClient;
    }

    public final void setMRequestClient(@NotNull IRequestClient iRequestClient) {
        Intrinsics.checkNotNullParameter((Object)iRequestClient, (String)"<set-?>");
        this.mRequestClient = iRequestClient;
    }

    @NotNull
    public final IRequestHandler getMRequestHandler() {
        return this.mRequestHandler;
    }

    public final void setMRequestHandler(@NotNull IRequestHandler iRequestHandler) {
        Intrinsics.checkNotNullParameter((Object)iRequestHandler, (String)"<set-?>");
        this.mRequestHandler = iRequestHandler;
    }

    @NotNull
    public final IRequestInterceptor getMRequestInterceptor() {
        return this.mRequestInterceptor;
    }

    @Nullable
    public final String getMTag() {
        return this.mTag;
    }

    public final int get_yetRetryCount() {
        return this._yetRetryCount;
    }

    public final void set_yetRetryCount(int n) {
        this._yetRetryCount = n;
    }

    @NotNull
    public final HttpParams get_params() {
        return this._params;
    }

    @NotNull
    public final HttpHeaders get_headers() {
        return this._headers;
    }

    @Nullable
    public final WeakReference<Call> get_callWeakRef() {
        return this._callWeakRef;
    }

    public final void set_callWeakRef(@Nullable WeakReference<Call> weakReference) {
        this._callWeakRef = weakReference;
    }

    private final HttpRequest initConfig() {
        if (this instanceof IRequestHost) {
            this.mRequestHost = (IRequestHost)((Object)this);
        }
        if (this instanceof IRequestClient) {
            this.mRequestClient = (IRequestClient)((Object)this);
        }
        if (this instanceof IRequestCache) {
            this.mRequestCache = (IRequestCache)((Object)this);
        }
        if (this instanceof IRequestHandler) {
            this.mRequestHandler = (IRequestHandler)((Object)this);
        }
        if (this instanceof IRequestInterceptor) {
            this.mRequestInterceptor = (IRequestInterceptor)((Object)this);
        }
        return this;
    }

    @Override
    public int getNeedRetryCount() {
        return 0;
    }

    @Override
    public long getDelayMills() {
        return 0L;
    }

    @NotNull
    public String getRequestUrl() {
        return this.mRequestHost.getHost() + this.getApi();
    }

    @NotNull
    public final HttpRequest server(@NotNull Class<? extends IRequestServer> server) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter(server, (String)"server");
        try {
            IRequestServer iRequestServer = server.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)iRequestServer, (String)"server.newInstance()");
            httpRequest = this.server(iRequestServer);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return httpRequest;
    }

    @NotNull
    public final HttpRequest server(@Nullable String host) {
        String string = host;
        Intrinsics.checkNotNull((Object)string);
        return this.server(new EasyRequestServer(string));
    }

    @NotNull
    public final HttpRequest server(@NotNull IRequestServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.mRequestHost = server;
        this.mRequestClient = server;
        this.mRequestCache = server;
        return this;
    }

    @NotNull
    public final HttpRequest handler(@NotNull IRequestHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.mRequestHandler = handler;
        return this;
    }

    @NotNull
    public final HttpRequest interceptor(@NotNull IRequestInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        this.mRequestInterceptor = interceptor;
        return this;
    }

    @Nullable
    public Map<String, String> createGlobalParams(@NotNull IRequestGlobalInfoCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        return creator.createGlobalParams();
    }

    @Nullable
    public Map<String, String> createGlobalHeader(@NotNull IRequestGlobalInfoCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        return creator.createGlobalHeader();
    }

    @WorkerThread
    public final /* synthetic */ <R> Object execute(CoroutineContext scopeContext, CoroutineContext requestContext, Continuation<? super R> $completion) {
        boolean $i$f$execute = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"R");
        Type type = TypesJVMKt.getJavaType(null);
        InlineMarker.mark((int)0);
        Object object = this.executeReal(scopeContext, requestContext, type, $completion);
        InlineMarker.mark((int)1);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @Nullable
    public final <R> Object executeReal(@NotNull CoroutineContext var1_1, @NotNull CoroutineContext var2_2, @NotNull Type var3_3, @NotNull Continuation<? super R> var4_4) {
        if (!(var4_4 instanceof executeReal.1)) ** GOTO lbl-1000
        var10_5 = var4_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ HttpRequest this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeReal(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getDelayMills() > 0L) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = scopeContext;
                    $continuation.L$2 = requestContext;
                    $continuation.L$3 = type;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)this.getDelayMills(), $continuation);
                    if (v0 == var11_7) {
                        return var11_7;
                    }
                }
                ** GOTO lbl29
            }
            case 1: {
                type = (Type)$continuation.L$3;
                requestContext = (CoroutineContext)$continuation.L$2;
                scopeContext = (CoroutineContext)$continuation.L$1;
                this = (HttpRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                jobHandle = null;
                try {
                    cacheResult = this.readCacheResult(type);
                    if (this.mRequestCache.getCacheMode() == CacheMode.USE_CACHE_FIRST && KoHttpConfig.INSTANCE.getKLogEnabled()) {
                        KoHttpLog.INSTANCE.d("execute \u7f13\u5b58 \u6a21\u5f0f\u662f \u8bfb\u53d6\u7f13\u5b58 \u2014> \u56de\u8c03\u6210\u529f \u2014> \u8bf7\u6c42\u7f51\u7edc, \u5f00\u59cb\u8bf7\u6c42\u7f51\u7edc");
                    }
                    if (cacheResult == null) ** GOTO lbl-1000
                    if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                        KoHttpLog.INSTANCE.d("execute \u7f13\u5b58 \u8bfb\u53d6\u6210\u529f api=" + this.mRequestHost.getHost() + this.getApi() + " d=" + cacheResult);
                    }
                    var7_12 = cacheResult;
                    KoHttpLog.INSTANCE.d("execute \u5b8c\u6210 finally callWeakRef=" + this._callWeakRef + " jobHandle=" + jobHandle);
                    v1 = this._callWeakRef;
                    ** GOTO lbl63
                }
                catch (Throwable e) {
                    if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                        KoHttpLog.INSTANCE.d("execute \u5f02\u5e38 api=" + this.mRequestHost.getHost() + this.getApi() + " e=" + e);
                    }
                    finalThrowable = this.mRequestHandler.requestFail(this, this._call, e);
                    if (this._yetRetryCount >= this.getNeedRetryCount()) throw finalThrowable;
                    if (JobKt.getJob((CoroutineContext)scopeContext).isCancelled() != false) throw finalThrowable;
                    if (JobKt.getJob((CoroutineContext)scopeContext).isCompleted() != false) throw finalThrowable;
                    var8_16 = this._yetRetryCount;
                    this._yetRetryCount = var8_16 + 1;
                    if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                        KoHttpLog.INSTANCE.d("execute \u5f02\u5e38 \u51c6\u5907\u8bf7\u6c42..\u5df2\u91cd\u8bd5=" + this._yetRetryCount + " \u9700\u8981=" + this.getNeedRetryCount());
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = jobHandle;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.label = 2;
                    v2 = this.executeReal(scopeContext, requestContext, type, (Continuation<? super R>)$continuation);
lbl63:
                    // 1 sources

                    if (v1 != null) {
                        v1.clear();
                    }
                    this._callWeakRef = null;
                    return var7_12;
lbl-1000:
                    // 1 sources

                    {
                        this.mRequestInterceptor.interceptExecute(this);
                        if (this.mGlobalInfoCreator != null) {
                            v3 = this.mGlobalInfoCreator;
                            Intrinsics.checkNotNull((Object)v3);
                            this._params.putAll(this.createGlobalParams(v3));
                            v4 = this.mGlobalInfoCreator;
                            Intrinsics.checkNotNull((Object)v4);
                            this._headers.putAll(this.createGlobalHeader(v4));
                        }
                        this.prepareRequestParams(this._params);
                        this.prepareRequestHeaders(this._headers);
                        this.mRequestInterceptor.interceptArguments(this, this._params, this._headers);
                        jobHandle = JobKt.getJob((CoroutineContext)scopeContext).invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this){
                            final /* synthetic */ HttpRequest this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@Nullable Throwable it) {
                                block1: {
                                    Call call;
                                    if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                                        KoHttpLog.INSTANCE.d("execute \u7236Job\u5b8c\u6210..\u53d6\u6d88call.1.isCancel=" + (it instanceof CancellationException) + " api=" + this.this$0.getApi() + " e=" + it);
                                    }
                                    if (!(it instanceof CancellationException) || (call = this.this$0.get_callWeakRef()) == null || (call = (Call)call.get()) == null) break block1;
                                    call.cancel();
                                }
                            }
                        });
                        var8_15 = result = this.sendRequest(scopeContext, requestContext, type);
                        KoHttpLog.INSTANCE.d("execute \u5b8c\u6210 finally callWeakRef=" + this._callWeakRef + " jobHandle=" + jobHandle);
                        v5 = this._callWeakRef;
                    }
                    if (v5 != null) {
                        v5.clear();
                    }
                    this._callWeakRef = null;
                    v6 = jobHandle;
                    if (v6 == null) return var8_15;
                    v6.dispose();
                    return var8_15;
                    v7 = v2;
                    if (v2 != var11_7) return v7;
                    return var11_7;
                }
            }
            case 2: {
                jobHandle = (DisposableHandle)$continuation.L$1;
                this = (HttpRequest)$continuation.L$0;
                ** try [egrp 3[TRYBLOCK] [5 : 717->727)] { 
lbl97:
                // 1 sources

                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
                return v7;
            }
        }
lbl101:
        // 1 sources

        finally {
            KoHttpLog.INSTANCE.d("execute \u5b8c\u6210 finally callWeakRef=" + this._callWeakRef + " jobHandle=" + jobHandle);
            v8 = this._callWeakRef;
            if (v8 != null) {
                v8.clear();
            }
            this._callWeakRef = null;
            v9 = jobHandle;
            if (v9 != null) {
                v9.dispose();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final Object sendRequest(@NotNull CoroutineContext scopeContext, @NotNull CoroutineContext requestContext, @NotNull Type type) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)scopeContext, (String)"scopeContext");
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Request request = this.createRequest(this._params, this._headers);
        request = this.mRequestInterceptor.interceptRequest(this, request);
        Call call = this.mRequestClient.getOkHttpClient().newCall(request);
        this._callWeakRef = new WeakReference<Call>(call);
        this._call = call;
        if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
            KoHttpLog.INSTANCE.d("\u5f00\u59cb\u8bf7\u6c42\u4e861..api=" + this.getApi());
        }
        try {
            response = call.execute();
        }
        catch (IOException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new KoCallIOException(string, e);
        }
        Response response2 = response;
        response2 = this.mRequestInterceptor.interceptResponse(this, response2);
        Object result2 = this.mRequestHandler.requestSuccess(this, call, response2, type);
        this.onHandlerRequestSuccessAfter(result2);
        this.writeCacheResult(result2, response2);
        return result2;
    }

    public final void writeCacheResult(@NotNull Object result2, @NotNull Response response) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            CacheMode cacheMode = this.mRequestCache.getCacheMode();
            if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_AFTER_FAILURE) {
                try {
                    boolean writeCacheResult = this.mRequestHandler.writeCache(this, response, result2);
                    if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                        KoHttpLog.INSTANCE.d("execute \u5199\u7f13\u5b58\u7ed3\u679c result=" + writeCacheResult);
                    }
                }
                catch (Throwable e) {
                    if (!KoHttpConfig.INSTANCE.getKLogEnabled()) break block4;
                    KoHttpLog.INSTANCE.d("execute \u5199\u7f13\u5b58\u5931\u8d25 e=" + e);
                }
            }
        }
    }

    @Nullable
    public final Object readCacheResult(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CacheMode cacheMode = this.mRequestCache.getCacheMode();
        if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_FIRST) {
            return this.mRequestHandler.readCache(this, type, this.mRequestCache.getCacheTimeMs());
        }
        return null;
    }

    public final /* synthetic */ <R> Type getRType() {
        boolean $i$f$getRType = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"R");
        return TypesJVMKt.getJavaType(null);
    }

    public void onHandlerRequestSuccessAfter(@NotNull Object result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }

    public abstract void addRequestParams(@NotNull Request.Builder var1, @NotNull HttpParams var2);

    @NotNull
    public abstract String getApi();

    public void prepareRequestParams(@NotNull HttpParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    public void prepareRequestHeaders(@NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
    }

    protected final void printKeyValue(@Nullable String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof Enum) {
            KoHttpLog.INSTANCE.printKeyValue(this, key, "\"" + value + "\"");
        } else if (value instanceof String) {
            KoHttpLog.INSTANCE.printKeyValue(this, key, "\"" + value + "\"");
        } else {
            KoHttpLog.INSTANCE.printKeyValue(this, key, value.toString());
        }
    }

    @NotNull
    public final Request createRequest(@NotNull HttpParams params, @NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Request.Builder requestBuilder = new Request.Builder();
        if (this.mRequestCache.getCacheMode() == CacheMode.NO_CACHE) {
            requestBuilder.cacheControl(new CacheControl.Builder().noCache().build());
        }
        this.addRequestHeader(requestBuilder, headers);
        this.addRequestParams(requestBuilder, params);
        return requestBuilder.build();
    }

    protected final void addRequestHeader(@NotNull Request.Builder requestBuilder, @NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        if (headers.isEmpty()) {
            return;
        }
        for (String key : headers.getKeys()) {
            String value = headers.get(key);
            try {
                requestBuilder.addHeader(key, value);
            }
            catch (IllegalArgumentException e) {
                requestBuilder.addHeader(KoHttpUtils.INSTANCE.encodeString(key), KoHttpUtils.INSTANCE.encodeString(value));
                if (!KoHttpConfig.INSTANCE.getKLogEnabled()) continue;
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public final String generateLogTag() {
        return this.getApi().getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    @NotNull
    public IRequestCache getRequestCache() {
        return this.mRequestCache;
    }

    @NotNull
    public final HttpParams getRequestParams() {
        return this._params;
    }

    @NotNull
    public final HttpHeaders getRequestHeaders() {
        return this._headers;
    }
}

