/*
 * Decompiled with CFR 0.152.
 */
package com.ko.http.config.body;

import android.text.TextUtils;
import com.ko.http.KoHttpConfig;
import com.ko.http.config.body.UpdateStreamRequestBody;
import com.ko.http.model.FileContentResolver;
import com.ko.http.model.HttpParams;
import com.ko.http.tools.KoHttpLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.Okio;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lcom/ko/http/config/body/FormRequestBody;", "", "()V", "addFormData", "", "bodyBuilder", "Lokhttp3/MultipartBody$Builder;", "key", "", "value", "createFormRequestBody", "Lokhttp3/RequestBody;", "params", "Lcom/ko/http/model/HttpParams;", "createMultipartRequestBody", "createRequestBody", "koHttp_debug"})
public final class FormRequestBody {
    @NotNull
    public static final FormRequestBody INSTANCE = new FormRequestBody();

    private FormRequestBody() {
    }

    @NotNull
    public final RequestBody createRequestBody(@NotNull HttpParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (params.isContainFileStream() && params.isNotEmpty()) {
            return this.createMultipartRequestBody(params);
        }
        return this.createFormRequestBody(params);
    }

    private final RequestBody createMultipartRequestBody(HttpParams params) {
        RequestBody requestBody;
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder(null, 1, null);
        bodyBuilder.setType(MultipartBody.FORM);
        for (String key : params.getKeys()) {
            Object value = params.get(key);
            if (value instanceof Map) {
                for (Object itemKey : ((Map)value).keySet()) {
                    Object itemValue;
                    if (itemKey == null || ((Map)value).get(itemKey) == null) continue;
                    this.addFormData(bodyBuilder, itemKey.toString(), itemValue);
                }
                continue;
            }
            if (value instanceof List) {
                for (Object itemValue : (List)value) {
                    if (itemValue == null) continue;
                    this.addFormData(bodyBuilder, key, itemValue);
                }
                continue;
            }
            Object object = value;
            Intrinsics.checkNotNull((Object)object);
            this.addFormData(bodyBuilder, key, object);
        }
        try {
            requestBody = (RequestBody)bodyBuilder.build();
        }
        catch (IllegalStateException ignored) {
            requestBody = (RequestBody)new MultipartBody.Builder(null, 1, null).build();
        }
        return requestBody;
    }

    private final void addFormData(MultipartBody.Builder bodyBuilder, String key, Object value) {
        if (value instanceof File) {
            String fileName = null;
            if (value instanceof FileContentResolver) {
                fileName = ((FileContentResolver)value).getFileName();
            }
            if (TextUtils.isEmpty((CharSequence)fileName)) {
                fileName = ((File)value).getName();
            }
            try {
                MultipartBody.Part part = null;
                if (value instanceof FileContentResolver) {
                    InputStream inputStream = ((FileContentResolver)value).openInputStream();
                    UpdateStreamRequestBody fileBody = new UpdateStreamRequestBody(Okio.source((InputStream)inputStream), ((FileContentResolver)value).getContentType(), fileName, inputStream.available());
                    part = MultipartBody.Part.Companion.createFormData(key, fileName, (RequestBody)fileBody);
                } else {
                    part = MultipartBody.Part.Companion.createFormData(key, fileName, (RequestBody)new UpdateStreamRequestBody((File)value));
                }
                bodyBuilder.addPart(part);
            }
            catch (FileNotFoundException e) {
                if (KoHttpConfig.INSTANCE.getKLogEnabled()) {
                    KoHttpLog.INSTANCE.d("\u6587\u4ef6\u6ca1\u627e\u5230 \u5ffd\u7565\u4e0a\u4f20: key=" + ((File)value).getPath());
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                KoHttpLog.INSTANCE.d("\u6587\u4ef6\u6d41\u8bfb\u53d6\u5931\u8d25\uff0c\u5c06\u88ab\u5ffd\u7565\u4e0a\u4f20: key=" + ((File)value).getPath());
                e.printStackTrace();
            }
            return;
        }
        if (value instanceof InputStream) {
            block16: {
                try {
                    bodyBuilder.addPart(MultipartBody.Part.Companion.createFormData(key, null, (RequestBody)new UpdateStreamRequestBody((InputStream)value, key)));
                }
                catch (IOException e) {
                    if (!KoHttpConfig.INSTANCE.getKLogEnabled()) break block16;
                    KoHttpLog.INSTANCE.d("InputStream \u4e0a\u4f20\u5931\u8d25");
                    e.printStackTrace();
                }
            }
            return;
        }
        if (value instanceof RequestBody) {
            Object requestBody = value;
            if (requestBody instanceof UpdateStreamRequestBody) {
                bodyBuilder.addPart(MultipartBody.Part.Companion.createFormData(key, ((UpdateStreamRequestBody)((Object)requestBody)).getKeyName(), (RequestBody)requestBody));
            } else {
                bodyBuilder.addPart(MultipartBody.Part.Companion.createFormData(key, null, (RequestBody)requestBody));
            }
            return;
        }
        if (value instanceof MultipartBody.Part) {
            bodyBuilder.addPart((MultipartBody.Part)value);
            return;
        }
        bodyBuilder.addFormDataPart(key, value.toString());
    }

    private final RequestBody createFormRequestBody(HttpParams params) {
        FormBody.Builder bodyBuilder = new FormBody.Builder(null, 1, null);
        if (params.isEmpty()) {
            return (RequestBody)bodyBuilder.build();
        }
        for (String key : params.getKeys()) {
            Object value;
            if (params.get(key) == null) continue;
            if (!(value instanceof List)) {
                bodyBuilder.add(key, value.toString());
                continue;
            }
            for (Object itemValue : (List)value) {
                if (itemValue == null) continue;
                bodyBuilder.add(key, itemValue.toString());
            }
        }
        return (RequestBody)bodyBuilder.build();
    }
}

