/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok.batch;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.ellabook.netwrok.R;
import com.ellabook.netwrok.bean.HttpOrderPriceResponse;
import com.ellabook.project.base.img.ImgLoader;
import com.ellabook.project.base.trade.HttpCoin;
import org.greenrobot.eventbus.EventBus;

public class EllaBatchShopView
extends LinearLayout {
    private View llSingle;
    private View llBatch;
    private View llLiner;
    private ImageView ui_imageSingleShow;
    private ImageView ui_shop_batchImageView;
    private ImageView ui_shop_singleImageView;
    private TextView ui_shop_single_content;
    private TextView ui_imageSingleShowTextView;
    private TextView ui_shop_single_content_below;
    private TextView ui_shop_price_below;
    private TextView ui_shop_price;
    private TextView ui_pay_price;
    private TextView ui_rest_price;
    private HttpOrderPriceResponse batchResponse;
    private HttpOrderPriceResponse response;
    private EllaCommonViewActionListener listener;
    private TextView ui_shop_batch_count;
    private TextView ui_shop_batch_count_tip;
    private TextView ui_shop_batch_count_price_tip;
    private TextView ui_shop_batch_content;

    public void showBatchPrice(HttpOrderPriceResponse batchResponse) {
        this.batchResponse = batchResponse;
        this.initData();
    }

    public void setOnEllaCommonViewActionListener(EllaCommonViewActionListener listener) {
        this.listener = listener;
    }

    public EllaBatchShopView(Context context) {
        super(context);
        this.init(context);
    }

    public EllaBatchShopView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EllaBatchShopView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ui_batch_shop, null);
        this.addView(view);
        this.llLiner = view.findViewById(R.id.llLiner);
        this.llBatch = view.findViewById(R.id.llBatch);
        this.llSingle = view.findViewById(R.id.llSingle);
        this.ui_shop_singleImageView = (ImageView)view.findViewById(R.id.ui_shop_singleImageView);
        this.ui_shop_batchImageView = (ImageView)view.findViewById(R.id.ui_shop_batchImageView);
        this.ui_imageSingleShow = (ImageView)view.findViewById(R.id.ui_imageSingleShow);
        this.ui_imageSingleShowTextView = (TextView)view.findViewById(R.id.ui_imageSingleShowTextView);
        this.ui_shop_single_content = (TextView)view.findViewById(R.id.ui_shop_single_content);
        this.ui_shop_single_content_below = (TextView)view.findViewById(R.id.ui_shop_single_content_below);
        this.ui_shop_price = (TextView)view.findViewById(R.id.ui_shop_price);
        this.ui_shop_price_below = (TextView)view.findViewById(R.id.ui_shop_price_below);
        this.ui_pay_price = (TextView)view.findViewById(R.id.ui_pay_price);
        this.ui_rest_price = (TextView)view.findViewById(R.id.ui_rest_price);
        this.ui_shop_batch_count = (TextView)view.findViewById(R.id.ui_shop_batch_count);
        this.ui_shop_batch_content = (TextView)view.findViewById(R.id.ui_shop_batch_content);
        this.ui_shop_batch_count_tip = (TextView)view.findViewById(R.id.ui_shop_batch_count_tip);
        this.ui_shop_batch_count_price_tip = (TextView)view.findViewById(R.id.ui_shop_batch_count_price_tip);
        view.findViewById(R.id.ui_rest_price_pay).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (EllaBatchShopView.this.listener != null) {
                    EllaBatchShopView.this.listener.onUnLockActionListener();
                }
            }
        });
        view.findViewById(R.id.ui_input_del).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EllaBatchShopView.this.batchResponse = null;
                if (EllaBatchShopView.this.listener != null) {
                    EllaBatchShopView.this.listener.onCancelClickListener();
                }
            }
        });
        view.findViewById(R.id.rlSingle).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EllaBatchShopView.this.initTab(0);
            }
        });
        view.findViewById(R.id.rlBatch).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EllaBatchShopView.this.initTab(1);
                if (EllaBatchShopView.this.batchResponse == null) {
                    EventBus.getDefault().post((Object)new HttpOrderPriceResponse());
                }
            }
        });
        this.initTab(0);
    }

    private void initTab(int index) {
        if (index == 0) {
            this.llSingle.setVisibility(0);
            this.llBatch.setVisibility(8);
            this.ui_shop_batchImageView.setVisibility(4);
            this.ui_shop_singleImageView.setVisibility(0);
        } else {
            this.llSingle.setVisibility(8);
            this.llBatch.setVisibility(0);
            this.ui_shop_batchImageView.setVisibility(0);
            this.ui_shop_singleImageView.setVisibility(4);
            this.initData();
        }
    }

    public boolean isBatchPay() {
        return this.llSingle.getVisibility() != 0;
    }

    public HttpOrderPriceResponse getPayInfo() {
        if (this.isBatchPay()) {
            return this.batchResponse;
        }
        return this.response;
    }

    public void setData(HttpOrderPriceResponse response) {
        if (response == null) {
            return;
        }
        boolean isBatch = response.isBatch;
        if (!isBatch) {
            this.llLiner.setVisibility(4);
        }
        this.response = response;
        ImgLoader.getInstance().loadRoundImg(this.getContext(), 4, response.coverUrl, this.ui_imageSingleShow, R.mipmap.ic_default_img);
        this.ui_imageSingleShowTextView.setText((CharSequence)response.lexileLevel);
        this.ui_shop_single_content.setText((CharSequence)response.bookName);
        this.ui_shop_single_content_below.setText((CharSequence)response.seriesName);
        this.ui_shop_price_below.setVisibility(4);
        this.ui_shop_price.setText((CharSequence)("\u4ef7\u683c\uff1a\uffe5" + response.goodsPrice));
        this.ui_rest_price.setText((CharSequence)("\u8d26\u6237\u4f59\u989d\uff1a" + response.balance + "\u54bf\u5566\u5e01"));
        this.ui_pay_price.setText((CharSequence)response.goodsActualPrice);
    }

    private void initData() {
        if (this.batchResponse == null) {
            return;
        }
        this.ui_pay_price.setText((CharSequence)this.batchResponse.goodsActualPrice);
        this.ui_shop_batch_content.setText((CharSequence)("\u5185\u5bb9\u7531" + this.batchResponse.publisher + "\u6388\u6743"));
        this.ui_shop_batch_count.setText((CharSequence)(this.batchResponse.needBuymissionOfMap + ""));
        this.ui_shop_batch_count_tip.setText((CharSequence)("\u672c\u5730\u56fe\u5305\u542b" + this.batchResponse.needBuymissionOfMap + "\u4e2a\u4ed8\u8d39\u5173\u5361"));
        String adad = "\u4ef7\u683c\uff1a" + this.batchResponse.goodsActualPrice + "\u54bf\u5566\u5e01 ";
        String content = adad + " \u539f\u4ef7\uff1a" + this.batchResponse.messionOfMapTotal;
        SpannableString spannableString = new SpannableString((CharSequence)content);
        spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#959499")), adad.length() + 1, content.length(), 33);
        spannableString.setSpan((Object)new StrikethroughSpan(), adad.length() + 1, content.length(), 33);
        this.ui_shop_batch_count_price_tip.setText((CharSequence)spannableString);
    }

    public static interface EllaCommonViewActionListener {
        public void onUnLockActionListener();

        public void onCancelClickListener();

        public void onParentConfirmActionListener();

        public void onRechargeActionListener(HttpCoin var1);

        public void onPayActionListener(int var1, String var2);
    }
}

