/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ellabook.netwrok.R;
import com.ellabook.netwrok.batch.EllaBackgroundView;
import com.ellabook.project.base.anim.CubicBezierInterpolator;
import com.ellabook.project.base.util.RandomUtil;
import com.ellabook.project.base.util.device.ScreenUtil;
import java.util.ArrayList;

public class EllaConfirmView
extends RelativeLayout
implements View.OnClickListener {
    private Context mContext;
    private EllaBackgroundView mBg;
    private int mDevHeight;
    private int mDevWidth;
    private int mDialogW;
    private int mDialogH;
    private int mInputCount;
    private ArrayList<TextView> mInputList = new ArrayList();
    private ArrayList<TextView> mInputBtnList = new ArrayList();
    private SparseArray<String> mAnswerArray = new SparseArray();
    private static final int MAX_INPUT_NUM = 3;
    private static final int MAX_BUTTON_NUM = 10;
    private static final int TYPE_TITLE = 0;
    private static final int TYPE_INPUT_RECT = 1;
    private static final int TYPE_BUTTON = 2;
    private static final int TYPE_CLOSE = 3;
    private static final int TAG_CLOSE = 1000;
    private String[] mNumberArray;
    private OnCheckDialogClickListener mListener;

    public EllaConfirmView(Context context) {
        super(context);
        this.init(context);
    }

    public EllaConfirmView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EllaConfirmView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mDevHeight = ScreenUtil.getDeviceHeight((Context)context, (boolean)false);
        this.mDevWidth = ScreenUtil.getDeviceWidth((Context)context, (boolean)false);
        this.mNumberArray = context.getResources().getStringArray(R.array.question_nums);
        this.initView();
    }

    private void initView() {
        this.generateBgView();
        this.generateTitle();
        this.generateInputRect();
        this.generateButton();
        this.generateCloseButton();
        this.generateQuestion();
    }

    public void resetCheckView() {
        this.generateQuestion();
    }

    public void generateQuestion() {
        for (int i = 0; i < 3; ++i) {
            TextView tv = this.mInputList.get(i);
            int randomResult = RandomUtil.generateRandom((int)1, (int)10);
            tv.setTextColor(this.getResources().getColor(R.color.input_rect_color));
            tv.setText((CharSequence)this.mNumberArray[randomResult]);
            this.mAnswerArray.put(i, (Object)String.valueOf(randomResult));
        }
    }

    private void generateCloseButton() {
        EllaBackgroundView close = new EllaBackgroundView(this.mContext);
        close.setSrc(R.drawable.close_parent_sure, 0.0625f, false);
        close.setTag(1000);
        close.setOnClickListener(this);
        this.posCtrl(close, 3);
        this.addView(close);
    }

    private void generateButton() {
        for (int i = 0; i < 10; ++i) {
            TextView button = new TextView(this.mContext);
            button.setText((CharSequence)String.valueOf(i));
            button.setTextSize(0, (float)Math.round((float)this.mDevHeight * 0.069f));
            button.setTextColor(this.getResources().getColor(R.color.white_100));
            button.setGravity(16);
            button.setPadding(Math.round((float)this.mDevHeight * 0.056f), 0, 0, 0);
            button.setBackgroundResource(R.drawable.ic_check_btn_bg);
            button.setTag((Object)i);
            button.setOnClickListener((View.OnClickListener)this);
            this.posCtrl((View)button, 2, i);
            this.addView((View)button);
            this.mInputBtnList.add(button);
        }
    }

    private void generateInputRect() {
        for (int i = 0; i < 3; ++i) {
            TextView input = new TextView(this.mContext);
            input.setTextSize(0, (float)Math.round((float)this.mDevHeight * 0.083f));
            input.setTextColor(this.getResources().getColor(R.color.input_rect_color));
            input.setGravity(17);
            input.setBackgroundResource(R.drawable.line_input);
            this.posCtrl((View)input, 1, i);
            this.addView((View)input);
            this.mInputList.add(input);
        }
    }

    private void generateTitle() {
        TextView title = new TextView(this.mContext);
        title.setText(R.string.please_input_num);
        title.setTextSize(0, (float)Math.round((float)this.mDevHeight * 0.053f));
        title.setTextColor(this.getResources().getColor(R.color.check_title_color));
        title.setGravity(17);
        this.posCtrl((View)title, 0);
        this.addView((View)title);
    }

    private void generateBgView() {
        this.mBg = new EllaBackgroundView(this.mContext);
        this.mBg.setSrc(R.drawable.parent_check_bg, 0.87f, false);
        this.addView(this.mBg);
    }

    private void posCtrl(View v, int type) {
        this.posCtrl(v, type, -1);
    }

    private void posCtrl(View v, int type, int i) {
        int w = -2;
        int h = -2;
        int rule = 9;
        int l = 0;
        int t = 0;
        int r = 0;
        int b = 0;
        switch (type) {
            case 0: {
                rule = 14;
                t = Math.round((float)this.mDevHeight * 0.17f);
                break;
            }
            case 1: {
                if (i == -1) {
                    return;
                }
                w = Math.round((float)this.mDevHeight * 0.16f);
                h = Math.round((float)this.mDevHeight * 0.16f);
                t = Math.round((float)this.mDevHeight * 0.275f);
                l = Math.round((float)this.mDevHeight * 0.385f) + i * (w + Math.round((float)this.mDevHeight * 0.053f));
                break;
            }
            case 2: {
                if (i == -1) {
                    return;
                }
                w = Math.round((float)this.mDevHeight * 0.171f);
                h = Math.round((float)this.mDevHeight * 0.132f);
                l = Math.round((float)this.mDevHeight * 0.217f) + i % 5 * (w + Math.round((float)this.mDevHeight * 0.021f));
                t = i < 5 ? Math.round((float)this.mDevHeight * 0.493f) : Math.round((float)this.mDevHeight * 0.653f);
                break;
            }
            case 3: {
                rule = 9;
                l = Math.round((float)this.mDevHeight * 1.23f);
                t = Math.round((float)this.mDevHeight * 0.12f);
            }
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(w, h);
        params.addRule(rule);
        params.setMargins(l, t, r, b);
        if (v == null) {
            return;
        }
        v.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void onClick(View view) {
        int tag = (Integer)view.getTag();
        if (tag == 1000) {
            if (this.mListener == null) {
                return;
            }
            this.mListener.closeDialog();
        } else {
            this.btnClickAnim(tag);
            this.updateInput(tag);
        }
    }

    private boolean verifyProcess() {
        TextView input = this.mInputList.get(this.mInputCount);
        if (input == null) {
            return false;
        }
        if (!TextUtils.equals((CharSequence)input.getText().toString(), (CharSequence)((CharSequence)this.mAnswerArray.get(this.mInputCount)))) {
            return false;
        }
        if (this.mListener != null && this.mInputCount == 2) {
            this.mListener.checkRight();
        }
        return true;
    }

    private void updateInput(int inputNum) {
        this.mInputCount = this.mInputCount > this.mInputList.size() - 1 ? this.mInputList.size() - 1 : this.mInputCount;
        TextView input = this.mInputList.get(this.mInputCount);
        if (input == null) {
            return;
        }
        input.setTextColor(this.getResources().getColor(R.color.ella_green));
        input.setText((CharSequence)String.valueOf(inputNum));
        if (!this.verifyProcess()) {
            this.shakeAnim();
            this.generateQuestion();
            this.mInputCount = 0;
        } else {
            ++this.mInputCount;
        }
    }

    private void shakeAnim() {
        Animation shake = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.shake_anim);
        for (TextView tv : this.mInputList) {
            if (tv == null) continue;
            tv.startAnimation(shake);
        }
    }

    private void btnClickAnim(int index) {
        if (this.mInputBtnList == null || this.mInputBtnList.size() <= index) {
            return;
        }
        TextView btn = this.mInputBtnList.get(index);
        if (btn == null) {
            return;
        }
        if (this.mDialogW <= 0 && this.mDialogH <= 0) {
            Rect bgLocation = new Rect();
            this.mBg.getGlobalVisibleRect(bgLocation);
            this.mDialogW = bgLocation.right - bgLocation.left;
            this.mDialogH = bgLocation.bottom - bgLocation.top;
        }
        float pivotX = (float)this.mDevHeight * 0.2f / 2.0f;
        float pivotY = (float)this.mDevHeight * 0.15f / 2.0f;
        float x = btn.getX();
        float y = btn.getY();
        float deltaX = (float)(this.mDevWidth - this.mDialogW) * 1.0f / 2.0f;
        float deltaY = (float)(this.mDevHeight - this.mDialogH) * 1.0f / 2.0f;
        float rawPivotX = x + deltaX + pivotX;
        float rawPivotY = y + deltaY + pivotY;
        ScaleAnimation anim2 = new ScaleAnimation(1.0f, 1.02f, 1.0f, 1.1f, rawPivotX, rawPivotY);
        anim2.setInterpolator((Interpolator)new CubicBezierInterpolator(0.68, 0.08, 0.35, 0.98));
        anim2.setRepeatMode(2);
        anim2.setDuration(50L);
        btn.startAnimation((Animation)anim2);
    }

    public void setCheckDialogClickListener(OnCheckDialogClickListener listener) {
        this.mListener = listener;
    }

    public static interface OnCheckDialogClickListener {
        public void closeDialog();

        public void checkRight();
    }
}

