/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok.batch;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.Nullable;
import com.ellabook.project.base.util.bitmap.BitmapUtil;
import com.ellabook.project.base.util.device.ScreenUtil;

public class EllaBackgroundView
extends View {
    private Bitmap resultBmp;
    private Context mContext;
    private int mUnitWidth;
    private int mUnitHeight;
    private RectF mClipRect;

    public EllaBackgroundView(Context context) {
        this(context, null);
    }

    public EllaBackgroundView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EllaBackgroundView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
    }

    private int getCount(float sourceWidth) {
        int count = 1;
        int devW = ScreenUtil.getDeviceWidth((Context)this.mContext, (boolean)false);
        count = sourceWidth >= (float)devW ? count + 1 : ((float)((int)Math.ceil((float)devW / sourceWidth)) * sourceWidth - (float)devW > sourceWidth ? (int)Math.ceil((float)devW / sourceWidth) : (int)Math.ceil((float)devW / sourceWidth) + 1);
        Log.d((String)"edwin", (String)("count is " + count));
        return count;
    }

    public int setSrc(int source, float ratioY, boolean needSplice) {
        return this.setSrc(source, 0.0f, ratioY, needSplice);
    }

    public int setSrc(int source, float ratioX, float ratioY, boolean needSplice) {
        return this.setSrc(source, ratioX, ratioY, needSplice, 1.0f);
    }

    public int setSrc(int source, float ratioX, float ratioY, boolean needSplice, float clipRatio) {
        PointF pointF = new PointF();
        pointF.x = ratioX;
        pointF.y = ratioY;
        Bitmap originBmp = BitmapUtil.bitmapSizeFit((Context)this.mContext, (int)source, (PointF)pointF, null);
        this.mUnitWidth = originBmp == null ? 0 : originBmp.getWidth();
        this.mUnitHeight = originBmp == null ? 0 : originBmp.getHeight();
        Bitmap tempBmp = needSplice ? BitmapUtil.spliceSameBitmaps((Context)this.mContext, (int)source, (int)this.getCount(this.mUnitWidth), (boolean)false) : originBmp;
        this.resultBmp = BitmapUtil.bitmapSizeFit((Context)this.mContext, (Bitmap)tempBmp, (PointF)pointF, null);
        if (this.resultBmp != null) {
            this.mClipRect = clipRatio < 1.0f ? new RectF(0.0f, 0.0f, (float)this.resultBmp.getWidth(), (float)Math.round((float)this.resultBmp.getHeight() * clipRatio)) : null;
        }
        this.invalidate();
        return this.mUnitWidth;
    }

    public int getViewWidth() {
        if (this.resultBmp == null) {
            return -1;
        }
        return this.resultBmp.getWidth();
    }

    public int getViewHeight() {
        if (this.resultBmp == null) {
            return -1;
        }
        return this.resultBmp.getHeight();
    }

    public int getUnitWidth() {
        return this.mUnitWidth;
    }

    public int getUnitHeight() {
        return this.mUnitHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.resultBmp != null) {
            this.setMeasuredDimension(this.resultBmp.getWidth(), this.resultBmp.getHeight());
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mClipRect != null) {
            canvas.clipRect(this.mClipRect);
        }
        canvas.drawBitmap(this.resultBmp, 0.0f, 0.0f, null);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.resultBmp != null) {
            this.resultBmp.recycle();
        }
    }
}

