/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ellabook.netwrok.R;
import com.ellabook.netwrok.batch.EllaBatchShopView;
import com.ellabook.project.base.trade.HttpCoin;
import java.util.Locale;

public class EllaSelectPayWayView
extends RelativeLayout {
    private Context mContext;
    private EllaBatchShopView.EllaCommonViewActionListener listener;
    private TextView tvPayPrice;
    private TextView tvEllaCoinDes;
    private ImageView ivPayWayByAli;
    private ImageView ivPayWayByWeChat;
    private int indexType;
    private HttpCoin httpCoin;

    public void setOnEllaCommonViewActionListener(EllaBatchShopView.EllaCommonViewActionListener listener) {
        this.listener = listener;
    }

    public EllaSelectPayWayView(Context context) {
        super(context);
        this.init(context);
    }

    public EllaSelectPayWayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EllaSelectPayWayView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_ella_select_pay_way, null);
        this.addView(view);
        view.findViewById(R.id.ivClosePayWay).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (EllaSelectPayWayView.this.listener != null) {
                    EllaSelectPayWayView.this.listener.onCancelClickListener();
                }
            }
        });
        view.findViewById(R.id.llPayAction).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (EllaSelectPayWayView.this.httpCoin != null && EllaSelectPayWayView.this.listener != null) {
                    EllaSelectPayWayView.this.listener.onPayActionListener(EllaSelectPayWayView.this.indexType, ((EllaSelectPayWayView)EllaSelectPayWayView.this).httpCoin.goodsCode);
                }
            }
        });
        this.ivPayWayByWeChat = (ImageView)view.findViewById(R.id.ivPayWayByWeChat);
        this.ivPayWayByAli = (ImageView)view.findViewById(R.id.ivPayWayByAli);
        this.tvPayPrice = (TextView)view.findViewById(R.id.tvPayPrice);
        this.tvEllaCoinDes = (TextView)view.findViewById(R.id.tvEllaCoinDes);
        this.ivPayWayByWeChat.setBackgroundResource(R.drawable.ic_pay_way_select);
        this.ivPayWayByAli.setBackgroundResource(R.drawable.ic_pay_way_default);
        this.indexType = 0;
        view.findViewById(R.id.rlPayWayByWechat).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EllaSelectPayWayView.this.ivPayWayByWeChat.setBackgroundResource(R.drawable.ic_pay_way_select);
                EllaSelectPayWayView.this.ivPayWayByAli.setBackgroundResource(R.drawable.ic_pay_way_default);
                EllaSelectPayWayView.this.indexType = 0;
            }
        });
        view.findViewById(R.id.rlPayWayByAli).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EllaSelectPayWayView.this.ivPayWayByWeChat.setBackgroundResource(R.drawable.ic_pay_way_default);
                EllaSelectPayWayView.this.ivPayWayByAli.setBackgroundResource(R.drawable.ic_pay_way_select);
                EllaSelectPayWayView.this.indexType = 1;
            }
        });
    }

    public void initData(HttpCoin httpCoin) {
        this.httpCoin = httpCoin;
        if (this.httpCoin != null) {
            this.tvPayPrice.setText((CharSequence)String.format(Locale.getDefault(), "\u00a5 %.2f", Float.valueOf(Float.parseFloat(httpCoin.goodsActualPrice))));
            if (httpCoin.isMapMemberCoin) {
                this.tvEllaCoinDes.setText((CharSequence)httpCoin.coinDesc);
            } else {
                this.tvEllaCoinDes.setText((CharSequence)String.format(Locale.getDefault(), "\u4ee5\u5145\u503c%s", httpCoin.coinDesc));
            }
        }
    }
}

