/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok.recharge;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.netwrok.R;
import com.ellabook.netwrok.recharge.EllaRechargeView;
import com.ellabook.project.base.font.EllaBoldFontTypefaceSpan;
import com.ellabook.project.base.font.EllaFontUtils;
import com.ellabook.project.base.trade.HttpCoin;
import java.util.ArrayList;
import java.util.List;

public class EllaRechargeAdapter
extends RecyclerView.Adapter<ProfileCoinAdapterHolder> {
    private Context context;
    private List<HttpCoin> list;
    private int selectIndex;
    private EllaRechargeView ellaRechargeView;

    public EllaRechargeAdapter(EllaRechargeView ellaRechargeView) {
        this.ellaRechargeView = ellaRechargeView;
        this.context = ellaRechargeView.getContext();
        this.list = new ArrayList<HttpCoin>();
        this.selectIndex = -1;
    }

    @NonNull
    public ProfileCoinAdapterHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ProfileCoinAdapterHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.ella_coin_adapter_item, null));
    }

    public void onBindViewHolder(@NonNull ProfileCoinAdapterHolder holder, final int position) {
        final HttpCoin httpCoin = this.list.get(position);
        if (this.selectIndex == position) {
            holder.llProfileTopCoinContent.setBackgroundResource(R.drawable.ella_coin_e7_7);
            holder.profileCoinTopText.setTextColor(Color.parseColor((String)"#3E0008"));
            holder.profileCoinBottomText.setTextColor(Color.parseColor((String)"#003600"));
        } else {
            holder.llProfileTopCoinContent.setBackgroundResource(R.drawable.profile_coin_e5_7);
            holder.profileCoinTopText.setTextColor(Color.parseColor((String)"#000000"));
            holder.profileCoinBottomText.setTextColor(Color.parseColor((String)"#494949"));
        }
        this.showFormatPriceText(holder.profileCoinTopText, httpCoin);
        if (TextUtils.isEmpty((CharSequence)httpCoin.giftDesc)) {
            holder.profileCoinCenterText.setText((CharSequence)"");
            holder.profileCoinCenterText.setVisibility(8);
        } else {
            holder.profileCoinCenterText.setText((CharSequence)httpCoin.giftDesc);
            holder.profileCoinCenterText.setVisibility(0);
        }
        holder.profileCoinBottomText.setText((CharSequence)httpCoin.coinDesc);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EllaRechargeAdapter.this.selectIndex = position;
                EllaRechargeAdapter.this.notifyDataSetChanged();
                EllaRechargeAdapter.this.ellaRechargeView.showSelected(httpCoin);
            }
        });
    }

    private void showFormatPriceText(TextView textView, HttpCoin httpCoin) {
        String price = String.valueOf(httpCoin.price) + "\u5143";
        if (!TextUtils.isEmpty((CharSequence)price) && price.length() > 1) {
            SpannableString spannableString = new SpannableString((CharSequence)price);
            spannableString.setSpan((Object)new AbsoluteSizeSpan(24, true), 0, price.length() - 1, 33);
            spannableString.setSpan((Object)new EllaBoldFontTypefaceSpan("20", EllaFontUtils.getEllaBoldTypeface((Context)this.context)), 0, price.length() - 1, 33);
            textView.setText((CharSequence)spannableString);
        } else {
            textView.setText((CharSequence)price);
        }
    }

    public int getItemCount() {
        return this.list.size();
    }

    public void setData(List<HttpCoin> httpCoins) {
        this.list.addAll(httpCoins);
        this.notifyDataSetChanged();
    }

    class ProfileCoinAdapterHolder
    extends RecyclerView.ViewHolder {
        TextView profileCoinTopText;
        TextView profileCoinBottomText;
        TextView profileCoinCenterText;
        View llProfileTopCoinContent;

        ProfileCoinAdapterHolder(View view) {
            super(view);
            this.profileCoinTopText = (TextView)view.findViewById(R.id.profileCoinTopText);
            this.profileCoinBottomText = (TextView)view.findViewById(R.id.profileCoinBottomText);
            this.profileCoinCenterText = (TextView)view.findViewById(R.id.profileCoinCenterText);
            this.llProfileTopCoinContent = view.findViewById(R.id.llProfileTopCoinContent);
        }
    }
}

