/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok.http;

import android.text.TextUtils;
import android.util.Log;
import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.NetworkCacheHelper;
import com.ellabook.project.base.util.NetworkUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class PostCacheInterceptor
implements Interceptor {
    public static final String TAG = "PostCacheInterceptor";
    final NetworkCacheHelper cache;
    private final int REQUEST_URL = 0;
    private final int REQUEST_METHOD = 1;
    private final int REQUESTCONTENTTYPE = 2;
    private final int PROTOCAL = 3;
    private final int CODE = 4;
    private final int MESSAGE = 5;
    private final int REPONSE_BODY = 6;
    private final int MEDIA_TYPE = 7;
    private final int SETN_REQUEST_AT_MILLIS = 8;
    private final int RECEIVE_REPONSE_AT_MILLIS = 9;
    private final int CACHE_LENGTH = 10;

    public PostCacheInterceptor(NetworkCacheHelper cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String cacheRes;
        if (!this.isNeedCache(chain.request())) {
            return chain.proceed(chain.request());
        }
        String key = this.createKey(chain.request());
        Log.d((String)TAG, (String)("cache key: " + key));
        Response cacheResponse = null;
        String string2 = cacheRes = this.cache != null && key != null ? this.cache.get(key) : null;
        if (!TextUtils.isEmpty(cacheRes)) {
            cacheResponse = this.combineCacheToResponse(cacheRes);
        }
        if (!NetworkUtil.networkAvailable()) {
            Log.d((String)TAG, (String)"no network connected jujge cache available");
            if (cacheResponse != null) {
                Log.d((String)TAG, (String)("no network connected, return cache\uff1a " + cacheResponse));
                return cacheResponse;
            }
        }
        Log.d((String)TAG, (String)"waiting for network response...");
        Request netWorkRequest = chain.request();
        Response networkResponse = null;
        try {
            networkResponse = chain.proceed(netWorkRequest);
        }
        finally {
            if (networkResponse == null) {
                Log.d((String)TAG, (String)"close cache response...");
                if (cacheResponse != null && HttpHeaders.hasBody((Response)cacheResponse)) {
                    Util.closeQuietly((Closeable)cacheResponse.body());
                }
                return chain.proceed(netWorkRequest);
            }
        }
        Log.d((String)TAG, (String)"prepare update cache response...");
        if (cacheResponse != null) {
            Response response = null;
            response = networkResponse.newBuilder().request(new Request.Builder().method("GET", null).url(netWorkRequest.url()).headers(netWorkRequest.headers()).tag(netWorkRequest.tag()).build()).build();
            Log.d((String)TAG, (String)"update cache response");
            if (key != null) {
                this.cache.put(key, this.createCache(response));
            }
            if (cacheResponse != null && HttpHeaders.hasBody((Response)cacheResponse)) {
                Util.closeQuietly((Closeable)cacheResponse.body());
            }
            return networkResponse;
        }
        Request newRequest = new Request.Builder().method("GET", null).url(netWorkRequest.url()).headers(netWorkRequest.headers()).tag(netWorkRequest.tag()).build();
        Response newResponse = networkResponse.newBuilder().request(newRequest).build();
        Log.d((String)TAG, (String)"init cache response");
        if (this.cache != null) {
            Log.d((String)TAG, (String)("url: " + netWorkRequest.url().toString()));
            if (!newResponse.isSuccessful() && cacheResponse != null) {
                Log.d((String)TAG, (String)("response code failed, return cache\uff1a " + cacheResponse));
                return cacheResponse;
            }
            if (HttpHeaders.hasBody((Response)newResponse)) {
                try {
                    Log.d((String)TAG, (String)("chain request url: " + newResponse.request().url()));
                    if (key != null) {
                        this.cache.put(key, this.createCache(newResponse));
                        Log.d((String)TAG, (String)("put cache response key: " + key));
                    }
                    Response response = networkResponse;
                    return response;
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)("put cache exception: " + e));
                }
                finally {
                    if (cacheResponse != null && HttpHeaders.hasBody((Response)cacheResponse)) {
                        Util.closeQuietly((Closeable)cacheResponse.body());
                    }
                }
            }
        }
        return networkResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createKey(Request request) {
        RequestBody requestBody = request.body();
        Charset charset = Charset.forName("UTF-8");
        String url = request.url().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(url + "&");
        MediaType type = requestBody.contentType();
        if (type != null) {
            charset = type.charset() == null ? charset : type.charset();
        }
        try (Buffer buffer = new Buffer();){
            requestBody.writeTo((BufferedSink)buffer);
            sb.append(buffer.readString(charset));
        }
        if (request.headers() != null && request.headers().names() != null) {
            ArrayList names = new ArrayList(request.headers().names());
            Collections.sort(names);
            for (String key : names) {
                if (key == null || request.headers().get(key) == null) continue;
                sb.append(key);
                sb.append("&");
                sb.append(request.headers().get(key));
            }
        }
        return sb.toString();
    }

    private int[] getIndexofKeyValue(String str, String originStr) {
        int[] indexs;
        indexs = new int[]{originStr.indexOf(str), originStr.indexOf("&", indexs[0]) >= 0 ? originStr.indexOf("&", indexs[0]) : originStr.length()};
        Log.d((String)TAG, (String)("index0: " + indexs[0] + " index1: " + indexs[1]));
        return indexs;
    }

    private boolean isNeedCache(Request request) {
        return EllaHttpService.needCache(request);
    }

    private Response combineCacheToResponse(String cache) {
        String[] caches = cache.split("&#&#");
        if (caches == null || caches.length <= 0) {
            return null;
        }
        Request request = new Request.Builder().url(caches[0]).method(caches[1], null).build();
        Response.Builder builder = new Response.Builder();
        try {
            builder.protocol(Protocol.get((String)caches[3]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.message(caches[5]).code(Integer.valueOf(caches[4]).intValue()).request(request).receivedResponseAtMillis(Long.valueOf(caches[9]).longValue()).sentRequestAtMillis(Long.valueOf(caches[8]).longValue()).body(ResponseBody.create((MediaType)MediaType.parse((String)caches[7]), (String)caches[6])).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createCache(Response response) {
        String[] caches = new String[10];
        caches[0] = response.request().url().toString();
        caches[1] = response.request().method();
        caches[2] = response.request().body() != null && response.request().body().contentType() != null ? response.request().body().contentType().toString() : "application/x-www-form-urlencoded";
        caches[3] = response.protocol().toString();
        caches[4] = response.code() + "";
        caches[5] = response.message();
        caches[7] = response.body() != null && response.body().contentType() != null ? response.body().contentType().toString() : "application/x-www-form-urlencoded";
        caches[8] = response.sentRequestAtMillis() + "";
        caches[9] = response.receivedResponseAtMillis() + "";
        if (HttpHeaders.hasBody((Response)response)) {
            BufferedSource source = response.body().source();
            Buffer buffer = null;
            try {
                source.request(Long.MAX_VALUE);
                buffer = source.buffer();
                Charset charset = response.body().contentType().charset();
                if (charset == null) {
                    charset = Charset.forName("UTF-8");
                }
                caches[6] = buffer.clone().readString(charset);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String cache = "";
        for (String str : caches) {
            cache = cache + str + "&#&#";
        }
        return cache;
    }

    static boolean isEndToEnd(String fieldName) {
        return !"Connection".equalsIgnoreCase(fieldName) && !"Keep-Alive".equalsIgnoreCase(fieldName) && !"Proxy-Authenticate".equalsIgnoreCase(fieldName) && !"Proxy-Authorization".equalsIgnoreCase(fieldName) && !"TE".equalsIgnoreCase(fieldName) && !"Trailers".equalsIgnoreCase(fieldName) && !"Transfer-Encoding".equalsIgnoreCase(fieldName) && !"Upgrade".equalsIgnoreCase(fieldName);
    }

    private String subString(String str, int[] index) {
        if (index == null || index.length < 2) {
            return null;
        }
        if (index[0] < 0 || index[1] < 0) {
            return null;
        }
        return str.substring(index[0], index[1]);
    }
}

