/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok.http;

import android.app.Application;
import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.ellabook.netwrok.NetworkModule;
import com.ellabook.netwrok.R;
import com.ellabook.netwrok.api.EllaApiService;
import com.ellabook.netwrok.bean.HttpCoinList;
import com.ellabook.netwrok.bean.HttpOrderPriceResponse;
import com.ellabook.netwrok.bean.HttpUpdate;
import com.ellabook.netwrok.bean.ResponseDataWrapper;
import com.ellabook.netwrok.bean.home.HttpWelfarePopInfo;
import com.ellabook.netwrok.bean.order.HttpAliRequest;
import com.ellabook.netwrok.bean.order.HttpOrderRequest;
import com.ellabook.netwrok.bean.order.HttpOrderResponse;
import com.ellabook.netwrok.bean.profile.HttpFollowRecord;
import com.ellabook.netwrok.bean.profile.HttpJuge;
import com.ellabook.netwrok.bean.profile.HttpLearnRecord;
import com.ellabook.netwrok.bean.profile.HttpSearchRecord;
import com.ellabook.netwrok.bean.profile.HttpTasteLearnRecord;
import com.ellabook.netwrok.bean.profile.HttpWordDetails;
import com.ellabook.netwrok.bean.profile.HttpWordWall;
import com.ellabook.netwrok.bean.third.HttpThirdRequest;
import com.ellabook.netwrok.bean.user.HttpLearnReport;
import com.ellabook.netwrok.bean.user.HttpNick;
import com.ellabook.netwrok.bean.user.HttpRegister;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.netwrok.http.NetworkCacheHelper;
import com.ellabook.netwrok.http.PostCacheInterceptor;
import com.ellabook.project.base.AppInfo;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.HttpHomeInfo;
import com.ellabook.project.base.HttpUser;
import com.ellabook.project.base.HttpUserInfo;
import com.ellabook.project.base.trade.HttpCoin;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.NetworkUtil;
import com.ellabook.project.base.util.device.DeviceUtil;
import com.ellabook.project.base.util.encrypt.Md5Util;
import com.franmontiel.persistentcookiejar.PersistentCookieJar;
import com.franmontiel.persistentcookiejar.cache.CookieCache;
import com.franmontiel.persistentcookiejar.cache.SetCookieCache;
import com.franmontiel.persistentcookiejar.persistence.CookiePersistor;
import com.franmontiel.persistentcookiejar.persistence.SharedPrefsCookiePersistor;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import com.trello.rxlifecycle2.LifecycleTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.Cache;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class EllaHttpService {
    public static final String TAG = "EllaHttpService";
    private final Map<String, StringGetter> mExtraHeader = new ConcurrentHashMap<String, StringGetter>();
    private static PathConvert pathConvert;
    private Set<String> mCacheableRequest = new ConcurrentSkipListSet<String>();
    private static EllaHttpService instance;
    private EllaApiService excuteCommandApi;
    private Context context;
    private static Map<Class, Object> map;
    private static Integer sLock;

    public void addHeader(String key, StringGetter valueGetter) {
        if (key != null && valueGetter != null) {
            this.mExtraHeader.put(key, valueGetter);
        }
    }

    public static void setPathConvert(PathConvert pc) {
        pathConvert = pc;
    }

    public void addCacheableRequest(String requestUrl) {
        this.mCacheableRequest.add(requestUrl);
    }

    public static boolean needCache(Request request) {
        String encodedPath = request.url().encodedPath();
        return EllaHttpService.getInstance((Context)ApplicationHolder.getContext()).mCacheableRequest.contains(encodedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EllaHttpService getInstance(Context context) {
        if (instance != null) return instance;
        Class<EllaHttpService> clazz = EllaHttpService.class;
        synchronized (EllaHttpService.class) {
            if (instance != null) return instance;
            instance = new EllaHttpService(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private EllaHttpService(Context mContext) {
        try {
            this.context = this.context instanceof Application ? mContext : mContext.getApplicationContext();
            this.excuteCommandApi = EllaHttpService.buildInterfaceImpl(EllaApiService.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T buildInterfaceImpl(Class<T> tClass) {
        OkHttpClient client = EllaHttpService.initBuilderClient(ApplicationHolder.getContext());
        Retrofit retrofit = new Retrofit.Builder().client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(ApplicationHolder.getContext().getResources().getString(R.string.english_base_api_url)).build();
        return (T)retrofit.create(tClass);
    }

    private static OkHttpClient initBuilderClient(Context context) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Cache cache = new Cache(new File(Environment.getExternalStorageDirectory() + "/okhttp_cache/"), 0x6400000L);
        builder = builder.connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS);
        builder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request.Builder originalBuilder = chain.request().newBuilder();
                String token = UserInfoProvider.getToken();
                if (!TextUtils.isEmpty((CharSequence)token)) {
                    try {
                        originalBuilder.addHeader("Authorization", "Bearer " + token);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                JSONObject headJsonParams = new JSONObject();
                try {
                    headJsonParams.put("channelCode", (Object)AppInfo.getChannel());
                    headJsonParams.put("clientRole", (Object)ApplicationHolder.getContext().getResources().getString(R.string.network_client_role));
                    headJsonParams.put("clientType", (Object)"android");
                    if (NetworkModule.getInstance().getDevice() != null) {
                        headJsonParams.put("deviceNo", (Object)NetworkModule.getInstance().getDevice().getDeivceId());
                    } else {
                        headJsonParams.put("deviceNo", (Object)DeviceUtil.getDeviceId((Context)ApplicationHolder.getContext()));
                    }
                    headJsonParams.put("resource", (Object)AppInfo.getPhoneResource());
                    for (Map.Entry entry : EllaHttpService.getInstance(ApplicationHolder.getContext()).mExtraHeader.entrySet()) {
                        headJsonParams.put((String)entry.getKey(), (Object)((StringGetter)entry.getValue()).get());
                    }
                    String jsonHeadString = Base64.encodeToString((byte[])headJsonParams.toString().getBytes(), (int)2);
                    originalBuilder.addHeader("enHeadParam", jsonHeadString);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Request request = originalBuilder.build();
                return chain.proceed(request);
            }
        });
        builder.addInterceptor((Interceptor)new PostCacheInterceptor(new NetworkCacheHelper())).cache(cache);
        builder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                if (pathConvert != null) {
                    Request request = chain.request();
                    Request.Builder builder = request.newBuilder();
                    builder.url(request.url().newBuilder().encodedPath(pathConvert.converPath(request.url().encodedPath())).host(pathConvert.converHost(request.url().host())).build());
                    return chain.proceed(builder.build());
                }
                return chain.proceed(chain.request());
            }
        });
        PersistentCookieJar cookieJar = new PersistentCookieJar((CookieCache)new SetCookieCache(), (CookiePersistor)new SharedPrefsCookiePersistor(context));
        builder.cookieJar((CookieJar)cookieJar);
        return builder.build();
    }

    private RequestBody getPublicParamter(JSONObject map) throws Exception {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)map.toString());
    }

    public static void handleRequest(LifecycleTransformer lifecycleTransformer, @Nullable Observable observable, final HttpServiceCallBack callBack) {
        if (lifecycleTransformer != null) {
            observable = observable.compose((ObservableTransformer)lifecycleTransformer);
        }
        observable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<ResponseDataWrapper>(){

            public void accept(ResponseDataWrapper result) throws Exception {
                if (callBack != null) {
                    if (result.getCode().equals("000000")) {
                        try {
                            callBack.onHttpServiceFinished(result.getData());
                        }
                        catch (Exception e) {
                            callBack.onHttpServiceError(-1, "\u5ba2\u6237\u7aef\u5f02\u5e38");
                            Log.e((String)EllaHttpService.TAG, (String)"callback onHttpServiceFinished error", (Throwable)e);
                        }
                    } else if (NetworkModule.getInstance().getCatcher() == null || !NetworkModule.getInstance().getCatcher().catchReponse(result)) {
                        callBack.onHttpServiceError(Integer.parseInt(result.getCode()), result.getMessage());
                    }
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                EllaHttpService.dealWithThrowable(throwable, callBack);
            }
        }, new Action(){

            public void run() throws Exception {
            }
        });
    }

    private static void dealWithThrowable(Throwable throwable, HttpServiceCallBack callBack) {
        if (callBack != null) {
            if (throwable instanceof ConnectException) {
                callBack.onHttpServiceError(2, ApplicationHolder.getContext().getString(R.string.no_network));
            } else if (throwable instanceof TimeoutException || throwable instanceof SocketTimeoutException) {
                callBack.onHttpServiceError(2, ApplicationHolder.getContext().getString(R.string.network_timeout));
            } else if (!NetworkUtil.networkAvailable()) {
                callBack.onHttpServiceError(2, ApplicationHolder.getContext().getString(R.string.no_network));
            } else {
                callBack.onHttpServiceError(2, ApplicationHolder.getContext().getString(R.string.network_failure));
            }
        }
    }

    public void getSplashInfo(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<String> callBack) {
        try {
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getSplshInfo(), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getCode(LifecycleTransformer lifecycleTransformer, String phone, int type, HttpServiceCallBack<String> callBack) {
        try {
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getCode(phone, type), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void register(LifecycleTransformer lifecycleTransformer, String phone, String code, String pwd, HttpServiceCallBack<HttpRegister> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerName", (Object)phone);
            jsonObject.put("checkCode", (Object)code);
            jsonObject.put("password", (Object)Md5Util.encrypt((String)pwd));
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.register(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loginByCode(LifecycleTransformer lifecycleTransformer, String phone, String code, HttpServiceCallBack<HttpUser> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerName", (Object)phone);
            jsonObject.put("checkCode", (Object)code);
            jsonObject.put("loginVerificationType", (Object)"1");
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.login(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void visitorsLogin(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<HttpUser> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.visitorsLogin(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loginByPwd(LifecycleTransformer lifecycleTransformer, String phone, String pwd, HttpServiceCallBack<HttpUser> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerName", (Object)phone);
            jsonObject.put("password", (Object)Md5Util.encrypt((String)pwd));
            jsonObject.put("loginVerificationType", (Object)"0");
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.login(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getNickNames(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<HttpNick> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pageSize", (Object)String.valueOf(21));
            jsonObject.put("orderBy", (Object)String.valueOf(1));
            jsonObject.put("status", (Object)"NORMAL");
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getNickNames(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void completeInfo(LifecycleTransformer lifecycleTransformer, String birthday, String isTemplate, String nickName, String uid, HttpServiceCallBack<String> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("birthday", (Object)birthday);
            jsonObject.put("isTemplate", (Object)isTemplate);
            jsonObject.put("nickName", (Object)nickName);
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.completeInfo(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetPwd(LifecycleTransformer lifecycleTransformer, String phone, String checkCode, String pwd, HttpServiceCallBack<String> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerName", (Object)phone);
            jsonObject.put("checkCode", (Object)checkCode);
            jsonObject.put("password", (Object)Md5Util.encrypt((String)pwd));
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.resetCode(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getUserInfo(LifecycleTransformer lifecycleTransformer, String uid, HttpServiceCallBack<HttpUserInfo> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            jsonObject.put("isIos", 0);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getUserInfo(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void modifyUserInfo(LifecycleTransformer lifecycleTransformer, String uid, String avatar, long birthday, String enName, String gender, String region, HttpServiceCallBack<Boolean> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            if (!TextUtils.isEmpty((CharSequence)avatar)) {
                jsonObject.put("avatar", (Object)avatar);
            }
            if (birthday != 0L) {
                jsonObject.put("birthday", birthday);
            }
            if (!TextUtils.isEmpty((CharSequence)enName)) {
                jsonObject.put("enName", (Object)enName);
            }
            if (!TextUtils.isEmpty((CharSequence)gender)) {
                jsonObject.put("gender", (Object)gender);
            }
            if (!TextUtils.isEmpty((CharSequence)region)) {
                jsonObject.put("region", (Object)region);
            }
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.modifyUserInfo(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFeedBack(LifecycleTransformer lifecycleTransformer, String attach1, String attach2, String attach3, String contact, String content, HttpServiceCallBack<Boolean> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)attach1)) {
                jsonObject.put("attach1", (Object)attach1);
            }
            if (!TextUtils.isEmpty((CharSequence)attach2)) {
                jsonObject.put("attach2", (Object)attach2);
            }
            if (!TextUtils.isEmpty((CharSequence)attach3)) {
                jsonObject.put("attach3", (Object)attach3);
            }
            if (!TextUtils.isEmpty((CharSequence)contact)) {
                jsonObject.put("contact", (Object)contact);
            }
            jsonObject.put("content", (Object)content);
            jsonObject.put("channel", (Object)AppInfo.getChannel());
            jsonObject.put("deviceModel", (Object)DeviceUtil.getDeviceId((Context)ApplicationHolder.getContext()));
            jsonObject.put("version", AppInfo.getVersionCode());
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.addFeedBack(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getLearnReport(LifecycleTransformer lifecycleTransformer, String uid, HttpServiceCallBack<HttpLearnReport> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getLearnReport(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getHomePageInfo(LifecycleTransformer lifecycleTransformer, String uid, HttpServiceCallBack<HttpHomeInfo> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getHomePageInfo(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getWelfarePopupInfo(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<HttpWelfarePopInfo> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getWelfarePopupInfo(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getWordsWallData(LifecycleTransformer lifecycleTransformer, String initial, HttpServiceCallBack<HttpWordWall> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("initial", (Object)initial);
            jsonObject.put("type", (Object)"android");
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getWordWallData(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getWordDetails(LifecycleTransformer lifecycleTransformer, String uid, String word, HttpServiceCallBack<HttpWordDetails> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            jsonObject.put("word", (Object)word);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getWordDetails(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> void getMapList(LifecycleTransformer lifecycleTransformer, String uid, Observable<T> observable, HttpServiceCallBack<List<T>> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, observable, callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logout(LifecycleTransformer lifecycleTransformer, String token, HttpServiceCallBack<String> callBack) {
        try {
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.logout(token), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createPayOrder(LifecycleTransformer lifecycleTransformer, HttpOrderRequest request, HttpServiceCallBack<HttpOrderResponse> httpServiceCallBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            List<HttpAliRequest> list = request.getOrderDetails();
            for (HttpAliRequest bean : list) {
                JSONObject object = new JSONObject();
                object.put("goodsNo", (Object)bean.getGoodsNo());
                object.put("goodsNum", bean.getGoodsNum());
                jsonArray.put((Object)object);
            }
            jsonObject.put("orderDetails", (Object)jsonArray);
            jsonObject.put("orderType", (Object)request.getOrderType());
            jsonObject.put("payMethod", (Object)request.getPayMethod());
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.createOrder(body), httpServiceCallBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createMemberPayOrder(LifecycleTransformer lifecycleTransformer, HttpOrderRequest request, HttpServiceCallBack<HttpOrderResponse> httpServiceCallBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            List<HttpAliRequest> list = request.getOrderDetails();
            for (HttpAliRequest bean : list) {
                JSONObject object = new JSONObject();
                object.put("goodsNo", (Object)bean.getGoodsNo());
                object.put("goodsNum", bean.getGoodsNum());
                jsonArray.put((Object)object);
            }
            jsonObject.put("clientType", (Object)"ANDROID");
            jsonObject.put("orderDetails", (Object)jsonArray);
            jsonObject.put("payMethod", (Object)request.getPayMethod());
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.createMemberOrder(body), httpServiceCallBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getCoinRecord(LifecycleTransformer lifecycleTransformer, String uid, String pageNo, String pageSize, HttpServiceCallBack<HttpCoinList> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            jsonObject.put("pageNo", (Object)pageNo);
            jsonObject.put("pageSize", (Object)pageSize);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getCoinRecord(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getConConfig(LifecycleTransformer lifecycleTransformer, String uid, HttpServiceCallBack<List<HttpCoin>> callBack) {
        try {
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getCoinConfig(uid), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getMemberConConfig(LifecycleTransformer lifecycleTransformer, String uid, HttpServiceCallBack<List<HttpCoin>> callBack) {
        try {
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getMemberCoinConfig(uid), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getLearnRecords(LifecycleTransformer lifecycleTransformer, String levelCode, String uid, HttpServiceCallBack<List<HttpLearnRecord>> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("levelCode", (Object)levelCode);
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getLearnRecord(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getTasteLearnRecords(LifecycleTransformer lifecycleTransformer, String uid, HttpServiceCallBack<HttpTasteLearnRecord> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getTasteLearnRecord(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getFollowRecords(LifecycleTransformer lifecycleTransformer, String levelCode, String courseCode, String missionCode, String uid, int pageNo, HttpServiceCallBack<HttpFollowRecord> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("levelCode", (Object)levelCode);
            jsonObject.put("courseCode", (Object)courseCode);
            jsonObject.put("missionCode", (Object)missionCode);
            jsonObject.put("uid", (Object)uid);
            jsonObject.put("pageNo", pageNo);
            jsonObject.put("pageSize", 10);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getFollowRecords(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getQueryRecords(LifecycleTransformer lifecycleTransformer, String levelCode, String courseCode, String missionCode, String uid, int pageNo, HttpServiceCallBack<HttpSearchRecord> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("levelCode", (Object)levelCode);
            jsonObject.put("courseCode", (Object)courseCode);
            jsonObject.put("missionCode", (Object)missionCode);
            jsonObject.put("uid", (Object)uid);
            jsonObject.put("pageNo", pageNo);
            jsonObject.put("pageSize", 10);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getQueryRecords(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addWord(LifecycleTransformer lifecycleTransformer, String word, String levelCode, HttpServiceCallBack<Boolean> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("word", (Object)word);
            jsonObject.put("levelCode", (Object)levelCode);
            jsonObject.put("type", (Object)"android");
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.addWord(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void upLoadFile(LifecycleTransformer lifecycleTransformer, String filePath, HttpServiceCallBack<String> callBack) {
        try {
            File upLoadFile = new File(filePath);
            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)upLoadFile);
            MultipartBody.Part fileBody = MultipartBody.Part.createFormData((String)"file", (String)upLoadFile.getName(), (RequestBody)requestFile);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.upLoadFile(fileBody), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishCourseDownLoad(LifecycleTransformer lifecycleTransformer, int id2, String uid, HttpServiceCallBack<Boolean> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", id2);
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.finishCourseDownload(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishMissionPicDownload(LifecycleTransformer lifecycleTransformer, String uid, int id2, HttpServiceCallBack<Boolean> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", id2);
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.finishMissionPicDownload(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkUpdate(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<HttpUpdate> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("versionNum", (Object)AppInfo.getVersionName());
            jsonObject.put("versionResource", (Object)"android");
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.checkUpdate(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void thirdLogin(LifecycleTransformer lifecycleTransformer, HttpThirdRequest request, HttpServiceCallBack<HttpUser> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("checkCode", (Object)"0");
            jsonObject.put("city", (Object)request.city);
            jsonObject.put("country", (Object)request.country);
            jsonObject.put("countryCode", (Object)request.countryCode);
            jsonObject.put("customerName", (Object)request.customerName);
            jsonObject.put("gender", (Object)request.gender);
            jsonObject.put("loginFrom", (Object)request.loginFrom);
            jsonObject.put("iconurl", (Object)request.iconurl);
            jsonObject.put("idname", (Object)request.idname);
            jsonObject.put("loginVerificationType", (Object)"0");
            jsonObject.put("province", (Object)request.province);
            jsonObject.put("platformType", (Object)request.platformType);
            jsonObject.put("unionID", (Object)request.unionID);
            jsonObject.put("uid", (Object)request.unionID);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.thirdLogin(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void bindMobileThird(LifecycleTransformer lifecycleTransformer, String phone, String code, String uid, String platformType, HttpServiceCallBack<HttpUser> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerName", (Object)phone);
            jsonObject.put("chekCode", (Object)code);
            jsonObject.put("uid", (Object)uid);
            jsonObject.put("clientType", (Object)"android");
            jsonObject.put("deviceNo", (Object)DeviceUtil.getDeviceId((Context)ApplicationHolder.getContext()));
            jsonObject.put("deviceToken", (Object)DeviceUtil.getDeviceId((Context)ApplicationHolder.getContext()));
            jsonObject.put("resource", (Object)AppInfo.getPhoneResource());
            jsonObject.put("platformType", (Object)platformType);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.bindMobileThirdLogin(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void bindThird(LifecycleTransformer lifecycleTransformer, HttpThirdRequest request, HttpServiceCallBack<HttpUser> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("checkCode", (Object)"0");
            jsonObject.put("city", (Object)request.city);
            jsonObject.put("country", (Object)request.country);
            jsonObject.put("countryCode", (Object)request.countryCode);
            jsonObject.put("customerName", (Object)request.customerName);
            jsonObject.put("gender", (Object)request.gender);
            jsonObject.put("loginFrom", (Object)request.loginFrom);
            jsonObject.put("iconurl", (Object)request.iconurl);
            jsonObject.put("idname", (Object)request.idname);
            jsonObject.put("loginVerificationType", (Object)"0");
            jsonObject.put("province", (Object)request.province);
            jsonObject.put("platformType", (Object)request.platformType);
            jsonObject.put("unionID", (Object)request.unionID);
            jsonObject.put("uid", (Object)request.unionID);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.bindThird(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void bindMobilePwdThird(LifecycleTransformer lifecycleTransformer, String phone, String pwd, String uid, String platformType, HttpServiceCallBack<HttpUser> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerName", (Object)phone);
            jsonObject.put("password", (Object)Md5Util.encrypt((String)pwd));
            jsonObject.put("uid", (Object)uid);
            jsonObject.put("platformType", (Object)platformType);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.bindMobileThirdPwdLogin(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unBindMobileThird(LifecycleTransformer lifecycleTransformer, String thirdId, HttpServiceCallBack<String> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("thirdId", (Object)thirdId);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.unBindMobileThird(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doComment(LifecycleTransformer lifecycleTransformer, String resId, String resName, String resType, String reviewContent, String reviewType, HttpServiceCallBack<Boolean> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("resId", (Object)resId);
            jsonObject.put("resName", (Object)resName);
            jsonObject.put("resType", (Object)resType);
            jsonObject.put("reviewContent", (Object)reviewContent);
            jsonObject.put("reviewType", (Object)reviewType);
            jsonObject.put("reviewLevel", 5);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.doComment(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getCommentList(LifecycleTransformer lifecycleTransformer, String picBookCode, String pageNo, String pageSize, HttpServiceCallBack<HttpJuge> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("resId", (Object)picBookCode);
            jsonObject.put("pageNo", (Object)pageNo);
            jsonObject.put("pageSize", (Object)pageSize);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.doGetCommentList(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSummrayGoodsByItemCodeAndType(LifecycleTransformer lifecycleTransformer, String goodsType, String itemCode, HttpServiceCallBack<HttpOrderPriceResponse> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("goodsType", (Object)goodsType);
            jsonObject.put("itemCode", (Object)itemCode);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.getSummrayGoodsByItemCodeAndType(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unLockLexiMission(LifecycleTransformer lifecycleTransformer, int evaluationId, HttpServiceCallBack<String> callBack) {
        try {
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.unLockLexiMission(evaluationId), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void uploadCourseDownload(LifecycleTransformer lifecycleTransformer, long missionId, String uid, HttpServiceCallBack callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", missionId);
            jsonObject.put("uid", (Object)uid);
            RequestBody body = this.getPublicParamter(jsonObject);
            EllaHttpService.handleRequest(lifecycleTransformer, this.excuteCommandApi.uploadCourseDownload(body), callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void proxy(LifecycleTransformer lifecycleTransformer, Observable observable, HttpServiceCallBack callBack) {
        try {
            EllaHttpService.handleRequest(lifecycleTransformer, observable, callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T proxy(Class<T> clazzOfT) {
        Object result = map.get(clazzOfT);
        if (result == null) {
            Integer n = sLock;
            synchronized (n) {
                if (result == null) {
                    result = EllaHttpService.buildInterfaceImpl(clazzOfT);
                    map.put(clazzOfT, result);
                }
            }
        }
        return (T)result;
    }

    public static Map<String, Object> createReuestMap() {
        return new ArrayMap();
    }

    public static RequestBody generateRequestBody(Map<String, Object> maps) {
        try {
            JSONObject jsonObject = new JSONObject();
            if (maps != null && maps.size() > 0) {
                for (Map.Entry<String, Object> entry : maps.entrySet()) {
                    jsonObject.put(entry.getKey(), entry.getValue());
                }
            }
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RequestBody generateRequestBody(JSONObject jsonObject) {
        try {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        instance = null;
        map = new ArrayMap();
        sLock = new Integer(3);
    }

    public static interface PathConvert {
        public String converPath(String var1);

        public String converHost(String var1);
    }

    public static interface StringGetter {
        public String get();
    }
}

