/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ellabook.netwrok.EllaInputConfirmView;
import com.ellabook.netwrok.EllaSelectPayWayView;
import com.ellabook.netwrok.R;
import com.ellabook.netwrok.batch.EllaBatchShopView;
import com.ellabook.netwrok.bean.HttpOrderPriceResponse;
import com.ellabook.netwrok.recharge.EllaRechargeEvent;
import com.ellabook.netwrok.recharge.EllaRechargeView;
import com.ellabook.project.base.trade.HttpCoin;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.base.util.bitmap.BlurUtil;

public class MapOrderCommonDialog
extends Dialog {
    private Context context;
    private Bitmap bitmap;
    private HttpCoin coin;
    private HttpOrderPriceResponse response;
    private int type;
    private MapOrderActionClickListner listner;
    private EllaBatchShopView mapBatchView;
    private EllaInputConfirmView mapConfirmView;
    private EllaRechargeView mapRechargeView;
    private EllaSelectPayWayView mapPayView;

    public void showEllaConfig(EllaRechargeEvent event) {
        this.mapRechargeView.showEllaConfig(event);
    }

    public void showBatchView(HttpOrderPriceResponse httpCourseMissionDetailInfo) {
        this.mapPayView.setVisibility(8);
        this.mapBatchView.setVisibility(0);
        this.mapBatchView.setData(httpCourseMissionDetailInfo);
    }

    public void showBatchPrice(HttpOrderPriceResponse response) {
        this.mapBatchView.showBatchPrice(response);
    }

    public void showBatchViewAgain() {
        this.mapBatchView.setVisibility(0);
    }

    public MapOrderCommonDialog(@NonNull Context context) {
        super(context, R.style.full_dialog_common);
        this.init(context);
    }

    public MapOrderCommonDialog(Context context, Bitmap bitmap, int type) {
        super(context, R.style.full_dialog_common);
        this.bitmap = bitmap;
        this.type = type;
        this.coin = null;
        this.init(context);
    }

    public MapOrderCommonDialog(Context context, Bitmap bitmap, HttpOrderPriceResponse response, int type) {
        super(context, R.style.full_dialog_common);
        this.bitmap = bitmap;
        this.type = type;
        this.response = response;
        this.coin = null;
        this.init(context);
    }

    public MapOrderCommonDialog(Context context, HttpCoin coin, Bitmap bitmap, int type) {
        super(context, R.style.full_dialog_common);
        this.bitmap = bitmap;
        this.type = type;
        this.response = null;
        this.coin = coin;
        this.init(context);
    }

    public void setOnMapOrderActionClickListner(MapOrderActionClickListner listner) {
        this.listner = listner;
    }

    public MapOrderCommonDialog(@NonNull Context context, int type) {
        super(context, R.style.full_dialog_common);
        this.bitmap = null;
        this.type = type;
        this.response = null;
        this.coin = null;
        this.init(context);
    }

    public MapOrderCommonDialog(@NonNull Context context, boolean cancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_common_order);
        this.initUI();
        this.getWindow().setFlags(1024, 1024);
        Window window = this.getWindow();
        DisplayMetrics dm = new DisplayMetrics();
        window.getWindowManager().getDefaultDisplay().getMetrics(dm);
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.height = -1;
        window.setAttributes(params);
    }

    private void initUI() {
        if (this.bitmap != null) {
            View llBg = this.findViewById(R.id.llBg);
            this.bitmap = BlurUtil.doBlur((Bitmap)this.bitmap, (int)10, (int)5);
            llBg.setBackground((Drawable)new BitmapDrawable(this.bitmap));
        }
        this.mapBatchView = (EllaBatchShopView)this.findViewById(R.id.mapBatchView);
        this.mapBatchView.setData(this.response);
        this.mapBatchView.setOnEllaCommonViewActionListener(new EllaBatchShopView.EllaCommonViewActionListener(){

            @Override
            public void onUnLockActionListener() {
                MapOrderCommonDialog.this.mapBatchView.setVisibility(8);
                MapOrderCommonDialog.this.mapConfirmView.refreshData();
                MapOrderCommonDialog.this.mapConfirmView.setVisibility(0);
            }

            @Override
            public void onCancelClickListener() {
                MapOrderCommonDialog.this.dismiss();
            }

            @Override
            public void onParentConfirmActionListener() {
            }

            @Override
            public void onRechargeActionListener(HttpCoin coin) {
            }

            @Override
            public void onPayActionListener(int indexType, String goodsCode) {
            }
        });
        this.mapConfirmView = (EllaInputConfirmView)this.findViewById(R.id.mapConfirmView);
        this.mapConfirmView.setOnEllaCommonViewActionListener(new EllaBatchShopView.EllaCommonViewActionListener(){

            @Override
            public void onUnLockActionListener() {
            }

            @Override
            public void onCancelClickListener() {
                if (MapOrderCommonDialog.this.type == MapOrderCommonDialogType.TYPE_UNLOCK.ordinal()) {
                    MapOrderCommonDialog.this.mapConfirmView.setVisibility(8);
                    MapOrderCommonDialog.this.mapBatchView.setVisibility(0);
                } else {
                    MapOrderCommonDialog.this.dismiss();
                }
            }

            @Override
            public void onParentConfirmActionListener() {
                MapOrderCommonDialog.this.mapConfirmView.setVisibility(8);
                if (MapOrderCommonDialog.this.type == MapOrderCommonDialogType.TYPE_PARENT.ordinal()) {
                    MapOrderCommonDialog.this.mapPayView.setVisibility(0);
                    if (MapOrderCommonDialog.this.coin != null) {
                        MapOrderCommonDialog.this.mapPayView.initData(MapOrderCommonDialog.this.coin);
                    }
                } else if (MapOrderCommonDialog.this.type == MapOrderCommonDialogType.TYPE_UNLOCK.ordinal()) {
                    MapOrderCommonDialog.this.mapConfirmView.setVisibility(8);
                    MapOrderCommonDialog.this.mapBatchView.setVisibility(0);
                    HttpOrderPriceResponse payInfo = MapOrderCommonDialog.this.mapBatchView.getPayInfo();
                    if (payInfo != null) {
                        if (MapOrderCommonDialog.this.mapBatchView.isBatchPay()) {
                            MapOrderCommonDialog.this.mapBatchView.setVisibility(8);
                            if (Float.parseFloat(payInfo.balance) > Float.parseFloat(payInfo.goodsActualPrice)) {
                                if (MapOrderCommonDialog.this.listner != null) {
                                    MapOrderCommonDialog.this.listner.onPayViewAction(2, payInfo.goodsCode);
                                }
                            } else {
                                MapOrderCommonDialog.this.mapRechargeView.setVisibility(0);
                            }
                        } else {
                            MapOrderCommonDialog.this.mapBatchView.setVisibility(8);
                            if (Float.parseFloat(payInfo.balance) > Float.parseFloat(payInfo.goodsActualPrice)) {
                                if (MapOrderCommonDialog.this.listner != null) {
                                    MapOrderCommonDialog.this.listner.onPayViewAction(2, payInfo.goodsCode);
                                }
                            } else {
                                MapOrderCommonDialog.this.mapRechargeView.setVisibility(0);
                            }
                        }
                    }
                } else {
                    MapOrderCommonDialog.this.mapRechargeView.setVisibility(0);
                }
            }

            @Override
            public void onRechargeActionListener(HttpCoin coin) {
            }

            @Override
            public void onPayActionListener(int indexType, String goodsCode) {
            }
        });
        this.mapRechargeView = (EllaRechargeView)this.findViewById(R.id.mapRechargeView);
        this.mapRechargeView.setOnEllaCommonViewActionListener(new EllaBatchShopView.EllaCommonViewActionListener(){

            @Override
            public void onUnLockActionListener() {
            }

            @Override
            public void onCancelClickListener() {
                MapOrderCommonDialog.this.dismiss();
            }

            @Override
            public void onParentConfirmActionListener() {
            }

            @Override
            public void onRechargeActionListener(HttpCoin coin) {
                MapOrderCommonDialog.this.mapRechargeView.setVisibility(8);
                MapOrderCommonDialog.this.mapPayView.setVisibility(0);
                MapOrderCommonDialog.this.mapPayView.initData(coin);
            }

            @Override
            public void onPayActionListener(int indexType, String goodsCode) {
            }
        });
        this.mapPayView = (EllaSelectPayWayView)this.findViewById(R.id.mapPayView);
        this.mapPayView.setOnEllaCommonViewActionListener(new EllaBatchShopView.EllaCommonViewActionListener(){

            @Override
            public void onUnLockActionListener() {
            }

            @Override
            public void onCancelClickListener() {
                if (MapOrderCommonDialog.this.type == MapOrderCommonDialogType.TYPE_PARENT.ordinal()) {
                    ToastUtils.showCenterToast((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8d2d\u4e70");
                    MapOrderCommonDialog.this.mapPayView.setVisibility(8);
                    MapOrderCommonDialog.this.dismiss();
                } else {
                    MapOrderCommonDialog.this.mapRechargeView.setVisibility(0);
                    MapOrderCommonDialog.this.mapPayView.setVisibility(8);
                }
            }

            @Override
            public void onParentConfirmActionListener() {
            }

            @Override
            public void onRechargeActionListener(HttpCoin coin) {
            }

            @Override
            public void onPayActionListener(int indexType, String goodsCode) {
                if (MapOrderCommonDialog.this.listner != null) {
                    MapOrderCommonDialog.this.listner.onPayViewAction(indexType, goodsCode);
                }
            }
        });
        if (this.type == MapOrderCommonDialogType.TYPE_UNLOCK.ordinal()) {
            this.mapBatchView.setVisibility(0);
        } else if (this.type == MapOrderCommonDialogType.TYPE_PARENT.ordinal()) {
            this.mapConfirmView.setVisibility(0);
        } else if (this.type == MapOrderCommonDialogType.TYPE_RECHARGE.ordinal()) {
            this.mapRechargeView.setVisibility(0);
        } else if (this.type == MapOrderCommonDialogType.TYPE_RECHARGE_TIP.ordinal()) {
            if (this.coin != null) {
                this.mapPayView.initData(this.coin);
            }
            this.mapPayView.setVisibility(0);
        }
    }

    public static enum MapOrderCommonDialogType {
        TYPE_UNLOCK,
        TYPE_PARENT,
        TYPE_RECHARGE,
        TYPE_RECHARGE_TIP;

    }

    public static interface MapOrderActionClickListner {
        public void onPayViewAction(int var1, String var2);
    }
}

