/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.netwrok;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.netwrok.EllaGridAdapter;
import com.ellabook.netwrok.R;
import com.ellabook.netwrok.batch.EllaBatchShopView;
import com.ellabook.project.base.anim.EllaAniUtils;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.base.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;

public class EllaInputConfirmView
extends LinearLayout {
    private String[] mNumberArray;
    private int mInputCount;
    private SparseArray<String> mAnswerArray = new SparseArray();
    private List<TextView> mInputList;
    private RecyclerView ui_gridView;
    private Context context;
    private final int MAX_INPUT_NUM = 3;
    private boolean isLand = false;
    private EllaBatchShopView.EllaCommonViewActionListener listener;
    private int[] arrays = new int[]{R.drawable.input_one, R.drawable.input_two, R.drawable.input_three, R.drawable.input_four, R.drawable.input_five, R.drawable.input_six, R.drawable.input_seven, R.drawable.input_eight, R.drawable.input_nine};

    public void setOnEllaCommonViewActionListener(EllaBatchShopView.EllaCommonViewActionListener listener) {
        this.listener = listener;
    }

    public EllaInputConfirmView(Context context) {
        super(context);
        this.init(context);
    }

    public EllaInputConfirmView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EllaInputConfirmView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.isLand = context.getResources().getConfiguration().orientation == 2;
        if (this.isLand) {
            this.arrays = new int[]{R.drawable.input_zero, R.drawable.input_one, R.drawable.input_two, R.drawable.input_three, R.drawable.input_four, R.drawable.input_five, R.drawable.input_six, R.drawable.input_seven, R.drawable.input_eight, R.drawable.input_nine};
        }
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ui_input_view, null);
        this.addView(view);
        this.mInputList = new ArrayList<TextView>();
        this.initUI(view);
    }

    private void initUI(View view) {
        view.findViewById(R.id.ui_input_del).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (EllaInputConfirmView.this.listener != null) {
                    EllaInputConfirmView.this.listener.onCancelClickListener();
                }
            }
        });
        TextView ui_inputThree = (TextView)view.findViewById(R.id.ui_inputThree);
        TextView ui_inputTwo = (TextView)view.findViewById(R.id.ui_inputTwo);
        TextView ui_inputOne = (TextView)view.findViewById(R.id.ui_inputOne);
        this.mNumberArray = this.context.getResources().getStringArray(R.array.question_nums);
        this.mInputList.add(ui_inputOne);
        this.mInputList.add(ui_inputTwo);
        this.mInputList.add(ui_inputThree);
        this.ui_gridView = (RecyclerView)view.findViewById(R.id.ui_gridView);
        GridLayoutManager manager = new GridLayoutManager(this.context, 3);
        if (this.isLand) {
            manager = new GridLayoutManager(this.context, 5);
        }
        this.ui_gridView.setLayoutManager((RecyclerView.LayoutManager)manager);
        EllaGridAdapter adapter = new EllaGridAdapter(this, this.arrays);
        this.ui_gridView.setAdapter((RecyclerView.Adapter)adapter);
        this.generateQuestion();
    }

    public void updateInput(int inputNum) {
        this.mInputCount = this.mInputCount > this.mInputList.size() - 1 ? this.mInputList.size() - 1 : this.mInputCount;
        TextView input = this.mInputList.get(this.mInputCount);
        if (input == null) {
            return;
        }
        input.setTextColor(Color.parseColor((String)"#5442d6"));
        if (this.isLand) {
            input.setText((CharSequence)(inputNum + ""));
        } else {
            input.setText((CharSequence)(inputNum + 1 + ""));
        }
        if (!this.verifyProcess()) {
            this.shakeAnim();
            this.generateQuestion();
            this.mInputCount = 0;
        } else {
            ++this.mInputCount;
        }
    }

    private void shakeAnim() {
        for (TextView tv : this.mInputList) {
            tv.setTextColor(this.getResources().getColor(R.color.color_a1));
            EllaAniUtils.shakeAnim((Context)this.context, (View)tv);
        }
    }

    private boolean verifyProcess() {
        TextView input = this.mInputList.get(this.mInputCount);
        if (input == null) {
            return false;
        }
        if (!TextUtils.equals((CharSequence)input.getText().toString(), (CharSequence)((CharSequence)this.mAnswerArray.get(this.mInputCount)))) {
            return false;
        }
        if (this.listener != null && this.mInputCount == 2) {
            this.listener.onParentConfirmActionListener();
        }
        return true;
    }

    private void generateQuestion() {
        for (int i = 0; i < 3; ++i) {
            TextView tv = this.mInputList.get(i);
            int randomResult = RandomUtil.generateRandom((int)1, (int)9);
            tv.setText((CharSequence)this.mNumberArray[randomResult]);
            tv.setTextColor(Color.parseColor((String)"#a1a1a1"));
            tv.setTextSize((float)Converter.dip2px((Context)this.context, (float)15.0f));
            this.mAnswerArray.put(i, (Object)(randomResult + 1 + ""));
        }
    }

    public void refreshData() {
        this.generateQuestion();
        this.mInputCount = 0;
    }
}

