package com.ellabook.project.ellareader.ui.read;

import android.media.MediaPlayer;
import android.text.TextUtils;

import java.io.IOException;

public class MediaPlayerUtil {

    private static MediaPlayer mPlayer = null;

    // 播放一个音频文件
    public static void play(String path) {
        if (TextUtils.isEmpty(path)) {
            //path不允许为空
            return;
        }
        if (null == mPlayer) {
            mPlayer = new MediaPlayer();
        }
        if (mPlayer.isPlaying()) {
            mPlayer.pause();
            mPlayer.stop();
            privatePlay(path);
        } else {
            privatePlay(path);
        }
    }

    public static void playSeek(String path, final int start, final int end) {
        if (null == mPlayer) {
            mPlayer = new MediaPlayer();
        }
        mPlayer.pause();
        mPlayer.stop();
        privatePlaySeek(path, start, end);
    }

    public static void stop() {
        if (mPlayer != null) {
            mPlayer.pause();
            mPlayer.stop();
        }
    }

    public static void destory() {
        mPlayer.reset();
        mPlayer.release();
        mPlayer = null;
    }

    /**
     * start end 均为毫秒级
     */
    private static void privatePlaySeek(String path, final int start, final int end) {
        try {
            mPlayer.reset();
            mPlayer.setDataSource(path);
            // 准备播放
            mPlayer.prepareAsync();
            // 准备完成的监听
            mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
                @Override
                public void onPrepared(MediaPlayer mp) {
                    // 开始播放
                    mPlayer.seekTo(start);
                    mPlayer.start();

                    new Thread() {
                        @Override
                        public void run() {
                            long i = end - start;
                            try {
                                Thread.sleep(i);
                                mPlayer.pause();
                                mPlayer.stop();
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();

                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void privatePlay(String path) {
        // 设置到播放的资源位置 path 可以是网络 路径 也可以是本地路径
        try {
            mPlayer.reset();
            mPlayer.setDataSource(path);
            // 准备播放
            mPlayer.prepareAsync();
            // 准备完成的监听
            mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
                @Override
                public void onPrepared(MediaPlayer mp) {
                    // 开始播放
                    mPlayer.start();
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}