package com.ellabook.project.ellareader.ui.read;

import android.app.Fragment;
import android.net.Uri;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.R;

/**
 * 作者：wangtao on 2019/4/10 16:49
 * 邮箱：863010067@qq.com
 * 课程关卡引导页
 */
public class CourseSecondGuideFragment extends Fragment implements View.OnClickListener {

    private RelativeLayout rlGuideOne;
    private TextView tvNextOne;
    private View vDiamondHighLight = null;
    private ShadownXorView sdvDiamondHighLight;

    public static final String GUIDE_KEY = "CourseSecondGuideFragment.GUIDE_KEY";

    public static void checkShowGuide(BookReaderActivity context, int diamondWidth) {
        if (context.getReaderControler().getCurrentPage() != 2)
            return;
        if (!UserInfoProvider.isGuideAvailable(GUIDE_KEY, true))
            return;

        UserInfoProvider.setGuide(GUIDE_KEY, false);
        context.getReaderControler().pause();//暂停播放
        CourseSecondGuideFragment courseGuideFragment = new CourseSecondGuideFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("diamond_width", diamondWidth);
        courseGuideFragment.setArguments(bundle);
        context.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, courseGuideFragment).commitAllowingStateLoss();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_fragment_second_guide, container, false);
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        int diamondWidth = getArguments().getInt("diamond_width");
        vDiamondHighLight = view.findViewById(R.id.vDiamondHighLight);
        vDiamondHighLight.getLayoutParams().width = diamondWidth;

        sdvDiamondHighLight = view.findViewById(R.id.sdvDiamondHighLight);


        rlGuideOne = view.findViewById(R.id.rlGuideOne);
        tvNextOne = view.findViewById(R.id.tvNextOne);

        tvNextOne.setOnClickListener(this);
        Looper.myQueue().addIdleHandler(new ShowGuideIdleOnce());

        playVoice(R.raw.course_power_remines);
        return view;
    }

    class ShowGuideIdleOnce implements MessageQueue.IdleHandler {

        @Override
        public boolean queueIdle() {
            if (isDetached()) {
                return false;
            }
            return resetGuide();
        }

    }

    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable(voiceName, false)) {
            return true;
        } else {
            UserInfoProvider.setGuide(voiceName, true);
            return false;
        }
    }

    private boolean resetGuide() {
        if (vDiamondHighLight == null) {
            return false;
        }
        if (vDiamondHighLight.getX() == 0) {
            return true;
        }
        sdvDiamondHighLight.setRectangle(vDiamondHighLight.getX(), vDiamondHighLight.getY(), vDiamondHighLight.getWidth(), vDiamondHighLight.getHeight(),
                getResources().getDimension(R.dimen.book_reader_diamond_size));
        return false;
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.tvNextOne) {
            dismiss();
        }
    }

    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play(Uri.parse("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId));
        }
    }

    private void dismiss() {
        AudioPlayer.stopPlay();
        getActivity().getFragmentManager().beginTransaction().remove(this).commitAllowingStateLoss();
        ((BookReaderActivity) getActivity()).getReaderControler().resume();//继续播放
    }

}

