package com.ellabook.project.ellareader.ctrl;

import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.ellabook.project.ellareader.bean.FeedbackBean;

import java.util.List;

/**
 * Created by tiandehua on 2020/6/10
 *
 * @description:
 */
public class FeedbackRequestCache {

    private FeedbackRequestCache() {

    }
    //单例实现
    public static FeedbackRequestCache getInstance() {
        return Singleton.instance;
    }

    private static class Singleton {
        private static FeedbackRequestCache instance = new FeedbackRequestCache();
    }

    private String mBookCode;
    private List<FeedbackBean> mReasonList;

    public List<FeedbackBean> getReasonListCache(@NonNull String bookCode) {
        if(TextUtils.equals(bookCode, mBookCode) && mReasonList != null && mReasonList.size() != 0) {
            return mReasonList;
        }
        return null;
    }

    public void updateReasonList(@NonNull String bookCode, @NonNull List<FeedbackBean> list) {
        if(!TextUtils.equals(bookCode, mBookCode) && list.size() > 0) {
            mBookCode = bookCode;
            mReasonList = list;
        }
    }
}
