package com.ellabook.project.ellareader.book.bean;

import android.os.Parcel;
import android.os.Parcelable;

public class BookExtraInfo implements Parcelable {
    public String level;
    public String type;
    public String name;

    public String goodsCode;
    public String picBookCode;

    public long missionId;
    public long mapId;

    public BookExtraInfo() {
    }

    public BookExtraInfo(String name, String level, String goodsCode, String picBookCode) {
        this.level = level;
        this.name = name;
        this.type = BookContainer.BOOK_TYPE_BOOK;
        this.goodsCode = goodsCode;
        this.picBookCode = picBookCode;
    }

    public BookExtraInfo(String name, String level, long mapId, long missionId) {
        this.level = level;
        this.name = name;
        this.type = BookContainer.BOOK_TYPE_COURSE;
        this.mapId = mapId;
        this.missionId = missionId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.level);
        dest.writeString(this.type);
        dest.writeString(this.name);
        dest.writeString(this.goodsCode);
        dest.writeString(this.picBookCode);
        dest.writeLong(this.missionId);
        dest.writeLong(this.mapId);
    }

    protected BookExtraInfo(Parcel in) {
        this.level = in.readString();
        this.type = in.readString();
        this.name = in.readString();
        this.goodsCode = in.readString();
        this.picBookCode = in.readString();
        this.missionId = in.readLong();
        this.mapId = in.readLong();
    }

    public static final Parcelable.Creator<BookExtraInfo> CREATOR = new Parcelable.Creator<BookExtraInfo>() {
        @Override
        public BookExtraInfo createFromParcel(Parcel source) {
            return new BookExtraInfo(source);
        }

        @Override
        public BookExtraInfo[] newArray(int size) {
            return new BookExtraInfo[size];
        }
    };
}
