package com.ellabook.project.ellareader;

import android.view.View;

public class OnDebounceListener implements View.OnClickListener {
    View.OnClickListener onClickListener;

    public static final long minimumInterval = 1000l;
    private long recordTimeStamp = 0L;

    public OnDebounceListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    @Override
    public void onClick(View v) {
        long currentTimestamp = System.currentTimeMillis();
        long lastTimeStamp = recordTimeStamp;
        if (currentTimestamp - lastTimeStamp > minimumInterval) {
            if (onClickListener != null) {
                onClickListener.onClick(v);
            }
            recordTimeStamp = currentTimestamp;
        }


    }
}
