package cn.ellabook;

import android.content.Context;
import android.media.AudioManager;
import android.util.Log;

/**
 * Created by luodi on 2017/11/14.
 */

public class ReaderAudioHelper {

    private AudioManager mAm;
    private int mResult;
    private static ReaderAudioHelper sHelper;


    private ReaderAudioHelper() {
    }

    public static ReaderAudioHelper getInstance() {
        if (sHelper == null) {
            synchronized (ReaderAudioHelper.class) {
                if (sHelper == null) {
                    sHelper = new ReaderAudioHelper();
                }
            }
        }
        return sHelper;
    }
    /**
     * 请求audio focus
     * @param context
     */
    public void requestAudio(Context context) {
        if (context == null) return;
        mAm = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        mResult = mAm.requestAudioFocus(mAfListener, AudioManager.STREAM_MUSIC, AudioManager.AUDIOFOCUS_GAIN);
        Log.d("edwin", "audio focus result is " + mResult);
    }

    /**
     * 释放audio focus
     */
    public void releaseAudio() {
        if (mAm == null) return;
        mAm.abandonAudioFocus(mAfListener);
    }

    //-----------------------------------------回调区-----------------------------------------------
    // audio focus监听回调
    private AudioManager.OnAudioFocusChangeListener mAfListener = new AudioManager.OnAudioFocusChangeListener() {
        @Override
        public void onAudioFocusChange(int focusChange) {

        }
    };
}
