package com.ellabook.project.ellareader.book.download;

import android.graphics.Color;

import androidx.fragment.app.FragmentActivity;

import com.ellabook.project.base.util.NetworkUtil;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.base.tool.Callback;
import com.ellabook.project.base.ui.theme.dialog.AlertDialog;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.R;

/**
 * Created by dongdaqing on 2018/4/16.
 * 下载帮助类
 */
public class DownloadHelper {
    private FragmentActivity mFragmentActivity;
    //回调函数的参数：true表示已连接wifi，false表示未连接wifi
    private Callback<Boolean> mCallback;

    public DownloadHelper(FragmentActivity activity, Callback<Boolean> callback) {
        mFragmentActivity = activity;
        mCallback = callback;
    }

    public void start() {
        if (!NetworkUtil.networkAvailable()) {
            ToastUtils.showToast(R.string.blank_page_broken_network);
            return;
        }
        //获取设置信息，是否仅允许wifi下载
        boolean isOnlyWifi = UserInfoProvider.isOnlyDownloadInWifi();
        boolean isWifiConnected = NetworkUtil.isWifi();
        if (isOnlyWifi) {//如果仅允许wifi下载，那么在只有非wifi情况下下载需要弹出对话框提示用户
            if (!isWifiConnected) {
                new AlertDialog.Builder()
                        .title("下载确认")
                        .content("当前处于非WiFi状态，\n确认使用流量下载吗？")
                        .cancel("取消")
                        .confirm("确定")
                        .confirmColor(Color.parseColor("#40d8b0"))
                        .confirmListener(v -> mCallback.callback(false)).show(mFragmentActivity.getSupportFragmentManager());
            } else {
                mCallback.callback(true);
            }
        } else {
            mCallback.callback(false);
        }
    }

    /**
     * 是否需要校验只在wifi下下载
     * 因为可能之前已经弹出过自定义数据流量下载的弹窗
     */
    public void startByNoCheck() {
        if (!NetworkUtil.networkAvailable()) {
            ToastUtils.showToast(R.string.blank_page_broken_network);
            return;
        }
        mCallback.callback(false);
    }
}
