package com.ellabook.project.ellareader.book.cache;

import android.content.Context;
import android.text.TextUtils;

import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.book.bean.BookExtraInfo;
import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageAll;
import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageItem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import ellax.bookmanager.BookLocalInfo;
import ellax.bookmanager.BookManager;

/**
 * 使用CountDownLatch和AtomicLong实现多线程下的并发控制
 * 来计算文件夹大小
 * <p>
 * <p>
 * Created by Tony on 2018/7/28.
 */

public class ConcurrentTotalFileSizeWLatch {

    private List<ProfileStorageItem> list = new ArrayList<>();
    public ProfileStorageAll getTotalSizeOfFile (Context context)
            throws InterruptedException, ExecutionException, TimeoutException {

        List<BookLocalInfo> installedBookInfos = BookManager.getInstalledBooks();
        ProfileStorageAll profileStorageAll = new ProfileStorageAll();
        profileStorageAll.setList(new ArrayList<>());
        if (installedBookInfos != null) {
            for (BookLocalInfo bookLocalInfo : installedBookInfos) {
                ProfileStorageItem item = new ProfileStorageItem();
                BookExtraInfo extraInfo = (BookExtraInfo) BookManager.readExtra(bookLocalInfo.bookCode, BookExtraInfo.class);
                if (extraInfo != null ) {
                    // TODO: 2019/7/14 0014
                    File file = BookManager.getResourceInstallDir(bookLocalInfo.bookCode, false,false);
                    if (file.exists()) {
                        item.setFilePath(file.getPath());
                    }
                    file = BookManager.getResourceInstallDir(bookLocalInfo.bookCode, true,false);
                    if (file.exists()) {
                        item.setFilePath(file.getPath());
                    }
                    item.setName(extraInfo.name);
                    long total = new ConcurrentTotalFileSize()
                            .getTotalSizeOfFilesInDir(new File(item.getFilePath()));
                    item.setItemSize(total);
                    item.setShowItemSize(EllaDowloadStorageManager.getInstance(context).getFormatStorageSize(total));
                    item.setInfo(extraInfo);
                    if (BookContainer.BOOK_TYPE_COURSE.equals(extraInfo.type)) {
                        item.setType(EllaDowloadStorageManager.RESOURCETYPE.LESSON.ordinal());
                        profileStorageAll.getList().add(item);
                    } else if (BookContainer.BOOK_TYPE_BOOK.equals(extraInfo.type)) {
                        item.setType(EllaDowloadStorageManager.RESOURCETYPE.COURSE.ordinal());
                        profileStorageAll.getList().add(item);
                    }
                }
            }

        }
        return profileStorageAll;

    }

        public ProfileStorageAll getTotalSizeOfFile ( final int level, Context context)
            throws InterruptedException, ExecutionException, TimeoutException {

            List<BookLocalInfo> installedBookInfos = BookManager.getInstalledBooks();
            ProfileStorageAll profileStorageAll = new ProfileStorageAll();
            profileStorageAll.setList(new ArrayList<>());
            if (installedBookInfos != null) {
                for (BookLocalInfo bookLocalInfo : installedBookInfos) {
                    ProfileStorageItem item = new ProfileStorageItem();
                    BookExtraInfo extraInfo = (BookExtraInfo) BookManager.readExtra(bookLocalInfo.bookCode, BookExtraInfo.class);
                    if (extraInfo != null && TextUtils.equals(extraInfo.level, String.valueOf(level))) {
                        // TODO: 2019/7/14 0014
                        File file = BookManager.getResourceInstallDir(bookLocalInfo.bookCode, false,false);
                        if (file.exists()) {
                            item.setFilePath(file.getPath());
                        }
                        file = BookManager.getResourceInstallDir(bookLocalInfo.bookCode, true,false);
                        if (file.exists()) {
                            item.setFilePath(file.getPath());
                        }
                        item.setName(extraInfo.name);
                        long total = new ConcurrentTotalFileSize()
                                .getTotalSizeOfFilesInDir(new File(item.getFilePath()));
                        item.setItemSize(total);
                        item.setShowItemSize(EllaDowloadStorageManager.getInstance(context).getFormatStorageSize(total));
                        item.setInfo(extraInfo);
                        if (BookContainer.BOOK_TYPE_COURSE.equals(extraInfo.type)) {
                            item.setType(EllaDowloadStorageManager.RESOURCETYPE.LESSON.ordinal());
                            profileStorageAll.getList().add(item);
                        } else if (BookContainer.BOOK_TYPE_BOOK.equals(extraInfo.type)) {
                            item.setType(EllaDowloadStorageManager.RESOURCETYPE.COURSE.ordinal());
                            profileStorageAll.getList().add(item);
                        }
                    }
                }

            }
//        ProfileStorageAll profileStorageAll = new ProfileStorageAll();
//        File file = new File(fileName);
//        long allItemSize = 0l;
//        if (file.exists()) {
//            File[] files = file.listFiles();
//            for (File fileDir : files) {
//                ProfileStorageItem item = null;
//                String fileDirName = fileDir.getName();
//                if (fileDirName.contains(EllaDowloadStorageManager.LESSON_DIR)) {
//                    item = new ProfileStorageItem();
//                    item.setFilePath(fileDir.getAbsolutePath());
//                    item.setName(fileDirName.split("_")[0]);
//                    item.setType(EllaDowloadStorageManager.RESOURCETYPE.LESSON.ordinal());
//                } else if (fileDirName.contains(EllaDowloadStorageManager.COURSE_DIR)) {
//                    item = new ProfileStorageItem();
//                    item.setFilePath(fileDir.getAbsolutePath());
//                    item.setName(fileDirName.split("_")[0]);
//                    item.setType(EllaDowloadStorageManager.RESOURCETYPE.COURSE.ordinal());
//                }
//                if (item != null)
//                    list.add(item);
//            }
//
//            for (ProfileStorageItem item : list) {
//                String fileNameItem = item.getFilePath();
//                long total = new ConcurrentTotalFileSize()
//                        .getTotalSizeOfFilesInDir(new File(fileNameItem));
//                item.setItemSize(total);
//                item.setShowItemSize(EllaDowloadStorageManager.getInstance(context).getFormatStorageSize(total));
//                allItemSize += total;
//            }
//        }
//        profileStorageAll.setAllSize(allItemSize);
//        profileStorageAll.setList(list);
            return profileStorageAll;

        }
    }
