package com.ellabook.project.ellareader.bean;

import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;

import java.util.Objects;

@Entity(tableName = "read_record_lra", primaryKeys = {"uid", "missionId", "readStartEnds"})
public class ReadRecordlra {
    @NonNull
    @ColumnInfo(name = "uid")
   public String uid;
    @NonNull @ColumnInfo(name = "missionId")
    public long missionId;
    @NonNull @ColumnInfo(name = "readStartEnds")
    public String readStartEnds;

    public static ReadRecordlra build(long missionId, String readStartEnds, String uid) {
        ReadRecordlra readRecord = new ReadRecordlra();
        readRecord.missionId = missionId;
        readRecord.readStartEnds = readStartEnds;
        readRecord.uid = uid;
        return readRecord;

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ReadRecordlra that = (ReadRecordlra) o;
        return Objects.equals(uid, that.uid) &&
                Objects.equals(missionId, that.missionId) &&
                Objects.equals(readStartEnds, that.readStartEnds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, missionId, readStartEnds);
    }
}
