package cn.ellabook;

/**
 * Created by java on 2018/7/18.
 * 控制阅读器接口
 */
public interface ReaderControler {

    String RESOLUTION_POLICY_HEIGHT = "FIXED_HEIGHT";
    String RESOLUTION_POLICY_WIDTH = "FIXED_WIDTH";
    byte PLAY_MODE_READ = 0;
    byte PLAY_MODE_AUTO_PLAY = 1;
    byte PLAY_MODE_LISTEN = 2;
    byte PLAY_MODE_EDUCATION = 3;

    /**
     * 设置屏幕适配方案
     *
     * @param resolutionPolicy
     */
    void setResolutionPolicy(String resolutionPolicy);

    /**
     * 设置阅读模式
     *
     * @param playMode
     */
    void setBookPlayMode(byte playMode);

    /**
     * 获取阅读模式
     *
     * @return
     */
    byte getBookPlayMode();

    void endBookViewer();

    void startNewBook(String path, int currentPage);

    void pause();

    void resume();

    void gotoPage(int page);

    void restartCurrentPage();

    void pageDown();

    void pageUp();

    int getCurrentPage();

    int getBookPages();

    boolean isLastPage();

    boolean isMenuEnable();
}
