/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.style.ImageSpan;
import android.text.style.LeadingMarginSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import cn.ellabook.EllaBookViewerHelper;
import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.imgspan.ClickableMovementMethod;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.AudioWordLayout;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ReaderModule;
import com.ellabook.project.ellareader.SingSoundAudioRecorder;
import com.ellabook.project.ellareader.bean.FeedbackBean;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.bean.WordRecord;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.ctrl.FeedbackRequestCache;
import com.ellabook.project.ellareader.ctrl.Utils;
import com.ellabook.project.ellareader.ui.read.FeedbackPopup;
import com.ellabook.project.ellareader.ui.read.MediaPlayerUtil;
import com.ellabook.project.ellareader.ui.read.SplitedSegmentsLayout;
import com.ellabook.project.ellareader.ui.read.SplitedSentence;
import com.ellabook.project.ellareader.ui.read.SplitedSentencesLayout;
import com.trello.rxlifecycle2.RxLifecycle;
import com.trello.rxlifecycle2.android.FragmentEvent;
import ellax.base.Callback;
import io.reactivex.subjects.BehaviorSubject;
import java.util.ArrayList;
import java.util.List;

public class SplitedWordDialogFragment
extends DialogFragment
implements SplitedSentencesLayout.OnWordSelectListener {
    private final BehaviorSubject<FragmentEvent> lifecycleSubject = BehaviorSubject.create();
    LinearLayout llRightDes;
    RelativeLayout rlWordLayout;
    ImageView ivWordIcon;
    TextView tvWordTextTip;
    RelativeLayout rlSentenceLayout;
    ImageView ivSentenceIcon;
    TextView tvSentenceTextTip;
    RelativeLayout rlEmptyLayout;
    NestedScrollView nsSentence;
    TextView tvSentenceContent;
    TextView tvSentenceContentTranslate;
    NestedScrollView nsWord;
    TextView tvWord;
    TextView tvAmericaAudio;
    TextView tvEnglandAudio;
    ImageView vLoading;
    ImageView vLoadSentence;
    View maskView;
    RelativeLayout rlReportError;
    View viewAnchor;
    AudioWordLayout vWordAudioLayout;
    TextView tvWordDes;
    View tvAddWord;
    SplitedSegmentsLayout splitedSegmentsLayout;
    FrameLayout vGray;
    private int segmentID;
    private int sentenceID;
    private ArrayList<ArrayList<SplitedSentence>> list;
    private String bookCode;
    private String missionCode;
    private String missionId;
    private String sentenceSpeech;
    private String audioPath;
    private int pageNum;
    private String word;
    private HttpWordDetails httpWordDetails;
    private String mRecorderFilePath = null;
    private String mCurrentSentence;
    private String mCurrentTranslate;
    SingSoundAudioRecorder audioRecorder;

    public static void show(Activity activity, ArrayList<ArrayList<SplitedSentence>> list, int segmentID, int sentenceID, String audioPath, String bookCode, String missionCode, String missionId, int pageNum) {
        if (list == null || list.isEmpty()) {
            Log.e((String)"split_words", (String)"list empty");
            return;
        }
        if (segmentID >= list.size()) {
            Log.e((String)"split_words", (String)("seg overflow segId" + segmentID + "  list.size " + list.size()));
            segmentID = 0;
        }
        if (list.get(segmentID) == null) {
            Log.e((String)"split_words", (String)("seg overflow sentenceID" + segmentID + " is null"));
            segmentID = -1;
        } else if (sentenceID >= list.get(segmentID).size()) {
            sentenceID = 0;
            Log.e((String)"split_words", (String)("seg overflow sentenceID" + segmentID + "  list.get(segmentID).size " + list.get(segmentID).size()));
        }
        SplitedWordDialogFragment wordModelDialogFragment = new SplitedWordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("segmentID", segmentID);
        bundle.putInt("sentenceID", sentenceID);
        bundle.putSerializable("splitedSentenceList", list);
        bundle.putString("bookCode", bookCode);
        bundle.putString("audioPath", audioPath);
        bundle.putString("missionCode", missionCode);
        bundle.putString("missionId", missionId);
        bundle.putInt("pageNum", pageNum);
        wordModelDialogFragment.setArguments(bundle);
        wordModelDialogFragment.setStyle(R.style.full_notch_dialog, 0);
        wordModelDialogFragment.show(activity.getFragmentManager(), "SplitedWordDialogFragment");
    }

    protected void injectView(View view) {
        AnimationDrawable animationDrawable;
        this.vGray = (FrameLayout)view.findViewById(R.id.vGray);
        this.llRightDes = (LinearLayout)view.findViewById(R.id.llRightDes);
        this.rlWordLayout = (RelativeLayout)view.findViewById(R.id.rlWordLayout);
        this.ivWordIcon = (ImageView)view.findViewById(R.id.ivWordIcon);
        this.tvWordTextTip = (TextView)view.findViewById(R.id.tvWordTextTip);
        this.rlSentenceLayout = (RelativeLayout)view.findViewById(R.id.rlSentenceLayout);
        this.ivSentenceIcon = (ImageView)view.findViewById(R.id.ivSentenceIcon);
        this.tvSentenceTextTip = (TextView)view.findViewById(R.id.tvSentenceTextTip);
        this.rlEmptyLayout = (RelativeLayout)view.findViewById(R.id.rlEmptyLayout);
        this.nsSentence = (NestedScrollView)view.findViewById(R.id.nsSentence);
        this.tvSentenceContent = (TextView)view.findViewById(R.id.tvSentenceContent);
        this.tvSentenceContentTranslate = (TextView)view.findViewById(R.id.tvSentenceContentTranslate);
        this.nsWord = (NestedScrollView)view.findViewById(R.id.nsWord);
        this.tvWord = (TextView)view.findViewById(R.id.tvWord);
        this.tvAmericaAudio = (TextView)view.findViewById(R.id.tvAmericaAudio);
        this.tvEnglandAudio = (TextView)view.findViewById(R.id.tvEnglandAudio);
        this.vLoading = (ImageView)view.findViewById(R.id.vLoad);
        this.vLoadSentence = (ImageView)view.findViewById(R.id.vLoadSentence);
        this.vWordAudioLayout = (AudioWordLayout)view.findViewById(R.id.vWordAudioLayout);
        if (this.vLoading.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoading.getDrawable();
            animationDrawable.start();
        }
        if (this.vLoadSentence.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoadSentence.getDrawable();
            animationDrawable.start();
        }
        this.tvWordDes = (TextView)view.findViewById(R.id.tvWordDes);
        this.tvAddWord = view.findViewById(R.id.tvAddWord);
        this.splitedSegmentsLayout = (SplitedSegmentsLayout)view.findViewById(R.id.splitedSegmentsLayout);
        this.maskView = view.findViewById(R.id.fl_content_split);
        this.rlReportError = (RelativeLayout)view.findViewById(R.id.rlReportError);
        this.viewAnchor = view.findViewById(R.id.tvReportError);
        view.findViewById(R.id.ivBack).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onBackClick();
            }
        });
        view.findViewById(R.id.rlWordLayout).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onWordSelectClick();
            }
        });
        view.findViewById(R.id.rlSentenceLayout).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onSentenceSelectClick();
            }
        });
        view.findViewById(R.id.tvAddWord).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onAddWordClick();
            }
        });
        view.findViewById(R.id.tvAmericaAudio).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onAmericaAudioClick();
            }
        });
        view.findViewById(R.id.tvEnglandAudio).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onEnglandAudioClick();
            }
        });
        this.vWordAudioLayout.setListener(new AudioWordLayout.RecordListener(){

            @Override
            public void onRecordClick(boolean isRecording) {
                if (!isRecording) {
                    SplitedWordDialogFragment.this.startRecord();
                }
            }

            @Override
            public void onPlayClick() {
                SplitedWordDialogFragment.this.playLastAudio();
            }
        });
        this.tvSentenceContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)SplitedWordDialogFragment.this.sentenceSpeech)) {
                    try {
                        MediaPlayerUtil.play(SplitedWordDialogFragment.this.sentenceSpeech);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.rlReportError.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.getFeedbackList();
            }
        });
        this.tvAddWord.setVisibility(ReaderModule.isAddWordEnable() ? 0 : 4);
    }

    public void onResume() {
        super.onResume();
        this.rlReportError.setVisibility(Utils.isNetworkConnected(this.rlReportError.getContext()) ? 0 : 4);
    }

    private void getFeedbackList() {
        final FeedbackRequestCache cache = FeedbackRequestCache.getInstance();
        List<FeedbackBean> list = cache.getReasonListCache(this.bookCode);
        if (list != null) {
            this.showFeedbackPopup(list);
        } else {
            BizReader.getInstance().getFeedBackList(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)FragmentEvent.PAUSE), new HttpServiceCallBack<List<FeedbackBean>>(){

                public void onHttpServiceFinished(List<FeedbackBean> result) {
                    SplitedWordDialogFragment.this.showFeedbackPopup(result);
                    cache.updateReasonList(SplitedWordDialogFragment.this.bookCode, result);
                }

                public void onHttpServiceError(int code, String msg) {
                    ToastUtils.showToast((String)msg);
                }
            });
        }
    }

    private void showFeedbackPopup(final List<FeedbackBean> list) {
        FeedbackPopup popup = new FeedbackPopup();
        popup.setConfirmCallback(new Callback<Integer>(){

            public void callback(Integer integer2) {
                int value = ((FeedbackBean)list.get((int)integer2.intValue())).value;
                String content = ((FeedbackBean)list.get((int)integer2.intValue())).info;
                BizReader.getInstance().commitFeedback(null, value, SplitedWordDialogFragment.this.mCurrentSentence, SplitedWordDialogFragment.this.mCurrentTranslate, SplitedWordDialogFragment.this.bookCode, String.valueOf(SplitedWordDialogFragment.this.pageNum), new HttpServiceCallBack<Object>(){

                    public void onHttpServiceFinished(Object result) {
                        ToastUtils.showToast((int)R.string.feedback_commit_success);
                    }

                    public void onHttpServiceError(int code, String msg) {
                        ToastUtils.showToast((String)msg);
                    }
                });
            }
        });
        popup.show(this.rlReportError.getContext(), (View)this.rlReportError, (View)this.llRightDes, list, this.maskView);
    }

    public void onPause() {
        super.onPause();
        AudioPlayer.stopPlay((String)"default", (boolean)false);
        this.stopRecord();
    }

    private void startRecord() {
        if (this.audioRecorder == null) {
            this.audioRecorder = new SingSoundAudioRecorder(new SingSoundAudioRecorder.OnAudioRecordListener(){

                @Override
                public void onStart() {
                    SplitedWordDialogFragment.this.startRecordUI();
                }

                @Override
                public void onNoVoice() {
                    ToastUtils.showToast((String)"\u4ec0\u4e48\u4e5f\u6ca1\u542c\u5230");
                    SplitedWordDialogFragment.this.stopRecordUI();
                }

                @Override
                public void onTimeOut() {
                    ToastUtils.showToast((String)"\u5f55\u97f3\u8d85\u65f6");
                    SplitedWordDialogFragment.this.stopRecordUI();
                }

                @Override
                public void onTimeCountDown(long startTime) {
                    SplitedWordDialogFragment.this.vWordAudioLayout.setProgress((int)((System.currentTimeMillis() - startTime) / 1000L), 15);
                }

                @Override
                public void onScored(String scoredWord, int score, String url, String path) {
                    SplitedWordDialogFragment.this.stopRecordUI();
                    if (TextUtils.equals((CharSequence)SplitedWordDialogFragment.this.word, (CharSequence)scoredWord)) {
                        SplitedWordDialogFragment.this.vWordAudioLayout.setUrl(path);
                        SplitedWordDialogFragment.this.vWordAudioLayout.setScore(String.valueOf(score));
                        SplitedWordDialogFragment.this.uploadRecorderMP3(score, path);
                    }
                }

                @Override
                public void onError(String msg) {
                    ToastUtils.showToast((String)msg);
                    SplitedWordDialogFragment.this.stopRecordUI();
                }
            });
        }
        this.audioRecorder.startRecord(this.word);
    }

    private void startRecordUI() {
        this.vWordAudioLayout.showRecordingUI();
        if (this.nsWord.indexOfChild((View)this.vWordAudioLayout) != -1) {
            int[] locations = new int[]{0, 0};
            this.vWordAudioLayout.getLocationOnScreen(locations);
            this.nsWord.removeView((View)this.vWordAudioLayout);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.leftMargin = locations[0];
            params.topMargin = locations[1];
            this.vGray.addView((View)this.vWordAudioLayout, (ViewGroup.LayoutParams)params);
            this.vGray.setVisibility(0);
        }
    }

    private void stopRecord() {
        this.stopRecordUI();
        if (this.audioRecorder != null) {
            this.audioRecorder.stopRecord();
        }
    }

    private void stopRecordUI() {
        if (this.vGray.indexOfChild((View)this.vWordAudioLayout) != -1) {
            this.vGray.removeView((View)this.vWordAudioLayout);
            this.nsWord.addView((View)this.vWordAudioLayout, new ViewGroup.LayoutParams(-2, -2));
            this.vGray.setVisibility(8);
        }
        this.vWordAudioLayout.hideRecodingUI();
    }

    private void playLastAudio() {
        this.vWordAudioLayout.showRecordPlayingUI();
        AudioPlayer.play((String)"default", (Uri)Uri.parse((String)this.vWordAudioLayout.getUrl()), (boolean)true, (float)AudioPlayer.DEFAULT_VOLUMN, (AudioPlayer.OnAudioPlayDone)new AudioPlayer.OnAudioPlayDone(){

            public void onAudioPlayDone() {
                SplitedWordDialogFragment.this.vWordAudioLayout.hideRecordPlayingUI();
            }
        });
    }

    private void uploadRecorderMP3(final int score, String localPath) {
        final String currentWord = this.word;
        EllaHttpService.getInstance((Context)ApplicationHolder.getContext()).upLoadFile(null, localPath, (HttpServiceCallBack)new HttpServiceCallBack<String>(){

            public void onHttpServiceFinished(final String s) {
                ReaderModule.wordScore(SplitedWordDialogFragment.this.word, s, score, SplitedWordDialogFragment.this.mCurrentSentence, SplitedWordDialogFragment.this.missionId, SplitedWordDialogFragment.this.missionCode, new HttpServiceCallBack<WordRecord>(){

                    public void onHttpServiceFinished(WordRecord wordRecord) {
                        SplitedWordDialogFragment.this.vWordAudioLayout.setUrl(s);
                        SplitedWordDialogFragment.this.vWordAudioLayout.setScore(String.valueOf(score));
                    }

                    public void onHttpServiceError(int i, String s2) {
                        if (TextUtils.equals((CharSequence)currentWord, (CharSequence)SplitedWordDialogFragment.this.word)) {
                            ToastUtils.showToast((String)SplitedWordDialogFragment.this.getString(R.string.upload_singsong_recorder_failed));
                        }
                    }
                });
            }

            public void onHttpServiceError(int i, String s) {
                if (TextUtils.equals((CharSequence)currentWord, (CharSequence)SplitedWordDialogFragment.this.word)) {
                    ToastUtils.showToast((String)"\u554a\u54e6\uff0c\u4e0a\u4f20\u5931\u8d25\uff0c\u518d\u8bfb\u4e00\u6b21\u5427~");
                }
            }
        });
    }

    public void onStop() {
        AnimationDrawable animationDrawable;
        super.onStop();
        if (this.vLoading != null && this.vLoading.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoading.getDrawable();
            animationDrawable.stop();
        }
        if (this.vLoadSentence != null && this.vLoadSentence.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoadSentence.getDrawable();
            animationDrawable.stop();
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, R.style.full_notch_dialog);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().requestFeature(1);
        if (dialog.getWindow() != null && dialog.getWindow().getDecorView() != null) {
            dialog.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
        return dialog;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_fragment_word_model, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.injectView(view);
        this.segmentID = this.getArguments().getInt("segmentID");
        this.sentenceID = this.getArguments().getInt("sentenceID");
        this.list = (ArrayList)this.getArguments().getSerializable("splitedSentenceList");
        this.audioPath = this.getArguments().getString("audioPath");
        this.bookCode = this.getArguments().getString("bookCode");
        this.missionCode = this.getArguments().getString("missionCode");
        this.missionId = this.getArguments().getString("missionId");
        this.pageNum = this.getArguments().getInt("pageNum");
        this.splitedSegmentsLayout.setOnWordSelectListener(this);
        this.splitedSegmentsLayout.setSplitedSentences(this.segmentID, this.sentenceID, this.list);
        this.onSentenceSelectClick();
        this.setSentence(this.splitedSegmentsLayout.getCurrentSplitedSentence().getSentence());
        this.getSentenceInfo(this.splitedSegmentsLayout.getCurrentSplitedSentence().getSentence());
    }

    private void setSentence(String sentence) {
        this.mCurrentSentence = sentence;
        sentence = sentence + "  ";
        String img = "img";
        SpannableString spannableString = new SpannableString((CharSequence)(sentence + img));
        ImageSpan imageSpan = new ImageSpan((Context)this.getActivity(), R.drawable.pass_course_icon_audio, 1);
        spannableString.setSpan((Object)imageSpan, sentence.length(), sentence.length() + img.length(), 17);
        this.tvSentenceContent.setText((CharSequence)spannableString);
        this.tvSentenceContent.setMovementMethod((MovementMethod)ClickableMovementMethod.getInstance());
    }

    @Override
    public void onSelect(int segmentID, int sentenceID, String word, SplitedSentence splitedSentence) {
        this.word = word;
        this.getWordInfo(word);
        this.getSentenceInfo(splitedSentence.getSentence());
        this.onWordSelectClick();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        try {
            this.getDialog().getWindow().requestFeature(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onActivityCreated(savedInstanceState);
        try {
            this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.getDialog().getWindow().setLayout(-1, -1);
            this.getDialog().getWindow().setFlags(1024, 1024);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onBackClick() {
        this.dismiss();
        EllaBookViewerHelper.resume();
    }

    void onWordSelectClick() {
        this.selectedWord(true);
        this.selectedSentence(false);
        this.stopRecord();
    }

    void onSentenceSelectClick() {
        this.selectedSentence(true);
        this.selectedWord(false);
        this.stopRecord();
    }

    void onAddWordClick() {
        if (this.word == null) {
            return;
        }
        ReaderModule.wordCollect(this.word, true, this.missionId, this.missionCode, new HttpServiceCallBack<Object>(){

            public void onHttpServiceFinished(Object o) {
                ToastUtils.showToast((String)"\u6dfb\u52a0\u6210\u529f");
                SplitedWordDialogFragment.this.tvAddWord.setEnabled(false);
            }

            public void onHttpServiceError(int i, String s) {
                ToastUtils.showToast((String)s);
            }
        });
    }

    void refreshAddWord() {
        this.tvAddWord.setEnabled(false);
        ReaderModule.isWordCollect(this.word, new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean o) {
                SplitedWordDialogFragment.this.tvAddWord.setEnabled(o != null && o == false);
            }

            public void onHttpServiceError(int i, String s) {
                SplitedWordDialogFragment.this.tvAddWord.setEnabled(false);
            }
        });
    }

    void refreshWordAudio() {
        this.vWordAudioLayout.setUrl(null);
        this.vWordAudioLayout.setScore(null);
        AudioPlayer.stopPlay((String)"default", (boolean)false);
        final String currentWord = this.word;
        ReaderModule.wordsHistory(this.word, new HttpServiceCallBack<WordRecord>(){

            public void onHttpServiceFinished(WordRecord o) {
                if (o != null && TextUtils.equals((CharSequence)currentWord, (CharSequence)SplitedWordDialogFragment.this.word)) {
                    SplitedWordDialogFragment.this.vWordAudioLayout.setUrl(o.url);
                    SplitedWordDialogFragment.this.vWordAudioLayout.setScore(o.score);
                }
            }

            public void onHttpServiceError(int i, String s) {
                if (TextUtils.equals((CharSequence)currentWord, (CharSequence)SplitedWordDialogFragment.this.word)) {
                    ToastUtils.showToast((String)(s == null ? "\u670d\u52a1\u5668\u5f02\u5e38" : s));
                }
            }
        });
    }

    void onAmericaAudioClick() {
        if (this.httpWordDetails == null) {
            return;
        }
        MediaPlayerUtil.play(this.httpWordDetails.usSpeech);
    }

    void onEnglandAudioClick() {
        if (this.httpWordDetails == null) {
            return;
        }
        MediaPlayerUtil.play(this.httpWordDetails.ukSpeech);
    }

    private void selectedWord(boolean isSelected) {
        ViewGroup.LayoutParams layoutParams = this.rlWordLayout.getLayoutParams();
        if (isSelected) {
            this.llRightDes.setBackgroundResource(R.drawable.pass_course_participles_word_selected);
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_selected));
            this.rlWordLayout.setLayoutParams(layoutParams);
            this.ivWordIcon.setVisibility(0);
            this.tvWordTextTip.setTextColor(Color.parseColor((String)"#7C70E6"));
            if (TextUtils.isEmpty((CharSequence)this.word)) {
                this.rlEmptyLayout.setVisibility(0);
                this.nsWord.setVisibility(8);
            } else {
                this.rlEmptyLayout.setVisibility(8);
                this.nsWord.setVisibility(0);
            }
        } else {
            this.llRightDes.setBackgroundResource(R.drawable.pass_course_participles_sentence_selected);
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_unselected));
            this.rlWordLayout.setLayoutParams(layoutParams);
            this.ivWordIcon.setVisibility(8);
            this.tvWordTextTip.setTextColor(Color.parseColor((String)"#FFFFFF"));
            this.nsWord.setVisibility(8);
        }
    }

    private void selectedSentence(boolean isSelected) {
        ViewGroup.LayoutParams layoutParams = this.rlSentenceLayout.getLayoutParams();
        if (isSelected) {
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_selected));
            this.rlSentenceLayout.setLayoutParams(layoutParams);
            this.ivSentenceIcon.setVisibility(0);
            this.tvSentenceTextTip.setTextColor(Color.parseColor((String)"#7C70E6"));
            this.nsSentence.setVisibility(0);
            this.rlEmptyLayout.setVisibility(8);
        } else {
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_unselected));
            this.rlSentenceLayout.setLayoutParams(layoutParams);
            this.ivSentenceIcon.setVisibility(8);
            this.tvSentenceTextTip.setTextColor(Color.parseColor((String)"#FFFFFF"));
            this.nsSentence.setVisibility(8);
        }
    }

    private void setFirstLineSpace(TextView tv, float length, String description) {
        SpannableString spannableString = new SpannableString((CharSequence)description);
        int marginSpanSize = Converter.dip2px((float)length);
        LeadingMarginSpan.Standard leadingMarginSpan = new LeadingMarginSpan.Standard(marginSpanSize, 0);
        spannableString.setSpan((Object)leadingMarginSpan, 0, description.length(), 17);
        tv.setText((CharSequence)spannableString);
    }

    private void getSentenceInfo(String sentence) {
        final CharSequence lastSentence = this.tvWord.getText();
        this.setSentence(sentence);
        this.vLoadSentence.setVisibility(0);
        this.tvSentenceContentTranslate.setVisibility(8);
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)FragmentEvent.PAUSE), UserInfoProvider.getUserId(), sentence, this.bookCode, this.pageNum, new HttpServiceCallBack<HttpWordDetails>(){

            public void onHttpServiceFinished(HttpWordDetails result) {
                SplitedWordDialogFragment.this.setSentence(result.word);
                SplitedWordDialogFragment.this.sentenceSpeech = result.usSpeech;
                SplitedWordDialogFragment.this.mCurrentTranslate = SplitedWordDialogFragment.this.removeWrapper(result.wordDesc);
                SplitedWordDialogFragment.this.vLoadSentence.setVisibility(8);
                SplitedWordDialogFragment.this.tvSentenceContentTranslate.setVisibility(0);
                SplitedWordDialogFragment.this.setFirstLineSpace(SplitedWordDialogFragment.this.tvSentenceContentTranslate, 30.0f, SplitedWordDialogFragment.this.mCurrentTranslate);
            }

            public void onHttpServiceError(int code, String msg) {
                SplitedWordDialogFragment.this.tvSentenceContent.setText(lastSentence);
                ToastUtils.showToast((String)msg);
                SplitedWordDialogFragment.this.vLoadSentence.setVisibility(8);
                SplitedWordDialogFragment.this.tvSentenceContentTranslate.setVisibility(0);
            }
        });
    }

    private void getWordInfo(String word) {
        final String lastWords = this.tvWord.getText().toString();
        this.tvWord.setText((CharSequence)word);
        this.vLoading.setVisibility(0);
        this.tvWordDes.setVisibility(8);
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)FragmentEvent.PAUSE), UserInfoProvider.getUserId(), word, this.bookCode, this.pageNum, new HttpServiceCallBack<HttpWordDetails>(){

            public void onHttpServiceFinished(HttpWordDetails result) {
                SplitedWordDialogFragment.this.httpWordDetails = result;
                SplitedWordDialogFragment.this.tvWord.setText((CharSequence)result.word);
                SplitedWordDialogFragment.this.tvWordDes.setText((CharSequence)SplitedWordDialogFragment.this.removeWrapper(result.explains));
                SplitedWordDialogFragment.this.vLoading.setVisibility(8);
                SplitedWordDialogFragment.this.tvWordDes.setVisibility(0);
            }

            public void onHttpServiceError(int code, String msg) {
                ToastUtils.showToast((String)msg);
                SplitedWordDialogFragment.this.tvWord.setText((CharSequence)lastWords);
                SplitedWordDialogFragment.this.vLoading.setVisibility(8);
                SplitedWordDialogFragment.this.tvWordDes.setVisibility(0);
            }
        });
        this.refreshAddWord();
        this.refreshWordAudio();
    }

    private String removeWrapper(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        return s.replace("[", "").replace("]", "").replace("\"", "").replace(",", "\n");
    }
}

