/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import cn.ellabook.EllaBookViewer;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.ui.read.BookReaderActivity;
import ellax.bookmanager.BookManager;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.cocos2dx.lib.Cocos2dxActivity;

public class BookReader {
    private static volatile long lastJumpTime = 0L;
    public static final long TIME_DIVIDER = 2500L;
    private static MissionService sSelfStudyService;

    public static boolean isCocos2dAvailable() {
        return Cocos2dxActivity.getContext() == null;
    }

    public static void bookRead(final Context context, final BookContainer bookContainer, final boolean isTryRead, final boolean isFinished) {
        BizReader.getInstance().bookStatus(null, bookContainer.getBookCode(), null, new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean s) {
                if (s != null && s.booleanValue()) {
                    BookReader._bookRead(context, bookContainer, isTryRead, isFinished);
                } else {
                    ToastUtils.showCenterToast((String)"\u56fe\u4e66\u4e0b\u67b6\uff0c\u6682\u65f6\u65e0\u6cd5\u9605\u8bfb\uff0c\u5148\u53bb\u770b\u770b\u5176\u4ed6\u4e66\u5427~");
                }
            }

            public void onHttpServiceError(int i, String s) {
                ToastUtils.showCenterToast((String)(s == null ? "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38" : s));
            }
        });
    }

    private static Activity getActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return BookReader.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static void _bookRead(Context context, BookContainer bookContainer, boolean isTryRead, boolean isFinished) {
        if (!BookReader.isCocos2dAvailable()) {
            return;
        }
        if (System.currentTimeMillis() < lastJumpTime + 2500L) {
            return;
        }
        lastJumpTime = System.currentTimeMillis();
        String path = null;
        try {
            path = BookManager.getResourceForReader((String)bookContainer.getBookCode(), (boolean)isTryRead).getPath();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            ToastUtils.showToast((String)"\u4e66\u7c4d\u8d44\u6e90\u5f02\u5e38\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u4e0b\u8f7d");
            return;
        }
        Intent intent = new Intent(context, BookReaderActivity.class);
        intent.putExtra("bookPath", path);
        intent.putExtra("bookContainer", (Serializable)((Object)bookContainer));
        intent.putExtra("isTryRead", isTryRead);
        intent.putExtra("isFinished", isFinished);
        context.startActivity(intent);
    }

    public static void courseRead(Context context, BookContainer bookContainer, long mapId, boolean isFinished, int passNumber) {
        BookReader.courseRead(context, bookContainer, mapId, 0, isFinished, passNumber);
    }

    public static void courseRead(final Context context, final BookContainer bookContainer, final long mapId, final int page, final boolean isFinished, final int passNumber) {
        BizReader.getInstance().bookStatus(null, bookContainer.getBookCode(), bookContainer.getId(), new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean s) {
                if (s != null && s.booleanValue()) {
                    BookReader._courseRead(context, bookContainer, mapId, page, isFinished, passNumber);
                } else {
                    ToastUtils.showCenterToast((String)"\u56fe\u4e66\u4e0b\u67b6\uff0c\u6682\u65f6\u65e0\u6cd5\u9605\u8bfb\uff0c\u5148\u53bb\u770b\u770b\u5176\u4ed6\u4e66\u5427~");
                }
            }

            public void onHttpServiceError(int i, String s) {
                ToastUtils.showCenterToast((String)(s == null ? "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38" : s));
            }
        });
    }

    public static void _courseRead(Context context, BookContainer bookContainer, long mapId, int page, boolean isFinished, int passNumber) {
        if (!BookReader.isCocos2dAvailable()) {
            return;
        }
        if (System.currentTimeMillis() < lastJumpTime + 1000L) {
            return;
        }
        lastJumpTime = System.currentTimeMillis();
        String path = null;
        try {
            path = BookManager.getResourceForReader((String)bookContainer.getBookCode(), (boolean)false).getPath();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            ToastUtils.showToast((String)"\u4e66\u7c4d\u8d44\u6e90\u5f02\u5e38\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u4e0b\u8f7d");
            return;
        }
        Intent intent = new Intent(context, BookReaderActivity.class);
        intent.putExtra("bookPath", path);
        intent.putExtra("currentPage", page);
        intent.putExtra("bookContainer", (Serializable)((Object)bookContainer));
        intent.putExtra("mapId", mapId);
        intent.putExtra("isFinished", isFinished);
        intent.putExtra("passNumber", passNumber);
        context.startActivity(intent);
    }

    public static void finishReader() {
        EllaBookViewer.endBookViewer();
    }

    public static void gotoPage(int pageNumber) {
        EllaBookViewer.gotoPage((int)pageNumber);
        if (Cocos2dxActivity.getContext() != null && Cocos2dxActivity.getContext() instanceof BookReaderActivity) {
            ((BookReaderActivity)Cocos2dxActivity.getContext()).cleanRunnable();
        }
    }

    public static void restartCurrentPage() {
        EllaBookViewer.restartCurrentPage();
    }

    public static void restartBook() {
        EllaBookViewer.gotoPage((int)1);
    }

    public static void restartBookWithMission() {
        EllaBookViewer.gotoPage((int)1);
        EllaBookViewer.setBookPlayMode((byte)4);
    }

    public static void init(MissionService sSelfStudyService) {
        BookReader.sSelfStudyService = sSelfStudyService;
    }

    public static void onSelfStudyDone(FragmentManager fragmentManager, int id2, String tag, boolean ispassed, long mapid, long bookid, ArrayList<String> toEndPassReadStartEnds) {
        sSelfStudyService.onDone(fragmentManager, id2, tag, ispassed, mapid, bookid, toEndPassReadStartEnds);
    }

    public static void showPowerStone(FragmentManager fragmentManager, int passCounts, int maxCounts, long missionId, long mapId, String bookCover, HashMap<Integer, Integer> pageMap, boolean hidePowerRemine, boolean hideControl) {
        sSelfStudyService.showPowerStone(fragmentManager, passCounts, maxCounts, missionId, mapId, bookCover, pageMap, hidePowerRemine, hideControl);
    }

    public static interface MissionService {
        public void onDone(FragmentManager var1, int var2, String var3, boolean var4, long var5, long var7, ArrayList<String> var9);

        public void showPowerStone(FragmentManager var1, int var2, int var3, long var4, long var6, String var8, HashMap<Integer, Integer> var9, boolean var10, boolean var11);
    }
}

