/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ctrl;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.ellabook.project.ellareader.bean.FeedbackBean;
import java.util.List;

public class FeedbackRequestCache {
    private String mBookCode;
    private List<FeedbackBean> mReasonList;

    private FeedbackRequestCache() {
    }

    public static FeedbackRequestCache getInstance() {
        return Singleton.instance;
    }

    public List<FeedbackBean> getReasonListCache(@NonNull String bookCode) {
        if (TextUtils.equals((CharSequence)bookCode, (CharSequence)this.mBookCode) && this.mReasonList != null && this.mReasonList.size() != 0) {
            return this.mReasonList;
        }
        return null;
    }

    public void updateReasonList(@NonNull String bookCode, @NonNull List<FeedbackBean> list) {
        if (!TextUtils.equals((CharSequence)bookCode, (CharSequence)this.mBookCode) && list.size() > 0) {
            this.mBookCode = bookCode;
            this.mReasonList = list;
        }
    }

    private static class Singleton {
        private static FeedbackRequestCache instance = new FeedbackRequestCache();

        private Singleton() {
        }
    }
}

