/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import com.constraint.AudioTypeEnum;
import com.constraint.CoreProvideTypeEnum;
import com.constraint.OffLineSourceEnum;
import com.constraint.ResultBody;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.ellareader.R;
import com.xs.BaseSingEngine;
import com.xs.SingEngine;
import com.xs.impl.OnEndCallback;
import ellax.base.helper.AppExecutors;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class SingSoundAudioRecorder {
    public static final String TAG = "SS.TAG";
    public static final Long MAX_TIME = 15000L;
    private static final String appKey = "a285";
    private static final String secretKey = "c11163aa6c834a028da4a4b30955bd65";
    private OnAudioRecordListener onAudioRecordListener;
    private ReadyListener mReadyListener;
    private SingEngine mEngine;
    private Timer timer = new Timer();
    private CountDownTimerTask task;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private BaseSingEngine.ResultListener mResultListener = new BaseSingEngine.ResultListener(){

        public void onBegin() {
            SingSoundAudioRecorder.this.isRunning.set(true);
            if (SingSoundAudioRecorder.this.task != null) {
                SingSoundAudioRecorder.this.task.cancel();
            }
            SingSoundAudioRecorder.this.task = new CountDownTimerTask(System.currentTimeMillis());
            SingSoundAudioRecorder.this.timer.schedule((TimerTask)SingSoundAudioRecorder.this.task, 0L, 100L);
            AppExecutors.mainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SingSoundAudioRecorder.this.onAudioRecordListener.onStart();
                }
            });
        }

        public void onResult(final JSONObject jsonObject) {
            AppExecutors.mainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int score = jsonObject.getJSONObject("result").getInt("overall");
                        String localpath = SingSoundAudioRecorder.this.mEngine.getWavPath();
                        SingSoundAudioRecorder.this.onAudioRecordListener.onScored(jsonObject.getJSONObject("params").getJSONObject("request").getString("refText"), score, "", localpath);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        SingSoundAudioRecorder.this.onAudioRecordListener.onError("\u8bc4\u6d4b\u6570\u636e\u5f02\u5e38");
                    }
                }
            });
        }

        public void onEnd(int i, String s) {
            SingSoundAudioRecorder.this.isRunning.set(false);
            if (SingSoundAudioRecorder.this.task != null) {
                SingSoundAudioRecorder.this.task.cancel();
                SingSoundAudioRecorder.this.task = null;
            }
            if (i != 0) {
                AppExecutors.mainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SingSoundAudioRecorder.this.onAudioRecordListener.onError(ApplicationHolder.getContext().getString(R.string.singsong_recorder_engine_error));
                    }
                });
            }
        }

        public void onUpdateVolume(int i) {
        }

        public void onFrontVadTimeOut() {
            Log.i((String)SingSoundAudioRecorder.TAG, (String)"onFrontVadTimeOut");
            SingSoundAudioRecorder.this.stopRecord();
            AppExecutors.mainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Log.i((String)SingSoundAudioRecorder.TAG, (String)"onFrontVadTimeOut UI");
                    SingSoundAudioRecorder.this.onAudioRecordListener.onNoVoice();
                }
            });
        }

        public void onBackVadTimeOut() {
            Log.i((String)SingSoundAudioRecorder.TAG, (String)"onBackVadTimeOut");
        }

        public void onRecordingBuffer(byte[] bytes, int i) {
        }

        public void onRecordLengthOut() {
            Log.i((String)SingSoundAudioRecorder.TAG, (String)"onRecordLengthOut");
        }

        public void onReady() {
            if (SingSoundAudioRecorder.this.mReadyListener != null) {
                SingSoundAudioRecorder.this.mReadyListener.onReady();
                SingSoundAudioRecorder.this.mReadyListener = null;
            }
        }

        public void onPlayCompeleted() {
        }

        public void onRecordStop() {
        }
    };
    private OnEndCallback mOnEndCallback = new OnEndCallback(){

        public void onEnd(ResultBody resultBody) {
            if (resultBody.getCode() != 0) {
                Log.i((String)SingSoundAudioRecorder.TAG, (String)("onEnd " + resultBody.toString()));
            }
        }
    };
    private BaseSingEngine.AudioErrorCallback mAudioErrorCallback = new BaseSingEngine.AudioErrorCallback(){

        public void onAudioError(int i) {
            Log.e((String)SingSoundAudioRecorder.TAG, (String)("onAudioError " + i));
            SingSoundAudioRecorder.this.onAudioRecordListener.onError(ApplicationHolder.getContext().getString(R.string.singsong_recorder_running_error));
        }
    };

    private void onCountDown(final long startTime) {
        AppExecutors.mainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SingSoundAudioRecorder.this.isRunning.get()) {
                    if (System.currentTimeMillis() - startTime > MAX_TIME) {
                        SingSoundAudioRecorder.this.stopRecord();
                        SingSoundAudioRecorder.this.onAudioRecordListener.onTimeOut();
                    } else {
                        SingSoundAudioRecorder.this.onAudioRecordListener.onTimeCountDown(startTime);
                    }
                }
            }
        });
    }

    public SingSoundAudioRecorder(OnAudioRecordListener onAudioRecordListener) {
        this.onAudioRecordListener = onAudioRecordListener;
    }

    public void startRecord(final String word) {
        if (this.mEngine == null) {
            this.initEngine();
            this.mReadyListener = new ReadyListener(){

                @Override
                public void onReady() {
                    SingSoundAudioRecorder.this.start(word);
                }
            };
        } else {
            this.start(word);
        }
    }

    public void stopRecord() {
        if (this.mEngine != null) {
            this.mEngine.stop();
        }
        this.isRunning.set(false);
    }

    private void start(String word) {
        try {
            JSONObject request = new JSONObject();
            request.put("coreType", (Object)"en.word.score");
            request.put("refText", (Object)word);
            request.put("rank", 100);
            request.put("precision", 1);
            request.put("typeThres", 2);
            JSONObject startCfg = this.mEngine.buildStartJson("guest", request);
            this.mEngine.setStartCfg(startCfg);
            this.mEngine.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initEngine() {
        new Thread(){

            @Override
            public void run() {
                try {
                    SingSoundAudioRecorder.this.mEngine = SingEngine.newInstance((Context)ApplicationHolder.getContext());
                    SingSoundAudioRecorder.this.mEngine.setOpenVad(true, "vad.0.1.bin");
                    SingSoundAudioRecorder.this.mEngine.setWavPath(ApplicationHolder.getContext().getExternalCacheDir().getAbsolutePath() + "/record_word_tmp/");
                    SingSoundAudioRecorder.this.mEngine.setListener(SingSoundAudioRecorder.this.mResultListener);
                    SingSoundAudioRecorder.this.mEngine.setFrontVadTime(5000L);
                    SingSoundAudioRecorder.this.mEngine.setBackVadTime(15000L);
                    SingSoundAudioRecorder.this.mEngine.setOffLineSource(OffLineSourceEnum.SOURCE_BOTN);
                    SingSoundAudioRecorder.this.mEngine.setOnEndCallback(SingSoundAudioRecorder.this.mOnEndCallback);
                    SingSoundAudioRecorder.this.mEngine.setAudioErrorCallback(SingSoundAudioRecorder.this.mAudioErrorCallback);
                    SingSoundAudioRecorder.this.mEngine.setAudioType(AudioTypeEnum.WAV);
                    SingSoundAudioRecorder.this.mEngine.setServerType(CoreProvideTypeEnum.AUTO);
                    SingSoundAudioRecorder.this.mEngine.setLogLevel(4L);
                    SingSoundAudioRecorder.this.mEngine.disableVolume();
                    JSONObject cfgInit = SingSoundAudioRecorder.this.mEngine.buildInitJson(SingSoundAudioRecorder.appKey, SingSoundAudioRecorder.secretKey);
                    SingSoundAudioRecorder.this.mEngine.setNewCfg(cfgInit);
                    SingSoundAudioRecorder.this.mEngine.createEngine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private class CountDownTimerTask
    extends TimerTask {
        long startTime = 0L;

        CountDownTimerTask(long startTime) {
            this.startTime = startTime;
        }

        @Override
        public void run() {
            SingSoundAudioRecorder.this.onCountDown(this.startTime);
        }
    }

    private static interface ReadyListener {
        public void onReady();
    }

    public static interface OnAudioRecordListener {
        public void onStart();

        public void onNoVoice();

        public void onTimeOut();

        public void onTimeCountDown(long var1);

        public void onScored(String var1, int var2, @Deprecated @Nullable String var3, @Nullable String var4);

        public void onError(String var1);
    }
}

