/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.ellabook.project.ellareader.R;

public class RoundProgressBar
extends View {
    private Paint paint = new Paint();
    private int roundColor;
    private int roundProgressColor;
    private int textColor;
    private float textSize;
    private float roundWidth;
    private int max;
    private int progress;
    private boolean textIsDisplayable;
    private int style;
    public static final int STROKE = 0;
    public static final int FILL = 1;

    public RoundProgressBar(Context context) {
        this(context, null);
    }

    public RoundProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.RoundProgressBar);
        this.roundColor = mTypedArray.getColor(R.styleable.RoundProgressBar_progressRoundColor, -65536);
        this.roundProgressColor = mTypedArray.getColor(R.styleable.RoundProgressBar_roundProgressColor, -16711936);
        this.textColor = mTypedArray.getColor(R.styleable.RoundProgressBar_textColor, -16711936);
        this.textSize = mTypedArray.getDimension(R.styleable.RoundProgressBar_textSize, 15.0f);
        this.roundWidth = mTypedArray.getDimension(R.styleable.RoundProgressBar_roundWidth, 5.0f);
        this.max = mTypedArray.getInteger(R.styleable.RoundProgressBar_max, 100);
        this.textIsDisplayable = mTypedArray.getBoolean(R.styleable.RoundProgressBar_textIsDisplayable, true);
        this.style = mTypedArray.getInt(R.styleable.RoundProgressBar_progressRoundStyle, 0);
        mTypedArray.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centre = this.getWidth() / 2;
        int radius = (int)((float)centre - this.roundWidth / 2.0f) - 2;
        this.paint.setColor(this.roundColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.roundWidth - 2.0f);
        this.paint.setAntiAlias(true);
        canvas.drawCircle((float)centre, (float)centre, (float)radius, this.paint);
        Log.e((String)"log", (String)(centre + ""));
        this.paint.setStrokeWidth(0.0f);
        this.paint.setColor(this.textColor);
        this.paint.setTextSize(this.textSize);
        this.paint.setTypeface(Typeface.DEFAULT_BOLD);
        int percent = (int)((float)this.progress / (float)this.max * 100.0f);
        float textWidth = this.paint.measureText(percent + "%");
        if (this.textIsDisplayable && this.style == 0) {
            canvas.drawText(percent + "%", (float)centre - textWidth / 2.0f, (float)centre + this.textSize / 2.0f, this.paint);
        }
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setColor(this.roundProgressColor);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        RectF oval = new RectF((float)(centre - radius - 1), (float)(centre - radius - 1), (float)(centre + radius + 1), (float)(centre + radius + 1));
        switch (this.style) {
            case 0: {
                this.paint.setStyle(Paint.Style.STROKE);
                canvas.drawArc(oval, 90.0f, (float)(360 * this.progress / this.max), false, this.paint);
                break;
            }
            case 1: {
                this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
                if (this.progress == 0) break;
                canvas.drawArc(oval, 90.0f, (float)(360 * this.progress / this.max), true, this.paint);
            }
        }
    }

    public synchronized int getMax() {
        return this.max;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("max not less than 0");
        }
        this.max = max;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        if (progress < 0) {
            throw new IllegalArgumentException("progress not less than 0");
        }
        if (progress > this.max) {
            progress = this.max;
        }
        if (progress <= this.max) {
            this.progress = progress;
            this.postInvalidate();
        }
    }

    public int getCricleColor() {
        return this.roundColor;
    }

    public void setCricleColor(int cricleColor) {
        this.roundColor = cricleColor;
    }

    public int getCricleProgressColor() {
        return this.roundProgressColor;
    }

    public void setCricleProgressColor(int cricleProgressColor) {
        this.roundProgressColor = cricleProgressColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public float getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(float roundWidth) {
        this.roundWidth = roundWidth;
    }
}

