/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.RoundProgressBar;

public class AudioWordLayout
extends RelativeLayout {
    boolean inited = false;
    private RecordListener listener;
    private TextView vPlay;
    private ImageView vAnimation;
    private TextView vScore;
    private View vRecording;
    private RoundProgressBar roundProgressBar;
    private String score = null;
    private String url = null;

    public void setListener(RecordListener listener) {
        this.listener = listener;
    }

    public AudioWordLayout(@NonNull Context context) {
        super(context);
        this.init();
    }

    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        if (!this.inited) {
            this.inited = true;
            this.setGravity(17);
            this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.word_record_layout, (ViewGroup)this, false), new ViewGroup.LayoutParams(-2, -2));
            this.roundProgressBar = (RoundProgressBar)this.findViewById(R.id.vProgress);
            this.vPlay = (TextView)this.findViewById(R.id.vPlay);
            this.vAnimation = (ImageView)this.findViewById(R.id.vAnimation);
            this.vScore = (TextView)this.findViewById(R.id.vScore);
            this.vRecording = this.findViewById(R.id.vRecording);
            this.vPlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AudioWordLayout.this.listener != null) {
                        AudioWordLayout.this.listener.onPlayClick();
                    }
                }
            });
            this.vRecording.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AudioWordLayout.this.roundProgressBar.getBackground() != null) {
                        if (AudioWordLayout.this.listener != null) {
                            AudioWordLayout.this.listener.onRecordClick(false);
                        }
                    } else if (AudioWordLayout.this.listener != null) {
                        AudioWordLayout.this.listener.onRecordClick(true);
                    }
                }
            });
        }
    }

    public void showRecordPlayingUI() {
        AnimationDrawable drawable2 = (AnimationDrawable)this.getResources().getDrawable(R.drawable.word_record_palying_animation);
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        this.vPlay.setCompoundDrawables((Drawable)drawable2, null, null, null);
        drawable2.start();
        this.vPlay.setEnabled(false);
        this.vPlay.setText((CharSequence)"");
        this.setProgress(0, 15);
        this.vRecording.setEnabled(false);
    }

    public void hideRecordPlayingUI() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.btn_bofang);
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        this.vPlay.setCompoundDrawables(drawable2, null, null, null);
        this.vPlay.setText((CharSequence)"\u6211\u7684");
        this.vPlay.setEnabled(true);
        this.vRecording.setEnabled(true);
    }

    public void showRecordingUI() {
        this.vAnimation.setVisibility(0);
        ((AnimationDrawable)this.vAnimation.getDrawable()).start();
        this.vPlay.setVisibility(4);
        this.vScore.setVisibility(4);
        this.roundProgressBar.setBackground(null);
        this.roundProgressBar.setProgress(0);
    }

    public void hideRecodingUI() {
        this.vAnimation.setVisibility(4);
        ((AnimationDrawable)this.vAnimation.getDrawable()).stop();
        if (!TextUtils.isEmpty((CharSequence)this.score)) {
            this.vScore.setVisibility(0);
        } else {
            this.vScore.setVisibility(4);
        }
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            this.vPlay.setVisibility(0);
        } else {
            this.vPlay.setVisibility(4);
        }
        this.roundProgressBar.setBackgroundResource(R.drawable.word_recording_progressing_bg);
        this.roundProgressBar.setProgress(0);
    }

    public void setProgress(int time, int max) {
        this.roundProgressBar.setProgress(time);
        this.roundProgressBar.setMax(max);
    }

    public void setScore(String score) {
        this.score = score;
        if (!TextUtils.isEmpty((CharSequence)score)) {
            this.vScore.setVisibility(0);
            this.vScore.setText((CharSequence)("\u5f97\u5206" + score + "\u5206"));
        } else {
            this.vScore.setVisibility(4);
        }
    }

    public void setUrl(String url) {
        this.url = url;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.vPlay.setVisibility(0);
        } else {
            this.vPlay.setVisibility(4);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public static interface RecordListener {
        public void onRecordClick(boolean var1);

        public void onPlayClick();
    }
}

