/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader;

import android.media.MediaRecorder;
import android.os.Handler;
import android.util.Log;
import java.io.File;
import java.io.IOException;

@Deprecated
public class AudioRecorder {
    public static final int MIN_AMPLITUDE = 75;
    public static final long MAX_RECORDER_TIME = 15000L;
    public static final long MAX_NO_SOUND_TIME = 5000L;
    private final String TAG = "MediaRecord";
    private MediaRecorder mMediaRecorder;
    public static final int MAX_LENGTH = 600000;
    private String filePath;
    private OnAudioRecordListener onAudioRecordListener;
    private long startTime;
    private long endTime;
    private final Handler mHandler = new Handler();
    private Runnable mUpdateMicStatusTimer = new Runnable(){

        @Override
        public void run() {
            AudioRecorder.this.updateMicStatus();
        }
    };
    private static final int BASE = 1;
    private static final int SPACE = 200;
    private boolean hasVoice = false;

    public AudioRecorder(OnAudioRecordListener onAudioRecordListener) {
        this.onAudioRecordListener = onAudioRecordListener;
    }

    public void startRecord(File file) {
        this.filePath = file.getAbsolutePath();
        Log.e((String)"MediaRecord", (String)("file path:" + this.filePath));
        this.hasVoice = false;
        if (this.mMediaRecorder == null) {
            this.mMediaRecorder = new MediaRecorder();
        }
        try {
            this.mMediaRecorder.setAudioSource(1);
            this.mMediaRecorder.setOutputFormat(0);
            this.mMediaRecorder.setAudioEncoder(1);
            this.mMediaRecorder.setOutputFile(this.filePath);
            this.mMediaRecorder.setMaxDuration(600000);
            this.mMediaRecorder.prepare();
            this.mMediaRecorder.start();
            this.startTime = System.currentTimeMillis();
            this.updateMicStatus();
            Log.i((String)"ACTION_START", (String)("startTime" + this.startTime));
        }
        catch (IllegalStateException e) {
            Log.i((String)"MediaRecord", (String)("call startAmr(File mRecAudioFile) failed!" + e.getMessage()));
        }
        catch (IOException e) {
            Log.i((String)"MediaRecord", (String)("call startAmr(File mRecAudioFile) failed!" + e.getMessage()));
        }
    }

    public long stopRecord() {
        if (this.mMediaRecorder == null) {
            return 0L;
        }
        this.mHandler.removeCallbacks(this.mUpdateMicStatusTimer);
        this.endTime = System.currentTimeMillis();
        Log.i((String)"ACTION_END", (String)("endTime" + this.endTime));
        this.mMediaRecorder.stop();
        this.mMediaRecorder.reset();
        this.mMediaRecorder.release();
        this.mMediaRecorder = null;
        Log.i((String)"ACTION_LENGTH", (String)("Time" + (this.endTime - this.startTime)));
        if (!this.hasVoice) {
            return 0L;
        }
        return this.endTime - this.startTime;
    }

    private void updateMicStatus() {
        if (System.currentTimeMillis() - this.startTime > 15000L) {
            if (this.mMediaRecorder != null) {
                this.stopRecord();
                this.onAudioRecordListener.onRecorderOverFlow();
            }
        } else if (this.mMediaRecorder != null) {
            this.onAudioRecordListener.onTimeCountDown(this.startTime);
            if (!this.hasVoice) {
                double ratio = (double)this.mMediaRecorder.getMaxAmplitude() / 1.0;
                double db = 0.0;
                if (ratio > 1.0) {
                    db = 20.0 * Math.log10(ratio);
                }
                Log.d((String)"MediaRecord", (String)("\u5206\u8d1d\u503c\uff1a" + db));
                boolean bl = this.hasVoice = db >= 75.0;
            }
            if (!this.hasVoice) {
                if (System.currentTimeMillis() - this.startTime > 5000L) {
                    this.stopRecord();
                    this.onAudioRecordListener.onNoVoice();
                } else {
                    this.mHandler.postDelayed(this.mUpdateMicStatusTimer, 200L);
                }
            } else {
                this.mHandler.postDelayed(this.mUpdateMicStatusTimer, 200L);
            }
        }
    }

    public static interface OnAudioRecordListener {
        public void onNoVoice();

        public void onTimeCountDown(long var1);

        public void onRecorderOverFlow();
    }
}

