/*
 * Decompiled with CFR 0.152.
 */
package cn.ellabook;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import cn.ellabook.BookViewerCallback;
import cn.ellabook.EllaBookViewer;
import cn.ellabook.EllaBookViewerActivity;
import cn.ellabook.NativeCpp;
import cn.ellabook.ReadTimeCounter;
import cn.ellabook.ReaderControler;
import cn.ellabook.ReaderControlerImp;
import com.ellabook.project.base.util.device.MemoryUtil;
import com.ellabook.project.base.util.device.ScreenUtil;
import com.ellabook.project.base.util.io.FileUtils;
import java.io.File;

public abstract class ReaderActivity
extends EllaBookViewerActivity
implements BookViewerCallback {
    public static final String KEY_CURRENT_PAGE = "currentPage";
    public static final String KEY_BOOK_PATH = "bookPath";
    private ReaderControler mReaderControler;
    private View mReaderControlView;
    private String mBookPath;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ReadTimeCounter.getInstance().onActivityCreate();
        this.mBookPath = this.getIntent().getStringExtra(KEY_BOOK_PATH);
        this.initLib();
        this.initWindow();
        this.setKeepScreenOn(true);
        this.initResource();
        EllaBookViewer.setBookViewerCallback((BookViewerCallback)this);
        NativeCpp.enablePageCallback();
        this.setReadControlView(this.createReaderControlView());
        this.startReader();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String bookPath = intent.getStringExtra(KEY_BOOK_PATH);
        if (TextUtils.equals((CharSequence)bookPath, (CharSequence)this.mBookPath)) {
            return;
        }
        this.startReader();
    }

    private void initLib() {
        try {
            ApplicationInfo ai = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String libName = bundle.getString("android.app.lib_name");
            System.loadLibrary(libName);
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
    }

    private void initWindow() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setFlags(0x1000000, 0x1000000);
        }
    }

    private void initResource() {
        float scale = (float)ScreenUtil.getDeviceHeight((Context)this) * 1.0f / (float)ScreenUtil.getDeviceWidth((Context)this);
        if (this.isIphone1334()) {
            NativeCpp.initResource((int)1334, (int)750, (float)scale);
        } else {
            NativeCpp.initResource((int)2208, (int)1242, (float)scale);
        }
        if (ScreenUtil.checkIfFullScreen((Context)this)) {
            EllaBookViewer.setResolutionPolicy((String)"FIXED_WIDTH");
        } else {
            EllaBookViewer.setResolutionPolicy((String)"FIXED_HEIGHT");
        }
        try {
            long memoryFree = MemoryUtil.getMemoryFree((Context)this);
            if (memoryFree > 0L) {
                EllaBookViewer.setDeviceMemorySize((float)(0.9f * (float)MemoryUtil.getMemoryFree((Context)this) / 1024.0f / 1024.0f));
            }
        }
        catch (Exception e) {
            Log.e((String)"ellareader", (String)"get memory error", (Throwable)e);
        }
    }

    private boolean isIphone1334() {
        return new File(this.mBookPath).getName().equals("Iphone1334");
    }

    private void setReadControlView(View readerControlView) {
        if (readerControlView == null) {
            return;
        }
        if (this.mReaderControlView != null) {
            this.mFrameLayout.removeView(this.mReaderControlView);
        }
        this.mReaderControlView = readerControlView;
        this.mFrameLayout.addView(readerControlView);
    }

    protected abstract View createReaderControlView();

    private void startReader() {
        String bookPath = this.getIntent().getStringExtra(KEY_BOOK_PATH);
        int currentPage = this.getIntent().getIntExtra(KEY_CURRENT_PAGE, 0);
        if (TextUtils.isEmpty((CharSequence)bookPath)) {
            throw new IllegalArgumentException("bookPath must not be empty!");
        }
        this.mBookPath = bookPath;
        boolean b = FileUtils.isFileExists((String)bookPath);
        EllaBookViewer.setPreloadMode((byte)0);
        NativeCpp.initBook((String)bookPath, (int)currentPage);
    }

    public ReaderControler getReaderControler() {
        if (this.mReaderControler == null) {
            this.mReaderControler = new ReaderControlerImp();
        }
        return this.mReaderControler;
    }

    protected void onDestroy() {
        super.onDestroy();
        EllaBookViewer.setBookViewerCallback(null);
    }

    public void finish() {
        super.finish();
        NativeCpp.bookQuit();
    }

    protected void onResume() {
        super.onResume();
        NativeCpp.enablePageCallback();
        ReadTimeCounter.getInstance().onActivityResume();
    }

    protected void onPause() {
        super.onPause();
        ReadTimeCounter.getInstance().onActivityPause();
    }

    public void onViewerNotice(int var1) {
        this.runOnUiThread(() -> this.onViewerNotice2(var1));
    }

    public void onViewerNotice2(int var1) {
    }

    public final void isViewerReady(boolean var1) {
        this.runOnUiThread(() -> this.isViewerReady2(var1));
    }

    public void isViewerReady2(boolean var1) {
    }

    public final void onTipsEnable(boolean var1) {
        this.runOnUiThread(() -> this.onTipsEnable2(var1));
    }

    public void onTipsEnable2(boolean var1) {
    }

    public final void onTipsShow(boolean var1) {
        this.runOnUiThread(() -> this.onTipsShow2(var1));
    }

    public void onTipsShow2(boolean var1) {
    }

    public final void onBookEnd() {
        this.runOnUiThread(() -> this.onBookEnd2());
    }

    public void onBookEnd2() {
    }

    public final void onPageStateNotice(int i, int i1) {
        this.runOnUiThread(() -> this.onPageStateNotice2(i, i1));
    }

    public void onPageStateNotice2(int i, int i1) {
    }

    public final View getHudView(ViewGroup parent) {
        return this.mReaderControlView;
    }

    public final void onMemoryOverflow() {
        this.runOnUiThread(() -> this.onMemoryOverflow2());
    }

    public void onMemoryOverflow2() {
    }

    public final void onClassModeEnd() {
        this.runOnUiThread(() -> this.onClassModeEnd2());
    }

    public void onClassModeEnd2() {
    }

    public void onClassModeResult2(String s) {
    }

    public void onClassModeResult(String[] results) {
    }

    public final void onSubtitleSplit(int segmentID, int sentenceID, Object[] vSubtitleSplitData, String soundFile) {
        this.runOnUiThread(() -> this.onSubtitleSplit2(segmentID, sentenceID, vSubtitleSplitData, soundFile));
    }

    public void onSubtitleSplit2(int segmentID, int sentenceID, Object[] vSubtitleSplitData, String soundFile) {
    }
}

