/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Fragment;
import android.net.Uri;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ui.read.BookReaderActivity;
import com.ellabook.project.ellareader.ui.read.ShadownXorView;

public class CourseSecondGuideFragment
extends Fragment
implements View.OnClickListener {
    private RelativeLayout rlGuideOne;
    private TextView tvNextOne;
    private View vDiamondHighLight = null;
    private ShadownXorView sdvDiamondHighLight;
    public static final String GUIDE_KEY = "CourseSecondGuideFragment.GUIDE_KEY";

    public static void checkShowGuide(BookReaderActivity context, int diamondWidth) {
        if (context.getReaderControler().getCurrentPage() != 2) {
            return;
        }
        if (!UserInfoProvider.isGuideAvailable((String)GUIDE_KEY, (boolean)true)) {
            return;
        }
        UserInfoProvider.setGuide((String)GUIDE_KEY, (boolean)false);
        context.getReaderControler().pause();
        CourseSecondGuideFragment courseGuideFragment = new CourseSecondGuideFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("diamond_width", diamondWidth);
        courseGuideFragment.setArguments(bundle);
        context.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, (Fragment)courseGuideFragment).commitAllowingStateLoss();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_fragment_second_guide, container, false);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        int diamondWidth = this.getArguments().getInt("diamond_width");
        this.vDiamondHighLight = view.findViewById(R.id.vDiamondHighLight);
        this.vDiamondHighLight.getLayoutParams().width = diamondWidth;
        this.sdvDiamondHighLight = (ShadownXorView)view.findViewById(R.id.sdvDiamondHighLight);
        this.rlGuideOne = (RelativeLayout)view.findViewById(R.id.rlGuideOne);
        this.tvNextOne = (TextView)view.findViewById(R.id.tvNextOne);
        this.tvNextOne.setOnClickListener((View.OnClickListener)this);
        Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)new ShowGuideIdleOnce());
        this.playVoice(R.raw.course_power_remines);
        return view;
    }

    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable((String)voiceName, (boolean)false)) {
            return true;
        }
        UserInfoProvider.setGuide((String)voiceName, (boolean)true);
        return false;
    }

    private boolean resetGuide() {
        if (this.vDiamondHighLight == null) {
            return false;
        }
        if (this.vDiamondHighLight.getX() == 0.0f) {
            return true;
        }
        this.sdvDiamondHighLight.setRectangle(this.vDiamondHighLight.getX(), this.vDiamondHighLight.getY(), this.vDiamondHighLight.getWidth(), this.vDiamondHighLight.getHeight(), this.getResources().getDimension(R.dimen.book_reader_diamond_size));
        return false;
    }

    public void onStop() {
        super.onStop();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tvNextOne) {
            this.dismiss();
        }
    }

    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play((Uri)Uri.parse((String)("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId)));
        }
    }

    private void dismiss() {
        AudioPlayer.stopPlay();
        this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        ((BookReaderActivity)this.getActivity()).getReaderControler().resume();
    }

    class ShowGuideIdleOnce
    implements MessageQueue.IdleHandler {
        ShowGuideIdleOnce() {
        }

        public boolean queueIdle() {
            if (CourseSecondGuideFragment.this.isDetached()) {
                return false;
            }
            return CourseSecondGuideFragment.this.resetGuide();
        }
    }
}

