/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.book.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConcurrentTotalFileSize {
    private SubDirectoriesAndSize getTotalAndSubDirs(File file) {
        long total = 0L;
        ArrayList<File> subDirectories = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (child.isFile()) {
                        total += child.length();
                        continue;
                    }
                    subDirectories.add(child);
                }
            }
        } else {
            total += file.length();
        }
        return new SubDirectoriesAndSize(total, subDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalSizeOfFilesInDir(File file) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService service = Executors.newFixedThreadPool(100);
        try {
            long total = 0L;
            ArrayList<File> directories = new ArrayList<File>();
            directories.add(file);
            while (!directories.isEmpty()) {
                ArrayList<Future<SubDirectoriesAndSize>> partialResults = new ArrayList<Future<SubDirectoriesAndSize>>();
                for (final File file2 : directories) {
                    partialResults.add(service.submit(new Callable<SubDirectoriesAndSize>(){

                        @Override
                        public SubDirectoriesAndSize call() {
                            return ConcurrentTotalFileSize.this.getTotalAndSubDirs(file2);
                        }
                    }));
                }
                directories.clear();
                for (Future future : partialResults) {
                    SubDirectoriesAndSize subDirectoriesAndSize = (SubDirectoriesAndSize)future.get(100L, TimeUnit.SECONDS);
                    directories.addAll(subDirectoriesAndSize.subDirectories);
                    total += subDirectoriesAndSize.size;
                }
            }
            long l = total;
            return l;
        }
        finally {
            service.shutdown();
        }
    }

    class SubDirectoriesAndSize {
        public final long size;
        public final List<File> subDirectories;

        public SubDirectoriesAndSize(long totalSize, List<File> theSubDirs) {
            this.size = totalSize;
            this.subDirectories = Collections.unmodifiableList(theSubDirs);
        }
    }
}

