/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.biz;

import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.bean.FeedbackBean;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.bean.ReadRecord;
import com.ellabook.project.ellareader.bean.ReadRecordlra;
import com.ellabook.project.ellareader.bean.StoneNum;
import com.ellabook.project.ellareader.bean.StoneResult;
import com.ellabook.project.ellareader.biz.ApiRead;
import com.ellabook.project.ellareader.biz.BizReadDataBase;
import com.google.gson.Gson;
import com.trello.rxlifecycle2.LifecycleTransformer;
import ellax.base.helper.AppExecutors;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class BizReader {
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();
    List<ReadRecordlra> uploadingIra = Collections.synchronizedList(new ArrayList());
    List<ReadRecord> uploading = Collections.synchronizedList(new ArrayList());

    private BizReader() {
    }

    public static BizReader getInstance() {
        return Holder.sBizMission;
    }

    public void getWordDetails(LifecycleTransformer lifecycleTransformer, String uid, String word, String bookCode, int pageId, HttpServiceCallBack<HttpWordDetails> callback) {
        Map map = EllaHttpService.createReuestMap();
        map.put("uid", uid);
        map.put("word", word);
        map.put("bookCode", bookCode);
        map.put("pageId", pageId);
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).getWordDetails(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public void uploadAnswerRecord(LifecycleTransformer lifecycleTransformer, long id2, int totalNum, String json, HttpServiceCallBack<StoneResult> callback) {
        Map map = EllaHttpService.createReuestMap();
        map.put("id", id2);
        map.put("totalNum", totalNum);
        map.put("jsonContent", json);
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).uploadAnswerRecord(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public void getStoneNums(LifecycleTransformer<List<StoneNum>> lifecycleTransformer, long id2, HttpServiceCallBack<List<StoneNum>> callback) {
        Map map = EllaHttpService.createReuestMap();
        map.put("id", id2);
        EllaHttpService.handleRequest(lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).getStoneNums(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public void addUserWord(LifecycleTransformer lifecycleTransformer, String bookCode, String missionCode, int pageNum, String sentence, String word, String ellaSpeechUrl, HttpServiceCallBack callBack) {
        Map map = EllaHttpService.createReuestMap();
        map.put("bookCode", bookCode);
        map.put("missionCode", missionCode);
        map.put("pageNum", pageNum);
        map.put("sentence", sentence);
        map.put("word", word);
        map.put("ellaSpeechUrl", ellaSpeechUrl);
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).addUserWord(EllaHttpService.generateRequestBody((Map)map)), (HttpServiceCallBack)callBack);
    }

    public static SimpleDateFormat getDataFormat() {
        if (dateFormat.get() == null) {
            dateFormat.set(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        return dateFormat.get();
    }

    public void uploadReadInfoMission(final LifecycleTransformer lifecycleTransformer, final long missionId, final String bookCode, final int pageNum, final int totalPage, final ArrayList<String> readStartEnds, final HttpServiceCallBack<Boolean> callback) {
        AppExecutors.diskIO((Runnable)new Runnable(){

            @Override
            public void run() {
                BizReader.this.uploadReadInfoMissionAsync(lifecycleTransformer, missionId, bookCode, pageNum, totalPage, readStartEnds, (HttpServiceCallBack<Boolean>)callback);
            }
        });
    }

    public void uploadReadInfoMissionAsync(LifecycleTransformer lifecycleTransformer, long missionId, String bookCode, int pageNum, int totalPage, ArrayList<String> readStartEnds, final HttpServiceCallBack<Boolean> callback) {
        ArrayList<ReadRecordStartEnd> readStartEndMap = new ArrayList<ReadRecordStartEnd>();
        int i = 0;
        while (i + 1 < readStartEnds.size()) {
            try {
                long start = Long.parseLong(readStartEnds.get(i));
                long end = Long.parseLong(readStartEnds.get(i + 1));
                if (end > start) {
                    readStartEndMap.add(new ReadRecordStartEnd(start, end));
                }
            }
            catch (Exception start) {
                // empty catch block
            }
            i += 2;
        }
        final ReadRecordlra current = ReadRecordlra.build(missionId, new Gson().toJson(readStartEndMap), UserInfoProvider.getUserId());
        ArrayList<ReadRecordlra> needUpload = new ArrayList<ReadRecordlra>();
        needUpload.add(current);
        final List<ReadRecordlra> unuploaded = BizReadDataBase.getInstance().readRecordlrdDao().queryUnuploaded(UserInfoProvider.getUserId());
        if (unuploaded != null && !unuploaded.isEmpty()) {
            unuploaded.removeAll(this.uploadingIra);
        }
        if (unuploaded != null && !unuploaded.isEmpty()) {
            this.uploadingIra.addAll(unuploaded);
            needUpload.addAll(unuploaded);
        }
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).uploadReadInfoMissionBatch(BizReader.generateRequestBody(needUpload)), (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean o) {
                AppExecutors.diskIO((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (unuploaded != null && !unuploaded.isEmpty()) {
                            for (ReadRecordlra readRecord : unuploaded) {
                                BizReadDataBase.getInstance().readRecordlrdDao().delete(readRecord.uid, readRecord.missionId, readRecord.readStartEnds);
                            }
                            BizReader.this.uploadingIra.removeAll(unuploaded);
                        }
                    }
                });
                if (callback != null) {
                    callback.onHttpServiceFinished((Object)o);
                }
            }

            public void onHttpServiceError(int i, String s) {
                if (unuploaded != null && !unuploaded.isEmpty()) {
                    BizReader.this.uploadingIra.removeAll(unuploaded);
                }
                AppExecutors.diskIO((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BizReadDataBase.getInstance().readRecordlrdDao().insert(current);
                    }
                });
                if (callback != null) {
                    callback.onHttpServiceError(i, s);
                }
            }
        });
    }

    public static RequestBody generateRequestBody(ArrayList arrayList) {
        try {
            Gson gson = new Gson();
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)gson.toJson((Object)arrayList));
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return null;
        }
    }

    public void uploadReadInfoEnBook(final LifecycleTransformer lifecycleTransformer, final String bookCode, final int pageNum, final int totalPage, final long readStart, final long endTime, final HttpServiceCallBack<Boolean> callback) {
        AppExecutors.diskIO((Runnable)new Runnable(){

            @Override
            public void run() {
                BizReader.this.uploadReadInfoEnBookAsync(lifecycleTransformer, bookCode, pageNum, totalPage, readStart, endTime, (HttpServiceCallBack<Boolean>)callback);
            }
        });
    }

    public void uploadReadInfoEnBookAsync(LifecycleTransformer lifecycleTransformer, String bookCode, int pageNum, int totalPage, long readStart, long endTime, final HttpServiceCallBack<Boolean> callback) {
        final ReadRecord current = ReadRecord.build(bookCode, pageNum, totalPage, readStart, endTime, UserInfoProvider.getUserId());
        ArrayList<ReadRecord> needUpload = new ArrayList<ReadRecord>();
        needUpload.add(current);
        final List<ReadRecord> unuploaded = BizReadDataBase.getInstance().readRecordDao().queryUnuploaded(UserInfoProvider.getUserId());
        if (unuploaded != null && !unuploaded.isEmpty()) {
            unuploaded.removeAll(this.uploading);
        }
        if (unuploaded != null && !unuploaded.isEmpty()) {
            this.uploading.addAll(unuploaded);
            needUpload.addAll(unuploaded);
        }
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).uploadReadInfoBatch(BizReader.generateRequestBody(needUpload)), (HttpServiceCallBack)new HttpServiceCallBack<Boolean>(){

            public void onHttpServiceFinished(Boolean o) {
                AppExecutors.diskIO((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (unuploaded != null && !unuploaded.isEmpty()) {
                            for (ReadRecord readRecord : unuploaded) {
                                BizReadDataBase.getInstance().readRecordDao().delete(readRecord.uid, readRecord.bookCode, readRecord.readModel, readRecord.pageNum, readRecord.totalPage, readRecord.readStart, readRecord.endTime);
                            }
                            BizReader.this.uploading.removeAll(unuploaded);
                        }
                    }
                });
                if (callback != null) {
                    callback.onHttpServiceFinished((Object)o);
                }
            }

            public void onHttpServiceError(int i, String s) {
                if (unuploaded != null && !unuploaded.isEmpty()) {
                    BizReader.this.uploading.removeAll(unuploaded);
                }
                AppExecutors.diskIO((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BizReadDataBase.getInstance().readRecordDao().insert(current);
                    }
                });
                if (callback != null) {
                    callback.onHttpServiceError(i, s);
                }
            }
        });
    }

    public void uploadCourseStoneNum(LifecycleTransformer lifecycleTransformer, String bookCode, int stoneNum, HttpServiceCallBack<Boolean> callback) {
        Map map = EllaHttpService.createReuestMap();
        map.put("bookCode", bookCode);
        map.put("stoneNum", stoneNum);
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).uploadCourseStoneNum(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public void bookStatus(LifecycleTransformer lifecycleTransformer, String bookCode, Long missionId, HttpServiceCallBack<Boolean> callback) {
        Map map = EllaHttpService.createReuestMap();
        map.put("bookCode", bookCode);
        map.put("uid", UserInfoProvider.getUserId());
        if (missionId != null) {
            map.put("missionId", missionId);
        }
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).bookStatus(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public void getFeedBackList(LifecycleTransformer lifecycleTransformer, HttpServiceCallBack<List<FeedbackBean>> callback) {
        Map map = EllaHttpService.createReuestMap();
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).feedbackList(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public void commitFeedback(LifecycleTransformer lifecycleTransformer, int recoveryType, String content, String explains, String bookCode, String pageId, HttpServiceCallBack<Object> callback) {
        Map map = EllaHttpService.createReuestMap();
        map.put("recoveryType", recoveryType);
        map.put("content", content);
        map.put("explains", explains);
        map.put("bookCode", bookCode);
        map.put("pageId", pageId);
        map.put("uid", UserInfoProvider.getUserId());
        EllaHttpService.handleRequest((LifecycleTransformer)lifecycleTransformer, ((ApiRead)EllaHttpService.buildInterfaceImpl(ApiRead.class)).commitFeedback(EllaHttpService.generateRequestBody((Map)map)), callback);
    }

    public static class ReadRecordStartEnd {
        public Long start;
        public Long end;

        public ReadRecordStartEnd() {
        }

        public ReadRecordStartEnd(Long start, Long end) {
            this.start = start;
            this.end = end;
        }
    }

    private static class Holder {
        private static BizReader sBizMission = new BizReader();

        private Holder() {
        }
    }
}

